<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="no-margin">
                                    <i class="fa fa-calendar-check-o"></i>
									<?php
									echo _l('daily_progress'); ?> -
                                    <a href="<?php
									echo admin_url('trade_job_management/jobs/show/'.$job->jobid); ?>">
										<?php
										echo $job->job_title; ?>
                                    </a>
                                </h4>
                                <hr class="hr-panel-heading"/>
                            </div>
                        </div>

                        <!-- Statistics -->
                        <div class="row">
                            <div class="col-md-4 col-sm-6">
                                <div class="tw-mb-2 sm:tw-mb-4">
                                    <div class="tw-flex tw-items-center">
                                        <div class="tw-flex-1">
                                            <p class="text-dark tw-mb-0 tw-font-medium">
												<?php
												echo _l('total_daily_logs'); ?>
                                            </p>
                                            <h3 class="tw-my-0 tw-font-semibold tw-text-xl">
												<?php
												echo $statistics['total_logs']; ?>
                                            </h3>
                                        </div>
                                        <div>
                                            <i class="fa fa-file-text-o fa-3x text-muted"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="tw-mb-2 sm:tw-mb-4">
                                    <div class="tw-flex tw-items-center">
                                        <div class="tw-flex-1">
                                            <p class="text-dark tw-mb-0 tw-font-medium">
												<?php
												echo _l('total_days_logged'); ?>
                                            </p>
                                            <h3 class="tw-my-0 tw-font-semibold tw-text-xl">
												<?php
												echo $statistics['total_days']; ?>
                                            </h3>
                                        </div>
                                        <div>
                                            <i class="fa fa-calendar fa-3x text-muted"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="tw-mb-2 sm:tw-mb-4">
                                    <div class="tw-flex tw-items-center">
                                        <div class="tw-flex-1">
                                            <p class="text-dark tw-mb-0 tw-font-medium">
												<?php
												echo _l('total_photos_uploaded'); ?>
                                            </p>
                                            <h3 class="tw-my-0 tw-font-semibold tw-text-xl">
												<?php
												echo $statistics['total_photos']; ?>
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mtop15">
                            <div class="col-md-12">
                                <a href="<?php
								echo admin_url('trade_job_management/jobs/show/'.$job->jobid); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> <?php
									echo _l('back_to_job'); ?>
                                </a>
                                <a href="<?php
								echo admin_url('trade_job_management/jobs/submit_daily_log/'.$job->jobid); ?>" class="btn btn-primary">
                                    <i class="fa fa-plus"></i> <?php
									echo _l('submit_daily_log'); ?>
                                </a>

                                <hr/>
                            </div>
                        </div>

                        <!-- Daily Logs List -->
                        <div class="row">
                            <div class="col-md-12">
								<?php
								if (empty($daily_logs))
								{ ?>
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> <?php
										echo _l('no_daily_logs'); ?>
                                    </div>
									<?php
								} else
								{ ?>
									<?php
									$daily_log_grouped = [];
									foreach ($daily_logs as $daily_log)
									{
										$daily_log_grouped[$daily_log['log_date']][] = $daily_log;
									}
									krsort($daily_log_grouped, SORT_DESC);
									foreach ($daily_log_grouped as $date => $logs)
									{
										$collapseName = 'collapse'.$date;
										?>

                                        <a class="btn btn-primary tw-w-full mbot10" data-toggle="collapse" href="#<?php
										echo $collapseName ?>"
                                           role="button" aria-expanded="false" aria-controls="<?php
										echo $collapseName ?>">
                                            <h4 class="tw-mt-4 tw-mb-3 tw-text-left">
                                                <i class="fa fa-calendar"></i>
												<?php
												echo _d($date); ?>
                                            </h4>
                                        </a>
                                        <div class="collapse" id="<?php
										echo $collapseName ?>">
											<?php
											foreach ($logs as $log): ?>
                                                <div class="panel panel-default tw-mb-3">
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="pull-right">
															<span class="label label-<?php
															echo $log['is_visible_to_customer'] == 1 ? 'success' : 'warning'; ?>">
																<?php
																echo $log['is_visible_to_customer'] == 1 ? _l('visible_to_customer') : _l('internal_only'); ?>
															</span>
																	<?php
																	if (date('Y-m-d', strtotime($log['log_date'])) == date('Y-m-d'))
																	{ ?>
                                                                        <a href="<?php
																		echo admin_url('trade_job_management/jobs/edit_daily_log/'.$log['daily_log_id']); ?>" class="btn btn-sm btn-default">
                                                                            <i class="fa fa-edit"></i> <?php
																			echo _l('edit'); ?>
                                                                        </a>
                                                                        <a href="<?php
																		echo admin_url('trade_job_management/jobs/delete_daily_log/'.$log['daily_log_id']); ?>"
                                                                           class="btn btn-sm btn-danger _delete"
                                                                           onclick="return confirm('<?php
																		   echo _l('confirm_delete_daily_log'); ?>');">
                                                                            <i class="fa fa-trash"></i> <?php
																			echo _l('delete'); ?>
                                                                        </a>
																		<?php
																	} ?>
                                                                </div>
                                                                <p class="text-muted">
                                                                    <i class="fa fa-user"></i> <?php
																	echo _l('daily_log_by'); ?>
                                                                    <strong><?php
																		echo $log['staff_full_name']; ?></strong>
																	<?php
																	echo _l('daily_log_on'); ?>
																	<?php
																	echo _dt($log['created_at']); ?>
                                                                </p>
                                                            </div>
                                                        </div>

                                                        <div class="row mtop10">
                                                            <div class="col-md-12">
                                                                <div class="well">
																	<?php
																	echo $log['comments']; ?>
                                                                </div>
                                                            </div>
                                                        </div>

														<?php
														if ( ! empty($log['photos']))
														{ ?>
                                                            <div class="row mtop10">
                                                                <div class="col-md-12">
                                                                    <h5><i class="fa fa-camera"></i> <?php
																		echo _l('photos'); ?> (<?php
																		echo count($log['photos']); ?>)</h5>
                                                                    <div class="row">
																		<?php
																		foreach ($log['photos'] as $photo)
																		{ ?>
                                                                            <div class="col-md-2 col-sm-3 col-xs-6 tw-mb-3 padding-5">
                                                                                <div class="thumbnail tw-flex tw-flex-col" style="min-height: 200px;">
																					<?php
																					$file_path = get_upload_path_by_type('job').$job->jobid.'/daily_logs/'.$photo['file_name'];
																					$download_url  = site_url('trade_job_management/download/file/job_daily_log/'.$photo['attachment_key']);
																					$photo_url = site_url(
																						'trade_job_management/download/preview_image?path='.protected_file_url_by_path($file_path),
																					);

																					?>
                                                                                    <a href="<?php
																					echo $photo_url ?>" class="lightbox tw-relative" data-lightbox="daily-log-<?php
																					echo $log['daily_log_id']; ?>">
																						<?php
																						if (is_image(get_upload_path_by_type('job').$job->jobid.'/daily_logs/'.$photo['file_name']))
																						{ ?>
                                                                                            <img src="<?php
																							echo $photo_url ?>" class="img-responsive"
                                                                                                 style="width: 100%; height: 150px; object-fit: cover;">
																							<?php
																						} else
																						{ ?>
                                                                                            <div class="text-center" style="padding: 20px;">
                                                                                                <i class="<?php
																								echo get_mime_class($photo['filetype']); ?> fa-4x"></i>
                                                                                            </div>
																							<?php
																						} ?>
                                                                                    </a>
                                                                                    <div class="caption text-center">
                                                                                        <small class="tw-text-wrap tw-break-words"><?php
																							echo $photo['file_name']; ?></small>
                                                                                        <div class="mtop5">
                                                                                            <a class="btn btn-default tw-w-full" href="<?php echo $download_url ?>"><?php echo _l('download') ?></a>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
																			<?php
																		} ?>
                                                                    </div>
                                                                </div>
                                                            </div>
															<?php
														} ?>
                                                    </div>
                                                </div>
											<?php
											endforeach; ?>
                                        </div>
										<?php
									}
								} ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
init_tail(); ?>
</body>
</html>
