<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Trade Job Management
Description: Change Perfex to a trade job management CRM to manage your trade work based on jobs relating to real estate properties.
Version: 1.5.1
Requires at least: 1.0.*
*/

const TRADE_JOB_MANAGEMENT_MODULE_NAME = 'trade_job_management';

$CI = &get_instance();

$CI->load->helper(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/trade_job_management');
$CI->load->helper(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/migration_log');
$CI->load->helper(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/tjm_permissions_management');
$CI->load->helper(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/tjm_job');

$CI->load->library(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/merge_fields/landlord_merge_fields');
$CI->load->library(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/merge_fields/jobs_merge_fields');

require_once(APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/libraries/mails/Job_status_changed_to_customer.php');
require_once(APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/libraries/mails/Job_status_changed_to_staff.php');
require_once(APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/libraries/mails/Job_daily_log_added.php');

register_merge_fields([APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/libraries/merge_fields/jobs_merge_fields']);
register_merge_fields(
	[APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/libraries/merge_fields/landlord_merge_fields'],
);

register_language_files(TRADE_JOB_MANAGEMENT_MODULE_NAME, [TRADE_JOB_MANAGEMENT_MODULE_NAME]);

/**
 * Register activation module hook
 */
register_activation_hook(TRADE_JOB_MANAGEMENT_MODULE_NAME, TRADE_JOB_MANAGEMENT_MODULE_NAME.'_module_activation_hook');

/**
 * Register uninstall module hook
 */
register_uninstall_hook(TRADE_JOB_MANAGEMENT_MODULE_NAME, TRADE_JOB_MANAGEMENT_MODULE_NAME.'_module_uninstall_hook');

function trade_job_management_module_activation_hook()
{
	require_once(__DIR__.'/install.php');
}

function trade_job_management_module_uninstall_hook()
{
	require_once(__DIR__.'/uninstall.php');
}

function tjm_zegaware_check_license()
{
	require_once(__DIR__.'/zegaware_license.php');

	$request_uri = $_SERVER['REQUEST_URI'];

	if (
		str_contains($request_uri, '/admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME)
		&& ! str_contains($request_uri, '/admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/license')
	)
	{
		$is_activated = Zegaware_License::is_activated(TRADE_JOB_MANAGEMENT_MODULE_NAME);

		if ( ! $is_activated && ! str_contains($request_uri, '/admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/license'))
		{
			redirect(admin_url(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/license'));
			exit();
		} elseif ($is_activated)
		{
			$last_validate = get_option(TRADE_JOB_MANAGEMENT_MODULE_NAME.'_last_validate');
			if (empty($last_validate))
			{
				validate_zegaware_license();
			} else
			{
				$last_validate = json_decode($last_validate);

				if ( ! isset($last_validate->date) || $last_validate->date != date('Y-m-d'))
				{
					validate_zegaware_license();
				}
			}
		}
	}
}

hooks()->add_action('admin_init', 'tjm_zegaware_check_license');

function validate_zegaware_license(): bool
{
	$validated = Zegaware_License::validate_current_license(TRADE_JOB_MANAGEMENT_MODULE_NAME);
	if ( ! $validated)
	{
		update_option(
			TRADE_JOB_MANAGEMENT_MODULE_NAME.'_last_validate',
			json_encode(['date' => date('Y-m-d'), 'msg' => 'error']),
		);
		set_alert('danger', _l('require_license'));
		redirect(admin_url(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/license'));
	}

	return $validated;
}

function tjm_add_license_link_to_module_list(array $action_links)
{
	$action_links[] = '<a href="'.admin_url(TRADE_JOB_MANAGEMENT_MODULE_NAME.'/license').'">'._l('tjm_zegaware_license').'</a>';

	return $action_links;
}

hooks()->add_filter("module_trade_job_management_action_links", 'tjm_add_license_link_to_module_list');

function trade_job_management_init_menu_items()
{
	$CI = &get_instance();

	/** @var App_menu $menu */
	$menu = $CI->app_menu;
	$menu->add_sidebar_menu_item('landlords', [
		'name'     => _l('landlords'),
		'href'     => admin_url('trade_job_management/landlords'),
		'position' => 40,
		'icon'     => 'fa-regular fa-user',
		'badge'    => [],
	]);

	$menu->add_sidebar_menu_item('properties', [
		'name'     => _l('properties'),
		'href'     => admin_url('trade_job_management/properties'),
		'position' => 41,
		'icon'     => 'fa-solid fa-chart-gantt',
		'badge'    => [],
	]);

	$menu->add_sidebar_menu_item('jobs', [
		'name'     => _l('jobs'),
		'href'     => admin_url('trade_job_management/jobs'),
		'position' => 42,
		'icon'     => 'fa-regular fa-circle-check',
		'badge'    => [],
	]);
}

hooks()->add_action('admin_init', 'trade_job_management_init_menu_items', 20);

function trade_job_management_init_licence_menu_item()
{
	if (is_admin())
	{
		$CI = &get_instance();

		$CI->app_menu->add_sidebar_menu_item('tjm-api-clients', [
			'name'     => _l('tjm_api_clients'), // The name if the item
			'href'     => admin_url('trade_job_management/clients'), // URL of the item
			'position' => 32,
			'icon'     => 'fa fa-globe', // Font awesome icon
		]);
	}
}

hooks()->add_action('admin_init', 'trade_job_management_init_licence_menu_item', 20);

function add_trade_job_management_tables(): void
{
	App_table::register(
		App_table::new('landlords', 'modules/trade_job_management/views/tables/landlords.php'),
	);

	App_table::register(
		App_table::new('properties', 'modules/trade_job_management/views/tables/properties.php'),
	);

	App_table::register(
		App_table::new('jobs', 'modules/trade_job_management/views/tables/jobs.php'),
	);

	App_table::register(
		App_table::new('api_clients', 'modules/trade_job_management/views/tables/api_clients.php'),
	);
}

hooks()->add_action('admin_init', 'add_trade_job_management_tables');

function redirect_trade_job_management_routes(): void
{
	$request_uri = $_SERVER['REQUEST_URI'];

	if (str_contains($request_uri, '/admin/projects/') && empty($_POST ?? ''))
	{
		$request_uri = str_replace(
			'admin/projects/',
			'admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/properties/',
			$request_uri,
		);
		redirect($request_uri);
		die();
	}

	if (str_contains($request_uri, '/admin/projects/staff_projects') && ! empty($_POST ?? ''))
	{
		$request_uri = str_replace(
			'admin/projects/',
			'admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/properties/',
			$request_uri,
		);

		redirect($request_uri);
		die();
	}

	if (str_contains($request_uri, '/admin/tasks/list_tasks') && ! empty($_POST ?? ''))
	{
		$request_uri = str_replace(
			'admin/jobs/list_tasks',
			'admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/jobs/',
			$request_uri,
		);

		redirect($request_uri);
		die();
	}

	if (str_ends_with($request_uri, '/admin/emails') && empty($_POST ?? ''))
	{
		$request_uri = str_replace(
			'admin/emails',
			'admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/emails',
			$request_uri,
		);

		redirect($request_uri);
		die();
	}

	if (str_contains($request_uri, '/admin/tasks/get_billable_task_data/') && empty($_POST ?? ''))
	{
		$request_uri = str_replace(
			'admin/tasks/get_billable_task_data/',
			'admin/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/jobs/get_billable_job_data/',
			$request_uri,
		);

		redirect($request_uri);
		die();
	}
}

//hooks()->add_action('admin_init', 'redirect_trade_job_management_routes');

function add_email_to_contact_column(array $columns)
{
	if (($pos = array_search('email', $columns)) !== FALSE)
	{
		unset($columns[$pos]);
	}

	return $columns;
}

hooks()->add_filter('contact_columns', 'add_email_to_contact_column');

function trade_job_management_add_custom_styles()
{ ?>
    <style>
        .task-modal-single .task-comment {
            border: 2px solid #eee;
            border-radius: 4px;
            background: white;
        }

        .job-info {
            padding: 6px;
        }

        .job-info .job-info-icon {
            text-align: center;
            margin-left: -10px;
            margin-right: 9px;
            font-size: 16px;
            color: #9ca3af;
            min-width: 20px;
        }

        .job-info h5 {
            font-size: 14px;
            margin: 0;
            font-weight: 400;
            color: #6b7280;
        }
    </style>
	<?php
}

hooks()->add_action('app_admin_head', 'trade_job_management_add_custom_styles');

function trade_job_management_add_custom_scripts()
{ ?>
    <script>
        $(function () {
            const searchWrapper = $('#top_search').parent();
            if (searchWrapper !== undefined) {
                $(searchWrapper).find('ul').remove();
            }

            const widgetUserData = $('#widget-user_data');
            if (widgetUserData !== undefined) {
                $(widgetUserData).remove();
            }

        });
    </script>
	<?php
}

hooks()->add_action('app_admin_footer', 'trade_job_management_add_custom_scripts');

function add_invoice_job_modal_to_admin_footer()
{
	?>

    <!-- Modal -->
    <div class="modal fade" id="invoice-job-modal" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel">
        <div class="modal-dialog <?= get_option('lead_modal_class'); ?>" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Invoice Job</h4>
                </div>
				<?php
				form_open('abc') ?>

                <div class="modal-body">
                </div>
				<?php
				form_close() ?>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary btn-submit">Save</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(function () {
            $('#invoice-job-modal').on('show.bs.modal', function (e) {
                // Init accountacy currency symbol
                init_currency();
                // Project ajax search
                // Maybe items ajax search
                init_ajax_search('items', '#item_select.ajax-search', undefined, admin_url + 'items/search');
                $('#clientid').trigger('change')
                setTimeout(function () {
                    $("#project_id").val(3)
                    $('#project_id').trigger('change')
                }, 100)
            })
            $('#invoice-job-modal').on('click', '.btn-submit', function (e) {
                $('#invoice-job-modal form').submit();
            })


        });
    </script>
	<?php
}

hooks()->add_action('app_admin_footer', 'add_invoice_job_modal_to_admin_footer');

function add_jobs_to_other_merge_fields_available_for($for)
{
	$for[] = 'jobs';

	return $for;
}

hooks()->add_filter('other_merge_fields_available_for', 'add_jobs_to_other_merge_fields_available_for');

hooks()->add_filter('csrf_exclude_uris', function ($current) {
	$uris = ['trade_job_management/apis/jobs'];

	return array_merge($current, $uris);
}, 20);

function tjm_add_landlord_to_relation_data($data, $args)
{
	$type   = $args['type'];
	$rel_id = $args['rel_id'];
	if ($type === 'landlord')
	{
		$path = APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/models/Landlords_model.php';

		require_once($path);
		$CI = &get_instance();
		$CI->load->model('landlords_model');
		$data = $CI->landlords_model->get($rel_id);
	}

	return $data;
}

hooks()->add_filter('get_relation_data', 'tjm_add_landlord_to_relation_data', 10, 2);

function tjm_add_landlord_to_relation_values($data)
{
	$type = $data['type'];
	if ($type === 'landlord')
	{
		/** @var array $relation */
		$relation     = (array)$data['relation'];
		$data['id']   = $relation['landlordid'];
		$data['name'] = $relation['first_name'].' '.$relation['last_name'];
	}

	return $data;
}

hooks()->add_filter('relation_values', 'tjm_add_landlord_to_relation_values');

function tjm_add_property_to_relation_data($data, $args)
{
	$type   = $args['type'];
	$rel_id = $args['rel_id'];
	if ($type === 'property')
	{
		$path = APP_MODULES_PATH.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/models/Properties_model.php';

		require_once($path);
		$CI = &get_instance();
		$CI->load->model('properties_model');

		if ($rel_id != '')
		{
			$data = $CI->properties_model->get($rel_id);
		} else
		{
			$q = '';

			if ($CI->input->post('q'))
			{
				$q = $CI->input->post('q');
				$q = trim($q);
			}

			$search = $CI->properties_model->search_properties($q);
			$data   = $search['result'];
		}
	}

	return $data;
}

hooks()->add_filter('get_relation_data', 'tjm_add_property_to_relation_data', 10, 2);

function tjm_add_property_to_relation_values($data)
{
	if ($data['type'] === 'property')
	{
		/** @var array $relation */
		$relation     = (array)$data['relation'];
		$data['id']   = $relation['propertyid'];
		$data['name'] = $relation['property_name'];
	} elseif ($data['type'] === 'landlord')
	{
		$relation     = (array)$data['relation'];
		$data['id']   = $relation['landlordid'];
		$data['name'] = $relation['first_name'].' '.$relation['last_name'];
	}

	return $data;
}

hooks()->add_filter('relation_values', 'tjm_add_property_to_relation_values');

function tjm_add_property_type_to_get_upload_path_by_type($path, $type)
{
	if ($type === 'property')
	{
		return FCPATH.'modules/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/uploads/properties/';
	}

	if ($type === 'job')
	{
		return FCPATH.'modules/'.TRADE_JOB_MANAGEMENT_MODULE_NAME.'/uploads/jobs/';
	}

	if ($type === 'signature')
	{
		return FCPATH.'/uploads/jobs/';
	}

	return $path;
}

hooks()->add_filter('get_upload_path_by_type', 'tjm_add_property_type_to_get_upload_path_by_type', 10, 2);

hooks()->add_action('before_js_scripts_render', function () {
	?>
    <!-- Job modal view -->
    <div class="modal fade task-modal-single" id="job-modal" tabindex="-1" role="dialog"
         aria-labelledby="myLargeModalLabel">
        <div
                class="modal-dialog <?= get_option('task_modal_class'); ?>">
            <div class="modal-content data">

            </div>
        </div>
    </div>
	<?php
});

