<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Job_types_model extends App_Model {

	public function add($data)
	{
		$data['created_by'] = get_staff_user_id();
		$data['created_at'] = date('Y-m-d H:i:s');
		$data['updated_at'] = date('Y-m-d H:i:s');

		$this->db->insert(db_prefix().'tjm_job_types', $data);
		$insert_id = $this->db->insert_id();
		if ($insert_id)
		{
			log_activity('New Job Type Created [ID: '.$insert_id.']');

			return $insert_id;
		}

		return FALSE;
	}

	public function get($id = '', $active_only = FALSE)
	{
		if (is_numeric($id))
		{
			$this->db->where('jobtypeid', $id);

			return $this->db->get(db_prefix().'tjm_job_types')->row();
		}

		if ($active_only)
		{
			$this->db->where('status', 1);
		}

		$this->db->order_by('type_name', 'asc');

		return $this->db->get(db_prefix().'tjm_job_types')->result_array();
	}

	public function get_by_name($name, $active_only = FALSE)
	{
		$this->db->where('type_name', $name);

		return $this->db->get(db_prefix().'tjm_job_types')->row();
	}

	public function update($data, $id)
	{
		$data['updated_at'] = date('Y-m-d H:i:s');
		$this->db->where('jobtypeid', $id);

		return $this->db->update(db_prefix().'tjm_job_types', $data);
	}

	public function delete($id)
	{
		return $this->db->where('jobtypeid', $id)->delete(db_prefix().'tjm_job_types');
	}

}
