<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Job_nte_logs_model extends App_Model {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('jobs_model');
		$this->load->model('staff_model');
	}

	public function add($data)
	{
		$data = array_merge($data, [
			'staff_id'   => get_staff_user_id(),
			'created_at' => date('Y-m-d H:i:s'),
		]);

		$this->db->insert(db_prefix().'tjm_job_nte_logs', $data);

		return $this->db->insert_id();
	}

	/**
	 * Get log by id
	 *
	 * @param  mixed  $id
	 *
	 * @return object
	 */
	public function get($id, $where = [])
	{
		$this->db->where('id', $id);
		$this->db->where($where);
		$log = $this->db->get(db_prefix().'tjm_job_nte_logs')->row();
		if ($log)
		{
			$log->staff = $this->get_log_staff($id);

			$log->job_data = $this->jobs_model->get($log->job_id);
		}

		return $log;
	}

	/**
	 * Get log by id
	 *
	 * @param  mixed  $job_id
	 *
	 * @return array
	 */
	public function get_by_job_id($job_id)
	{
		$this->db->where('job_id', $job_id);
		$this->db->order_by('created_at', 'desc');

		$logs = $this->db->get(db_prefix().'tjm_job_nte_logs')->result();

		$job_data = $this->jobs_model->get($job_id);
		foreach ($logs as $log)
		{
			$log->staff             = $this->get_log_staff($log->id);
			$log->old_nte_formatted = app_format_money($log->old_nte, get_base_currency());
			$log->new_nte_formatted = format_job_status($log->new_nte, get_base_currency());
			$log->job_data          = $job_data;
		}

		return $logs;
	}

	/**
	 * Get staff
	 *
	 * @param  int  $id  job id
	 *
	 * @return array|null
	 */
	public function get_log_staff($id)
	{
		$this->db->select('id,CONCAT(firstname, " ", lastname) as full_name');
		$this->db->join(db_prefix().'staff', db_prefix().'staff.staffid = '.db_prefix().'tjm_job_nte_logs.staff_id');
		$this->db->where('id', $id);
		$this->db->order_by('firstname', 'asc');

		return $this->db->get(db_prefix().'tjm_job_nte_logs')->row_array();
	}

}
