<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_149 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 149;

	public function up()
	{
		zegaware_add_migration_log($this->module_name, $this->version);
		$this->ci->db->where('job_hash', NULL);
		$rows = $this->ci->db->get(db_prefix().'tjm_jobs')->result_array();
		if ( ! empty($rows))
		{
			foreach ($rows as $row)
			{
				$job_hash = generate_job_hash($row);

				$this->ci->db->where('jobid', $row['jobid']);
				$this->ci->db->update(db_prefix().'tjm_jobs', [
					'job_hash' => $job_hash,
				]);
			}
		}
	}

	public function down()
	{
		zegaware_delete_migration_log($this->module_name, $this->version);
	}

}
