<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_109 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 109;

	public function up()
	{
		if ($this->ci->db->field_exists('email', db_prefix().'clients') && ! $this->ci->db->field_exists('contact_email', db_prefix().'clients'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'clients` CHANGE COLUMN `email` `contact_email` text');
		}

		if ($this->ci->db->field_exists('email', db_prefix().'clients'))
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'clients` DROP COLUMN `email`');
		}

		zegaware_add_migration_log($this->module_name, $this->version);
	}

	public function down()
	{
		if (
			$this->ci->db->field_exists('contact_email', db_prefix().'clients')
			&& ! $this->ci->db->field_exists('email', db_prefix().'clients')
		)
		{
			$this->ci->db->query('ALTER TABLE `'.db_prefix().'clients` CHANGE COLUMN `contact_email` `email` text');
		}

		zegaware_delete_migration_log($this->module_name, $this->version);
	}

	public function delete_migration_log()
	{
		$migration_exists = $this->ci
			->db
			->where('version', $this->version)
			->where('module', $this->module_name)
			->get(db_prefix().'module_migrations')
			->row();

		if ($migration_exists)
		{
			// Record the applied migration
			$this->ci->db->where('module', $this->module_name);
			$this->ci->db->where('version', $this->version);
			$this->ci->db->delete(db_prefix().'module_migrations');

			return $this->ci->db->affected_rows() > 0;
		}

		return FALSE;
	}

}
