<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Landlords extends AdminController
{
    protected const BASE_PATH = '/landlords';
    protected const PASSWORD_PREFIX = 'landlords_';

    public function __construct()
    {
        parent::__construct();

        $this->load->model('landlords_model');
        $this->load->model('clients_model');
    }

    /* List all clients */
    public function index()
    {
        if (staff_cant('view', 'landlords')) {
            access_denied('landlords');
        }

        $data['title'] = _l('landlords');

        $data['table'] = App_table::find('landlords');

        $this->load->view(static::BASE_PATH . '/index', $data);
    }

    public function table()
    {
        App_table::find('landlords')->output();
    }

    /* Edit client or add new client*/
    public function create()
    {
        $title = _l('add_new', _l('landlord_lowercase'));
        $data['bodyclass'] = 'customer-profile dynamic-create-groups';
        $data['title'] = $title;

        if ($this->input->post() && !$this->input->is_ajax_request()) {
            $data = $this->input->post();

            $landlord_email = $data['email'];
            $landlord = $this->landlords_model->get_landlord_by_email($landlord_email);
            if ($landlord) {
                set_alert('danger', _l('create_landlord_error_email_exists'));
                $this->load->view('landlords/create', $data);

                return;
            }
            $id = $this->landlords_model->add($data);

            if ($id) {
                $data['company'] = $data['first_name'] . ' ' . $data['last_name'];
                $data['contact_email'] = $data['email'];
                $data['phonenumber'] = $data['phone_number'];
                $data['billing_street'] = $data['address'];
                $data['billing_city'] = $data['city'];
                $data['billing_state'] = $data['state'];
                $data['billing_zip'] = $data['zip_code'];
                $data['billing_country'] = $data['country'];

                $data['shipping_street'] = $data['address'];
                $data['shipping_city'] = $data['city'];
                $data['shipping_state'] = $data['state'];
                $data['shipping_zip'] = $data['zip_code'];
                $data['shipping_country'] = $data['country'];

                $contact_data = [
                    'firstname' => $data['first_name'],
                    'lastname' => $data['last_name'],
                    'email' => $data['email'],
                    'phonenumber' => $data['phone_number'],
                    'password' => static::PASSWORD_PREFIX . rand(0, 1000000),
                    'is_primary' => true,
                    'invoice_emails' => true,
                    'estimate_emails' => true,
                    'task_emails' => true,
                    'project_emails' => true,
                ];

                unset($data['first_name']);
                unset($data['last_name']);
                unset($data['phone_number']);
                unset($data['email']);
                unset($data['zip_code']);

                $client_id = $this->clients_model->add($data);
                $this->clients_model->add_contact($contact_data, $client_id);

                $this->landlords_model->update_client_id($id, $client_id);

                set_alert('success', _l('added_successfully', _l('landlord_name')));
                redirect(admin_url('trade_job_management' . static::BASE_PATH . '/show/' . $id));
            } else {
                set_alert('error', _l('create_landlord_error'));
            }
        }

        $this->load->view('landlords/create', $data);
    }

    /* Edit client or add new client*/
    public function show($id = '')
    {
        $landlord = $this->landlords_model->get($id);
        $data['landlord'] = $landlord;

        if ($this->input->post() && !$this->input->is_ajax_request()) {
            $data = $this->input->post();
            $this->landlords_model->update($data, $id);

            if ($landlord->client_id) {
                $client_id = $landlord->client_id;
                $firstname = $data['first_name'];
                $lastname = $data['last_name'];
                $email = $data['email'];
                $phone_number = $data['phone_number'];

                $data['company'] = $firstname . ' ' . $lastname;
                $data['contact_email'] = $email;
                $data['phonenumber'] = $phone_number;
                $data['billing_street'] = $data['address'];
                $data['billing_city'] = $data['city'];
                $data['billing_state'] = $data['state'];
                $data['billing_zip'] = $data['zip_code'];
                $data['billing_country'] = $data['country'];

                $data['shipping_street'] = $data['address'];
                $data['shipping_city'] = $data['city'];
                $data['shipping_state'] = $data['state'];
                $data['shipping_zip'] = $data['zip_code'];
                $data['shipping_country'] = $data['country'];

                unset($data['client_id']);
                unset($data['first_name']);
                unset($data['last_name']);
                unset($data['phone_number']);
                unset($data['email']);
                unset($data['zip_code']);

                $contact_data = [
                    'firstname' => $firstname,
                    'lastname' => $lastname,
                    'email' => $email,
                    'phonenumber' => $phone_number,
                    'is_primary' => true,
                    'invoice_emails' => true,
                    'estimate_emails' => true,
                    'task_emails' => true,
                    'project_emails' => true,
                ];

                $this->clients_model->update($data, $client_id);
                $this->clients_model->update_contact($contact_data, $client_id);
            }

            set_alert('success', _l('updated_successfully', _l('landlord_name')));
            redirect(admin_url('trade_job_management' . static::BASE_PATH . '/show/' . $id));
        }

        $title = $landlord->first_name . ' ' . $landlord->last_name;

        $data['bodyclass'] = 'customer-profile dynamic-create-groups';
        $data['title'] = $title;
        $data['landlord_id'] = $id;

        /** Tab View */

        $landlord = $this->landlords_model->get($id);
        $clients = $this->clients_model->get();
        $clients = array_map(function ($client) {
            return [
                'userid' => $client['userid'],
                'company' => '#' . $client['userid'] . ' - ' . $client['company'],
            ];
        }, $clients);

        $data['clients'] = $clients;
        $data['landlord_tabs'] = get_landlord_profile_tabs();

        $group = !$this->input->get('group') ? 'profile' : $this->input->get('group');
        $data['group'] = $group;
        $data['tab'] = isset($data['landlord_tabs'][$group]) ? $data['landlord_tabs'][$group] : null;

        if (!$landlord) {
            show_404();
        }

        $this->load->view('landlords/show', $data);
    }

    /* Delete client */
    public function delete($id)
    {
        if (staff_cant('delete', 'customers')) {
            access_denied('customers');
        }
        if (!$id) {
            redirect(admin_url('trade_job_management' . static::BASE_PATH));
        }
        $response = $this->landlords_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('landlord_delete_transactions_warning', _l('invoices') . ', ' . _l('estimates') . ', ' . _l('credit_notes')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('landlord')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('landlord_lowercase')));
        }
        redirect(admin_url('trade_job_management' . static::BASE_PATH));
    }
}
