<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Download extends App_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->helper('download');
	}

	public function preview_image()
	{
		$path      = FCPATH.$this->input->get('path');
		$file_type = $this->input->get('type');

		$allowed_extensions = [
			'jpg',
			'jpeg',
			'png',
			'bmp',
			'gif',
			'tif',
		];

		$path_info = pathinfo($path);

		if ( ! file_exists($path) || ! isset($path_info['extension']) || ! in_array($path_info['extension'], $allowed_extensions))
		{
			$file_type = 'image/jpg';
			$path      = FCPATH.'assets/images/preview-not-available.jpg';
		}

		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename="'.basename($path).'"');
		header('Content-Type: '.$file_type);
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');

		if (ob_get_contents())
		{
			ob_end_clean();
		}

		hooks()->do_action('before_output_preview_image');
		$file = fopen($path, 'rb');
		if ($file !== FALSE)
		{
			while ( ! feof($file))
			{
				echo fread($file, 1024);
			}
			fclose($file);
		}
	}

	public function file($folder_indicator, $attachment_key = '')
	{
		$this->db->where('attachment_key', $attachment_key);
		$attachment = $this->db->get(db_prefix().'files')->row();
		if ( ! $attachment)
		{
			show_404();
		}

		if ($folder_indicator == 'job')
		{
			$path = get_upload_path_by_type('job').$attachment->rel_id.'/'.$attachment->file_name;
		} elseif ($folder_indicator == 'job_daily_log')
		{
			$this->db->where('daily_log_id', $attachment->rel_id);
			$daily_log = $this->db->get(db_prefix().'tjm_job_daily_logs')->row();

			$path = get_upload_path_by_type('job').$daily_log->job_id.'/daily_logs/'.$attachment->file_name;
		} else
		{
			exit('folder not specified');
		}

		$path = hooks()->apply_filters('tjm_download_file_path', $path, [
			'folder'       => $folder_indicator,
			'attachmentid' => $attachment_key,
		]);

		force_download($path, NULL);
	}

}
