<?php

defined('BASEPATH') or exit('No direct script access allowed');

return App_table::find('api_clients')
    ->outputUsing(function ($params) {
        extract($params);

        $this->ci->db->query("SET sql_mode = ''");

        $aColumns = [
            'id',
            'client_name',
            'client_id',
            'client_secret',
            'client_ip',
            'created_at',
        ];

        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'tjm_api_clients';
        $aColumns = hooks()->apply_filters('customers_table_sql_columns', $aColumns);

        $result = data_tables_init(
            $aColumns,
            $sIndexColumn,
            $sTable,
            [],
            [],
            [
                'id',
                'client_name',
                'client_id',
                'client_secret',
                'client_ip',
                'created_at',
            ],
        );

        $output = $result['output'];
        $rResult = $result['rResult'];

        foreach ($rResult as $aRow) {
            $row = array();

            // Bulk actions
            $row[] = $aRow['id'];

            $row[] = $aRow['client_name'];
            $row[] = $aRow['client_id'];

            $copy_text = _l('copy');
            $copied_text = _l('tjm_client_secret_copied');
            $action = "navigator.clipboard.writeText(this.dataset.link);this.innerHTML='$copied_text';setTimeout(() => { this.innerHTML = '$copy_text'}, 1000);";
            $row[] = '********** <a class="label" style="color:#22c55e;border:1px solid #a7e8bf;background: #f6fdf9;" onclick="' . $action . '" href="javascript:void(0)" data-link="' . $aRow['client_secret'] . '"> ' . $copy_text . '</a>';

            $row[] = $aRow['client_ip'];
            $row[] = $aRow['created_at'];

            $delete_url = admin_url('trade_job_management/clients/delete/' . $aRow['id']);
            $row[] = '<a class="label" style="color:#fa2819;border:1px solid #fa8c84;background: #f6fdf9;" onclick="return confirm(\'Are you sure you want to delete this client?\');" href="' . $delete_url . '"> ' . _l('delete') . '</a>';

            $output['aaData'][] = $row;
        }

        return $output;
    })
    ->setRules([]);
