<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var object $job */

/** @var object $property */
/** @var object $landlord */
/** @var array $activity_logs */

/** @var array $comments */
$comments = $job->comments;

/** @var array $specialists */
$specialists = $job->specialists;

/** @var array $specialist_ids */
$specialist_ids = $job->specialist_ids;

/** @var array $attachments */
$attachments = $job->attachments;

/** @var array $timesheets */
$timesheets = $job->timesheets;

$job_id = $job->jobid;

$total_cost = array_sum(array_column($timesheets, 'total'));
?>
<script>
    if (typeof jobId === 'undefined') {
        let jobId = <?= $job_id ?>
    } else {
        jobId = <?= $job_id ?>
    }
</script>
<div class="modal-header task-single-header" data-job-single-id="<?php
echo e($job->jobid); ?>"
     data-status="<?php
     echo e($job->status); ?>">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                aria-hidden="true">&times;</span></button>
    <h4 class="modal-title tw-flex tw-items-center">
		<?php
		echo e($job->job_title); ?>
		<?php
		echo '<span class="tw-ml-5">'.format_job_status($job->status).'</span>';

		$job_url        = admin_url('trade_job_management/jobs/show/'.$job->jobid);
		$client_job_url = site_url('trade_job_management/job/details/'.$job->jobid.'/'.$job->job_hash);

		?>
        <span>
            <i style="display: none" class="fa-solid fa-copy"></i>
            <a class="label inline-block tw-ml-2"
               data-toggle="tooltip"
               data-title="Copy Link"
               style="color:#3b82f6;border:1px solid #b1cdfb;background: #f7faff;"
               onclick="let copyIcon= document.createElement('i');copyIcon.classList.add('fa-solid', 'fa-copy') ;navigator.clipboard.writeText(this.dataset.link);this.innerHTML='Job link copied';setTimeout(() => { this.innerHTML = copyIcon.outerHTML}, 1000);"
               href="javascript:void(0)"
               data-link="<?php
               echo $job_url ?>">
                <i class="fa-solid fa-copy"></i>
            </a>
        </span>
        <span>
            <i style="display: none" class="fa-solid fa-comments"></i>
            <a class="label inline-block tw-ml-2"
               data-toggle="tooltip"
               data-title="Copy Public Job View Link"
               style="color:#3b82f6;border:1px solid #b1cdfb;background: #f7faff;"
               onclick="let copyIcon= document.createElement('i');copyIcon.classList.add('fa-solid', 'fa-comments') ;navigator.clipboard.writeText(this.dataset.link);this.innerHTML='Public job view link copied';setTimeout(() => { this
               .innerHTML = copyIcon.outerHTML}, 1000);"
               href="javascript:void(0)"
               data-link="<?php
               echo $client_job_url ?>">
                <i class="fa-solid fa-comments"></i>
            </a>
        </span>
    </h4>
</div>
<div class="modal-body">
    <input id="jobid" type="hidden" value="<?php
	echo $job->jobid ?>">
    <div class="row">
        <div class="col-md-8 task-single-col-left">
            <div class="no-margin pull-left mright5">
				<?php
				$collapsed = get_option('job_modal_class') == 'modal-lg';

				?>
                <a class="job-view-collapse btn btn-default tw-absolute <?php
				echo $collapsed ? 'collapsed' : '' ?>"
                   href="javascript:void(0)"
                   data-toggle="tooltip"
                   data-title="<?php
				   echo _l('job_info') ?>">
                    <i class="fa fa-chevron-left" aria-hidden="true"></i>
                    <i class="fa fa-chevron-right" aria-hidden="true"></i>
                </a>
            </div>
			<?php
			if (floatval($total_cost) > floatval($job->nte)) : ?>
                <div class="alert alert-danger mbot10 mright30" role="alert">
					<?php
					echo sprintf(_l('job_exceed_nte_msg'), app_format_money($total_cost, get_base_currency()), app_format_money($job->nte, get_base_currency())) ?>
                </div>
			<?php
			endif ?>
            <div class="clearfix"></div>
            <div class="row">
                <p class="no-margin pull-left mright5">
                    <a href="#" class="btn btn-default mright5" data-toggle="tooltip"
                       data-title="<?= _l('job_timesheets'); ?>"
                       onclick="slideToggle('#job_single_timesheets'); return false;">
                        <i class="fa fa-th-list"></i>
                    </a>
                </p>
                <p class="no-margin pull-left mright5">
                    <a href="<?= admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid); ?>"
                       class="btn btn-default mright5"
                       data-toggle="tooltip"
                       data-title="<?= _l('daily_progress'); ?>">
                        <i class="fa fa-calendar"></i>
                    </a>
                </p>
				<?php
				if ($job->billed != 1) : ?>
					<?php
					$staff_id    = get_staff_user_id();
					$is_assigned = is_admin() || $job->current_user_is_specialist;
					?>
					<?php
					if ( ! $this->job_timers_model->is_timer_started($job->jobid)) : ?>
                        <p class="no-margin pull-left" <?php
						if ( ! $is_assigned)
						{ ?> data-toggle="tooltip"
                            data-title="<?= _l('task_start_timer_only_assignee'); ?>"
							<?php
						} ?>>
                            <a href="#"
                               class="mbot10 btn<?= ! $is_assigned || in_array($job->status, [Jobs_model::STATUS_COMPLETE, Jobs_model::STATUS_EXCEED_NTE]) ? ' btn-default disabled' : ' btn-success'; ?>"
                               onclick="job_timer_action(this, <?= e($job->jobid); ?>); return false;">
                                <i class="fa-regular fa-clock"></i>
								<?= _l('job_start_timer'); ?>
                            </a>
                        </p>
					<?php
					else: ?>
                        <p class="no-margin pull-left">
                            <a href="#" data-toggle="popover"
                               data-placement="<?= is_mobile() ? 'bottom' : 'right'; ?>"
                               data-html="true" data-trigger="manual"
                               data-title="<?= _l('note'); ?>"
                               data-content='<?= render_textarea('timesheet_note'); ?><?= render_input('timesheet_cost', 'timesheet_cost', 0, 'number', ['step' => 0.1]) ?>
                               <button type="button" onclick="job_timer_action(this, <?= e($job->jobid); ?>, <?= $this->job_timers_model->get_last_timer($job->jobid)->timerid; ?>);"
                                class="btn btn-primary btn-sm"><?= _l('save'); ?></button>'
                               class="mbot10 btn btn-danger<?= ! $is_assigned ? ' disabled' : ''; ?>"
                               onclick="return false;">
                                <i class="fa-regular fa-clock"></i>
								<?= _l('task_stop_timer'); ?>
                            </a>
                        </p>
					<?php
					endif; ?>
				<?php
				endif; ?>

            </div>
            <div class="clearfix"></div>
            <hr class="hr-10"/>
            <div id="job_single_timesheets"
                 class="<?= ! $this->session->flashdata('job_single_timesheets_open') ? 'hide' : ''; ?>">
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                        <tr>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_user'); ?>
                            </th>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_start_time'); ?>
                            </th>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_end_time'); ?>
                            </th>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_time_spend'); ?>
                            </th>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_hourly_rate'); ?>
                            </th>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_cost'); ?>
                            </th>
                            <th class="tw-text-sm tw-bg-neutral-50">
								<?= _l('timesheet_total'); ?>
                            </th>
                        </tr>
                        </thead>
                        <tbody>
						<?php
						$timers_found = FALSE;
						foreach ($timesheets

						as $timesheet)
						{ ?>
						<?php
						if (staff_can('edit', 'tasks') || staff_can('create', 'tasks') || staff_can('delete', 'tasks') || $timesheet['staff_id'] == get_staff_user_id())
						{
						$timers_found = TRUE; ?>
                        <tr>
                            <td class="tw-text-sm">
								<?php
								if ($timesheet['note'])
								{
									echo '<i class="fa fa-comment" data-html="true" data-placement="right" data-toggle="tooltip" data-title="'.e($timesheet['note']).'"></i>';
								} ?>
                                <a href="<?= admin_url('staff/profile/'.$timesheet['staff_id']); ?>"
                                   target="_blank">
									<?= e($timesheet['full_name']); ?></a>
                            </td>
                            <td class="tw-text-sm">
								<?= e(_dt($timesheet['start_time'], TRUE)); ?>
                            </td>
                            <td class="tw-text-sm">
								<?php
								if ($timesheet['end_time'] !== NULL)
								{
									echo e(_dt($timesheet['end_time'], TRUE));
								} else
								{
									if ( ! $job->billed && is_admin())
									{ ?>
                                        <a href="#" data-toggle="popover" data-placement="bottom" data-html="true"
                                           data-trigger="manual"
                                           data-title="<?= _l('note'); ?>"
                                           data-content='<?= render_textarea('timesheet_note'); ?><?= render_input('timesheet_cost', 'timesheet_cost', 0, 'number', ['step' => 0.1]) ?><button type="button" onclick="job_timer_action(this,
                                    <?= e($job->jobid); ?>, <?= e(
											   $timesheet['timerid'],
										   ); ?>, 1);" class="btn btn-primary btn-sm"><?= _l('save'); ?></button>'
                                           class="text-danger" onclick="return false;">
                                            <i class="fa-regular fa-clock"></i>
											<?= _l('job_stop_timer'); ?>
                                        </a>
										<?php
									}
								} ?>
                            </td>
                            <td class="tw-text-sm">
                                <div class="tw-flex">
                                    <div class="tw-grow">
										<?php
										if ($timesheet['time_spent'] == NULL)
										{
											echo _l('time_h').': '.e(seconds_to_time_format(time() - $timesheet['start_time'])).'<br />';
											echo _l('time_decimal').': '.e(sec2qty(time() - $timesheet['start_time'])).'<br />';
										} else
										{
											echo _l('time_h').': '.e(seconds_to_time_format($timesheet['time_spent'])).'<br />';
											echo _l('time_decimal').': '.e(sec2qty($timesheet['time_spent'])).'<br />';
										} ?>
                                    </div>
                                </div>
                </div>
                </td>

                <td><?php
					echo app_format_money($timesheet['hourly_rate'], get_base_currency()) ?></td>
                <td><?php
					echo app_format_money($timesheet['cost'], get_base_currency()) ?></td>
                <td>
                    <div><?php
						echo app_format_money($timesheet['total'], get_base_currency()) ?>
                    </div>
					<?php
					if ( ! $job->billed) :?>
                        <div
                                class="tw-flex tw-items-center tw-shrink-0 tw-self-start tw-space-x-1.5 tw-ml-2">
							<?php
							if (staff_can('delete_timesheet', 'tasks') || (staff_can('delete_own_timesheet', 'tasks') && $timesheet['staff_id'] == get_staff_user_id()))
							{
								echo '<a href="'.admin_url('trade_job_management/jobs/delete_timesheet/'.$timesheet['timerid']).'" class="job-single-delete-timesheet text-danger" data-job-id="'.$job->jobid
								     .'"><i class="fa fa-remove"></i></a>';
							}
							if (staff_can('edit_timesheet', 'tasks') || (staff_can('edit_own_timesheet', 'tasks') && $timesheet['staff_id'] == get_staff_user_id()))
							{
								echo '<a href="#" class="job-single-edit-timesheet text-info" data-toggle="tooltip" data-title="'._l('edit').'" data-timesheet-id="'.$timesheet['timerid'].'">
                                    <i class="fa fa-edit"></i>
                                    </a>';
							}
							?>
                        </div>
					<?php
					endif ?>
                </td>
                </tr>
                <tr>
                    <td class="timesheet-edit job-modal-edit-timesheet-<?= $timesheet['timerid'] ?> hide"
                        colspan="7">
                        <form class="job-modal-edit-timesheet-form">
                            <input type="hidden" name="timesheet_edit_timer_id"
                                   value="<?= $timesheet['timerid'] ?>">
                            <input type="hidden" name="timesheet_edit_job_id"
                                   value="<?= $job->jobid ?>">
                            <div class="timesheet-start-end-time">
                                <div class="col-md-6">
									<?= render_datetime_input('timesheet_edit_start_time', 'task_log_time_start', _dt($timesheet['start_time'], TRUE)); ?>
                                </div>
                                <div class="col-md-6">
									<?= render_datetime_input('timesheet_edit_end_time', 'task_log_time_end', _dt($timesheet['end_time'], TRUE)); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
								<?php
								echo render_input('timesheet_edit_cost', 'timesheet_cost', $timesheet['cost'], 'number', ['step' => 0.1]) ?>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">
										<?= _l('job_single_log_user'); ?>
                                    </label>
                                    <br/>
                                    <select id="timesheet_edit_staff_id" name="timesheet_edit_staff_id" class="selectpicker" data-width="100%">
										<?php
										foreach ($specialists as $specialist)
										{
											$selected = '';
											if ($specialist['staff_id'] == $timesheet['staff_id'])
											{
												$selected = ' selected';
											} ?>
                                            <option<?= e($selected); ?>
                                                    value="<?= e($specialist['staff_id']); ?>">
												<?= e($specialist['full_name']); ?>
                                            </option>
											<?php
										} ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
								<?= render_textarea('timesheet_edit_note', 'note', $timesheet['note'], ['id' => 'note'.$timesheet['timerid']]); ?>
                            </div>
                            <div class="col-md-12 text-right">
                                <button type="button"
                                        class="btn btn-default edit-timesheet-cancel"><?= _l('cancel'); ?></button>
                                <button class="btn btn-success edit-timesheet-submit"></i>
									<?= _l('submit'); ?></button>
                            </div>
                        </form>
                    </td>
                </tr>
				<?php
				} ?>
				<?php
				} ?>
				<?php
				if ($timers_found == FALSE)
				{ ?>
                    <tr>
                        <td colspan="7" class="text-center bold">
							<?= _l('no_timers_found'); ?>
                        </td>
                    </tr>
					<?php
				} ?>
				<?php
				if ($job->billed == 0 && ($is_assigned || (count($job->assignees) > 0 && is_admin())) && $job->status != Tasks_model::STATUS_COMPLETE)
				{
					?>
                    <tr class="odd">
                        <td colspan="7" class="add-timesheet">
                            <div class="col-md-12">
                                <p class="font-medium bold mtop5">
									<?= _l('add_timesheet'); ?>
                                </p>
                                <hr class="mtop10 mbot10"/>
                            </div>
                            <div class="timesheet-start-end-time">
                                <div class="col-md-6">
									<?= render_datetime_input('timesheet_start_time', 'task_log_time_start'); ?>
                                </div>
                                <div class="col-md-6">
									<?= render_datetime_input('timesheet_end_time', 'task_log_time_end'); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
								<?php
								echo render_input('timesheet_cost', 'timesheet_cost', 0, 'number', ['step' => 0.1]) ?>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">
										<?= _l('job_single_log_user'); ?>
                                    </label>
                                    <br/>
                                    <select id="timesheet_staff_id" name="timesheet_staff_id" class="selectpicker" data-width="100%">
										<?php
										foreach ($specialists as $specialist)
										{ ?>
                                            <option value="<?= e($specialist['staff_id']); ?>">
												<?= e($specialist['full_name']); ?>
                                            </option>
											<?php
										} ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
								<?= render_textarea('timesheet_note', 'note'); ?>
                            </div>
                            <div class="col-md-12 text-right">
								<?php
								$disable_button = '';
								if ($this->tasks_model->is_timer_started_for_task($job->jobid, ['staff_id' => get_staff_user_id()]))
								{
									$disable_button = 'disabled ';
									echo '<div class="text-right mbot15 text-danger">'._l('add_task_timer_started_warning').'</div>';
								} ?>
                                <button
									<?= e($disable_button); ?>data-job-id="<?= e($job->jobid); ?>"
                                    class="btn btn-success job-single-add-timesheet"><i class="fa fa-plus"></i>
									<?= _l('submit'); ?></button>
                            </div>
                        </td>
                    </tr>
					<?php
				} ?>
                </tbody>
                </table>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row tw-mt-6">
			<?php
			if (staff_can('edit', 'jobs') && $job->status != jobs_model::STATUS_COMPLETE): ?>
                <div class="col-xs-12 col-sm-6 tw-mt-5">
					<?php
					if (isset($job) && $job->preferred_visit_date)
					{
						$value = $job->preferred_visit_date;

						$date_visit = Datetime::createFromFormat('Y-m-d H:i:s', $value);
						$formatted  = $date_visit->format('j F Y, g:ia');
					} else
					{
						$formatted  = _l('job_to_be_scheduled');
						$date_visit = new DateTime('now');
					}

					?>
                    <div class="form-group tw-mb-0">
                        <label for="startdate"><?php
							echo _l('job_date_and_time_visit'); ?></label>
                        <div class="input-group tw-flex">
                            <input style="max-width: fit-content" type="text" id="startdate" name="startdate"
                                   class="form-control datepicker"
                                   value="<?php
							       echo $date_visit->format('Y-m-d') ?>" autocomplete="off">
                            <input style="max-width: fit-content" type="time" id="starttime" name="starttime"
                                   class="form-control" value="<?php
							echo $date_visit->format('H:i'); ?>">
                            <a class="btn btn-primary tw-ml-2 update-startdate"
                               data-job-id="<?php
							   echo $job->jobid ?>"
                               href="javascript:void(0)">
                                Update
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-5 tw-mt-4">
                    <div class="form-group tw-mb-0">
                        <label for="startdate_formatted"><?php
							echo _l('job_scheduled_visit'); ?></label>
                        <div style="max-width: fit-content;"
                             class="tw-text-black-500 tw-whitespace-nowrap tw-bg-neutral-300 tw-px-4 tw-py-2 tw-text-lg tw-font-bold job-start-date"><?php
							echo e($formatted); ?></div>
                    </div>
                </div>
			<?php
			endif ?>
			<?php
			if ($job->status == jobs_model::STATUS_COMPLETE && ($job->preferred_visit_date || $job->startdate)): ?>
				<?php
				if ($job->preferred_visit_date)
				{
					$value      = $job->preferred_visit_date;
					$date_visit = Datetime::createFromFormat('Y-m-d H:i:s', $value);
					$formatted  = $date_visit ? $date_visit->format('j F Y, g:ia') : 'Not set';
				}

				?>
                <div class="col-xs-12 tw-flex tw-justify-center tw-items-end tw-gap-4">
					<?php
					if ($job->preferred_visit_date): ?>
                        <div class="form-group tw-mb-0">
                            <label for="startdate_formatted"><?php
								echo _l('job_visited_on'); ?></label>
                            <div style="max-width: fit-content;"
                                 class="tw-text-black-500 tw-whitespace-nowrap tw-bg-neutral-300 tw-px-4 tw-py-2 tw-text-lg tw-font-bold job-start-date"><?php
								echo e($formatted); ?></div>
                        </div>
					<?php
					endif ?>
					<?php
					if ($job->billed): ?>
						<?php
						$invoice = get_relation_data('invoice', $job->invoice_id);
						?>
                        <div class="form-group tw-mb-0">
                            <label class="tw-block" for="billing_status"><?php
								echo _l('job_billing_status'); ?></label>
                            <div style=""
                                 class="tw-text-black-500 tw-whitespace-nowrap tw-bg-neutral-300 tw-px-4 tw-py-2 tw-text-lg tw-font-bold job-start-date">
                                <a href="<?php
								echo admin_url('invoices#'.$job->invoice_id) ?>"
                                   id="init_invoice_job" style="max-width: fit-content;"
                                   class="">
									<?php
									echo sprintf('%s (%s)', _l('job_invoiced'), $invoice->formatted_number) ?>
                                </a>
                            </div>
                        </div>
					<?php
					else: ?>
                        <div class="form-group tw-mb-0">
                            <label class="tw-block" for="billing_status"><?php
								echo _l('job_billing_status'); ?></label>
                            <div style=""
                                 class="tw-text-black-500 tw-whitespace-nowrap tw-bg-neutral-300 tw-px-4 tw-py-2 tw-text-lg tw-font-bold job-start-date">

                                <a href="<?php
								echo admin_url('trade_job_management/jobs/invoice/'.$job->jobid) ?>"
                                   id="init_invoice_job" style="max-width: fit-content;"
                                   class="text-primary tw-cursor-pointer tw-text-black-500 tw-whitespace-nowrap tw-bg-neutral-300 tw-px-4 tw-py-2 tw-text-lg tw-font-bold job-start-date">
									<?php
									echo _l('invoice_job') ?>
                                </a>
                            </div>
                        </div>
					<?php
					endif ?>
                </div>
			<?php
			endif ?>
            <hr/>
        </div>
        <div class="clearfix"></div>
        <hr class="hr-10"/>
		<?php
		if (count($activity_logs)): ?>
            <div class="row status-logs-wrapper">
                <div class="col-md-12 ">
                    <h4 class="th tw-font-semibold tw-text-base mbot15"><?php
						echo _l('job_activity'); ?>
						<?php
						if (count($activity_logs) > 3): ?>
                            <a href="#" class="btn btn-default tw-ml-2" data-toggle="tooltip"
                               data-title="<?php
							   echo _l('job_activity_view_all'); ?>"
                               onclick="slideToggle('#job_activity_logs'); return false;">
                                <i class="fa fa-th-list"></i>
                            </a>
						<?php
						endif ?>
                    </h4>

                    <div id="status-logs">
                        <ul>
							<?php
							for ($i = 0;
							$i < 3;
							$i++)
							{
							if ( ! isset($activity_logs[$i]))
							{
								break;
							}

							$log = $activity_logs[$i];
							?>
                            <li class="tw-mb-2">
								<?php

								$formatted = Datetime::createFromFormat('Y-m-d H:i:s', $log->created_at);
								$formatted = $formatted->format('j F Y, g:ia');

								if ($log->type === 'schedule')
								{
									$scheduled_formatted = Datetime::createFromFormat('Y-m-d H:i:s', $log->new_scheduled_time);
									$scheduled_formatted = $scheduled_formatted->format('j F Y, g:ia');
									echo sprintf('<strong>%s</strong>: %s scheduled the visit/job for <strong>%s</strong>', $formatted, $log->staff['full_name'], $scheduled_formatted);
								} else
								{
									echo sprintf('<strong>%s</strong>: %s changed status from <strong>%s</strong> to <strong>%s</strong>', $formatted, $log->staff['full_name'], $log->old_status_formatted, $log->new_status_formatted);
								}
								?>
								<?php
								} ?>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="clearfix"></div>
				<?php
				if (count($activity_logs) > 3)
				{
					$activity_logs = array_slice($activity_logs, 3);
					?>
                    <div class="col-md-12">
                        <div id="job_activity_logs" class="hide">
                            <ul>
								<?php
								foreach ($activity_logs as $log): ?>
                                    <li class="tw-mb-2">
										<?php

										$formatted = Datetime::createFromFormat('Y-m-d H:i:s', $log->created_at);
										$formatted = $formatted->format('j F Y, g:ia');

										if ($log->type === 'schedule')
										{
											echo sprintf(
												'<strong>%s</strong>: %s changed preferred date to visit from <strong>%s</strong> to <strong>%s</strong>',
												$formatted,
												$log->staff['full_name'],
												$log->old_scheduled_time,
												$log->new_scheduled_time,
											);
										} else
										{
											echo sprintf(
												'<strong>%s</strong>: %s changed status from <strong>%s</strong> to <strong>%s</strong>',
												$formatted,
												$log->staff['full_name'],
												$log->old_status_formatted,
												$log->new_status_formatted,
											);
										}
										?>
                                    </li>
								<?php
								endforeach; ?>
                            </ul>

                        </div>
                    </div>
					<?php
				} ?>
            </div>
		<?php
		endif ?>
        <div class="clearfix"></div>
        <h4 class="th tw-font-semibold tw-text-base mbot15 pull-left"><?php
			echo _l('job_view_description'); ?></h4>
		<?php
		if (staff_can('edit', 'jobs'))
		{ ?><a href="#"
               onclick="edit_job_inline_description(this,<?php
		       echo e($job->jobid); ?>); return false;"
               class="pull-left tw-mt-2.5 mleft5 font-medium-xs"><i
                    class="fa-regular fa-pen-to-square"></i></a>
			<?php
		} ?>
        <div class="clearfix"></div>
		<?php
		if ( ! empty($job->job_description))
		{
			echo '<div class="tc-content"><div id="job_view_description">'.check_for_links($job->job_description).'</div></div>';
		} else
		{
			echo '<div class="no-margin tc-content job-no-description" id="job_view_description"><span class="text-muted">'._l('job_no_description').'</span></div>';
		} ?>
		<?php
		if (count($job->attachments) > 0)
		{ ?>
            <div class="row job_attachments_wrapper">
                <div class="col-md-12" id="attachments">
                    <hr/>
                    <h4 class="th tw-font-semibold tw-text-lg mbot15"><?php
						echo _l('job_view_attachments'); ?></h4>
                    <div class="row">
						<?php
						$i = 1;
						// Store all url related data here
						$comments_attachments           = [];
						$attachments_data               = [];
						$show_more_link_job_attachments = hooks()->apply_filters('show_more_link_job_attachments', 2);
						foreach ($job->attachments as $attachment)
						{
							?>
							<?php
							ob_start(); ?>
                            <div data-num="<?php
							echo e($i); ?>"
                                 data-commentid="<?php
							     echo e($attachment['comment_file_id']); ?>"
                                 data-comment-attachment="<?php
							     echo e($attachment['job_comment_id']); ?>"
                                 data-job-attachment-id="<?php
							     echo e($attachment['id']); ?>"
                                 class="job-attachment-col col-md-6<?php
							     if ($i > $show_more_link_job_attachments)
							     {
								     echo ' hide task-attachment-col-more';
							     } ?>">
                                <ul class="list-unstyled task-attachment-wrapper" data-placement="right"
                                    data-toggle="tooltip"
                                    data-title="<?php
								    echo e($attachment['file_name']); ?>">
                                    <li class="mbot10 task-attachment<?php
									if (strtotime($attachment['dateadded']) >= strtotime('-16 hours'))
									{
										echo ' highlight-bg';
									} ?>">
                                        <div class="mbot10 pull-right task-attachment-user">
											<?php
											if ($attachment['staffid'] == get_staff_user_id() || is_admin())
											{ ?>
                                                <a href="#" class="pull-right"
                                                   onclick="remove_job_attachment(this,<?php
												   echo e($attachment['id']); ?>); return false;">
                                                    <i class="fa fa fa-times"></i>
                                                </a>
												<?php
											}
											$externalPreview = FALSE;
											$is_image        = FALSE;
											$path            = get_upload_path_by_type('job').$job->jobid.'/'.$attachment['file_name'];
											$href_url        = site_url('trade_job_management/download/file/job/'.$attachment['attachment_key']);
											$isHtml5Video    = is_html5_video($path);
											if (empty($attachment['external']))
											{
												$is_image = is_image($path);
												$img_url  = site_url('trade_job_management/download/preview_image?path='.protected_file_url_by_path($path, TRUE).'&type='.$attachment['filetype']);
											} elseif (( ! empty($attachment['thumbnail_link']) || ! empty($attachment['external'])) && ! empty($attachment['thumbnail_link']))
											{
												$is_image        = TRUE;
												$img_url         = optimize_dropbox_thumbnail($attachment['thumbnail_link']);
												$externalPreview = $img_url;
												$href_url        = $attachment['external_link'];
											} elseif ( ! empty($attachment['external']) && empty($attachment['thumbnail_link']))
											{
												$href_url = $attachment['external_link'];
											}
											if ( ! empty($attachment['external']) && $attachment['external'] == 'dropbox' && $is_image)
											{ ?>
                                                <a href="<?php
												echo e($href_url); ?>" target="_blank" class=""
                                                   data-toggle="tooltip"
                                                   data-title="<?php
												   echo _l('open_in_dropbox'); ?>"><i
                                                            class="fa fa-dropbox"
                                                            aria-hidden="true"></i></a>
												<?php
											}
											if ($attachment['staffid'] != 0)
											{
												echo '<a href="'.admin_url('profile/'.$attachment['staffid']).'" target="_blank">'.e(get_staff_full_name($attachment['staffid'])).'</a> - ';
											} elseif ($attachment['contact_id'] != 0)
											{
												echo
													'<a href="'
													.admin_url('clients/client/'.get_user_id_by_contact_id($attachment['contact_id']).'?contactid='.$attachment['contact_id'])
													.'" target="_blank">'
													.e(get_contact_full_name($attachment['contact_id']))
													.'</a> - ';
											}
											echo '<span class="text-has-action tw-text-sm" data-toggle="tooltip" data-title="'._dt($attachment['dateadded']).'">'.e(time_ago($attachment['dateadded'])).'</span>';
											?>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="<?php
										if ($is_image)
										{
											echo 'preview-image';
										} elseif ( ! $isHtml5Video)
										{
											echo 'task-attachment-no-preview';
										} ?>">
											<?php
											// Not link on video previews because on click on the video is opening new tab
											if ( ! $isHtml5Video)
											{ ?>
                                            <a href="<?php
											echo ! $externalPreview ? $href_url : $externalPreview; ?>"
                                               target="_blank" <?php
											if ($is_image)
											{ ?> data-lightbox="task-attachment"
												<?php
											} ?> class="<?php
											if ($isHtml5Video)
											{
												echo 'video-preview';
											} ?>">
												<?php
												} ?>
												<?php
												if ($is_image)
												{ ?>
                                                    <img src="<?php
													echo e($img_url); ?>"
                                                         class="img img-responsive">
													<?php
												} elseif ($isHtml5Video)
												{ ?>
                                                    <video width="100%" height="100%"
                                                           src="<?php
													       echo site_url('trade_job_management/download/preview_video?path='.protected_file_url_by_path($path).'&type='.$attachment['filetype']); ?>"
                                                           controls>
                                                        Your browser does not support the video tag.
                                                    </video>
													<?php
												} else
												{ ?>
                                                    <i class="<?php
													echo get_mime_class($attachment['filetype']); ?>"></i>
													<?php
													echo e($attachment['file_name']); ?>
													<?php
												} ?>
												<?php
												if ( ! $isHtml5Video)
												{ ?>
                                            </a>
										<?php
										} ?>
                                        </div>
                                        <div class="clearfix"></div>
                                    </li>
                                </ul>
                            </div>
							<?php
							$attachments_data[$attachment['id']] = ob_get_contents();
							if ($attachment['job_comment_id'] != 0)
							{
								$comments_attachments[$attachment['job_comment_id']][$attachment['id']] = $attachments_data[$attachment['id']];
							}
							ob_end_clean();
							echo $attachments_data[$attachment['id']];
							?>
							<?php
							$i++;
						} ?>
                    </div>
                </div>
                <div class="clearfix"></div>
				<?php
				if (($i - 1) > $show_more_link_job_attachments)
				{ ?>
                    <div class="col-md-12" id="show-more-less-task-attachments-col">
                        <a href="#" class="task-attachments-more"
                           onclick="slideToggle('.job_attachments_wrapper .task-attachment-col-more', job_attachments_toggle); return false;"><?php
							echo _l('show_more'); ?></a>
                        <a href="#" class="task-attachments-less hide"
                           onclick="slideToggle('.job_attachments_wrapper .task-attachment-col-more', job_attachments_toggle); return false;"><?php
							echo _l('show_less'); ?></a>
                    </div>
					<?php
				} ?>
                <div class="col-md-12 text-center">
                    <hr/>
                    <a href="<?php
					echo admin_url('jobs/download_files/'.$job->jobid); ?>" class="bold">
						<?php
						echo _l('download_all'); ?> (.zip)
                    </a>
                </div>
            </div>
			<?php
		} ?>
        <hr/>
        <a href="#" id="jobCommentSlide" onclick="slideToggle('.jobs-comments'); return false;">
            <h4 class="mbot20 font-medium"><?php
				echo _l('job_comments'); ?></h4>
        </a>
        <div class="jobs-comments inline-block full-width simple-editor" <?php
		if (count($job->comments) == 0)
		{
			echo ' style="display:none"';
		} ?>>
			<?php
			echo
			form_open_multipart(admin_url('trade_job_management/jobs/add_job_comment'), [
				'id'    => 'job-comment-form',
				'class' => 'dropzone dropzone-manual',
				'style' => 'min-height:auto;background-color:#fff;',
			]); ?>
            <textarea name="comment" placeholder="<?php
			echo _l('job_single_add_new_comment'); ?>"
                      id="job_comment"
                      rows="3" class="form-control ays-ignore"></textarea>
            <div id="dropzoneJobComment" class="dropzoneDragArea dz-default dz-message hide job-comment-dropzone">
                    <span><?php
	                    echo _l('drop_files_here_to_upload'); ?></span>
            </div>
            <div class="dropzone-job-comment-previews dropzone-previews"></div>
            <button type="button" class="btn btn-primary mtop10 pull-right hide" id="addJobCommentBtn"
                    autocomplete="off" data-loading-text="<?php
			echo _l('wait_text'); ?>"
                    onclick="add_job_comment('<?php
			        echo e($job->jobid); ?>');"
                    data-comment-job-id="<?php
			        echo e($job->jobid); ?>">
				<?php
				echo _l('job_single_add_new_comment'); ?>
            </button>
			<?php
			echo form_close(); ?>
            <div class="clearfix"></div>
			<?php
			if (count($job->comments) > 0)
			{
				echo '<hr />';
			} ?>
            <div id="job-comments" class="mtop10">
				<?php
				$comments = '';
				$len      = count($job->comments);
				$i        = 0;
				foreach ($job->comments as $comment)
				{
					$comments .= '<div id="comment_'.$comment['jcid'].'" data-commentid="'.$comment['jcid'].'" data-job-attachment-id="'.$comment['file_id'].'" class="tc-content job-comment">';
					$comments .= '<a data-job-comment-href-id="'
					             .$comment['jcid']
					             .'" href="'
					             .admin_url('jobs/view/'.$job->jobid)
					             .'#comment_'
					             .$comment['jcid']
					             .'" class="job-date-as-comment-id"><span class="tw-text-sm">'
					             .$comment['created_at']
					             .'</span></a>';

					if ($comment['staff_id'] != 0)
					{
						$comments .= '<a href="'
						             .admin_url('profile/'.$comment['staff_id'])
						             .'" target="_blank">'
						             .staff_profile_image($comment['staff_id'], [
								'staff-profile-image-small',
								'media-object img-circle pull-left mright10',
							])
						             .'</a>';
					}
					if ($comment['staff_id'] == get_staff_user_id() || is_admin())
					{
						$comment_added = strtotime($comment['created_at']);
						$minus_1_hour  = strtotime('-1 hours');
						if (get_option('client_staff_add_edit_delete_job_comments_first_hour') == 0 || get_option('client_staff_add_edit_delete_job_comments_first_hour') == 1 && $comment_added >= $minus_1_hour || is_admin())
						{
							$comments .= '<span class="pull-right"><a href="#" onclick="remove_job_comment('.$comment['jcid'].'); return false;"><i class="fa fa-times text-danger"></i></span></a>';
							$comments .= '<span class="pull-right mright5"><a href="#" onclick="edit_job_comment('.$comment['jcid'].'); return false;"><i class="fa-regular fa-pen-to-square"></i></span></a>';
						}
					}

					$copied_text = _l('comment_copied_successfully');
					$action      = "navigator.clipboard.writeText(this.dataset.link);let originalText=this.innerHTML;this.innerHTML='$copied_text';setTimeout(() => { this.innerHTML = originalText}, 1000);";

					$comment_url = $job_url.'#comment_'.$comment['jcid'];
					$copy_action = '<span class="pull-right mright5"><a href="javascript:void(0)" onclick="'.$action.'" data-link="'.$comment_url.'"><i class="fa-regular fa-copy"></i></a></span>';

					$comments .= $copy_action;

					$comments .= '<div class="media-body comment-wrapper">';
					$comments .= '<div class="">';

					if ($comment['staff_id'] != 0)
					{
						$comments .= '<a href="'.admin_url('profile/'.$comment['staff_id']).'" target="_blank">'.e($comment['staff_full_name']).'</a> <br />';
					} elseif ($comment['contact_id'] != 0)
					{
						$comments .= '<span class="label label-info mtop5 mbot5 inline-block">'
						             ._l('is_customer_indicator')
						             .'</span><br /><a href="'
						             .admin_url('clients/client/'.get_user_id_by_contact_id($comment['contact_id']).'?contactid='.$comment['contact_id'])
						             .'" class="pull-left" target="_blank">'
						             .e(get_contact_full_name($comment['contact_id']))
						             .'</a> <br />';
					}

					$comments .= '<div data-edit-comment="'
					             .$comment['jcid']
					             .'" class="hide edit-job-comment"><textarea rows="5" id="job_comment_'
					             .$comment['jcid']
					             .'" class="ays-ignore form-control">'
					             .str_replace('[job_attachment]', '', $comment['content'])
					             .'</textarea>
                  <div class="clearfix mtop20"></div>
                  <button type="button" class="btn btn-primary pull-right" onclick="save_job_edited_comment('
					             .$comment['jcid']
					             .','
					             .$job->jobid
					             .')">'
					             ._l('submit')
					             .'</button>
                  <button type="button" class="btn btn-default pull-right mright5" onclick="cancel_edit_comment('
					             .$comment['jcid']
					             .')">'
					             ._l('cancel')
					             .'</button>
                  </div>';
					if ($comment['file_id'] != 0)
					{
						$comment['content'] = str_replace('[job_attachment]', '<div class="clearfix"></div>'.$attachments_data[$comment['file_id']], $comment['content']);
						// Replace lightbox to prevent loading the image twice
						$comment['content'] = str_replace('data-lightbox="task-attachment"', 'data-lightbox="task-attachment-comment-'.$comment['jcid'].'"', $comment['content']);
					} elseif (count($comment['attachments']) > 0 && isset($comments_attachments[$comment['jcid']]))
					{
						$comment_attachments_html = '';
						foreach ($comments_attachments[$comment['jcid']] as $comment_attachment)
						{
							$comment_attachments_html .= trim($comment_attachment);
						}
						$comment['content'] = str_replace('[job_attachment]', '<div class="clearfix"></div>'.$comment_attachments_html, $comment['content']);
						// Replace lightbox to prevent loading the image twice
						$comment['content'] = str_replace('data-lightbox="task-attachment"', 'data-lightbox="job-comment-files-'.$comment['jcid'].'"', $comment['content']);
						$comment['content'] .= '<div class="clearfix"></div>';
						$comment['content'] .= '<div class="text-center download-all">
                   <hr class="hr-10" />
                   <a href="'.admin_url('jobs/download_files/'.$job->jobid.'/'.$comment['jcid']).'" class="bold">'._l('download_all').' (.zip)
                   </a>
                   </div>';
					}
					$comments .= '<div class="comment-content mtop10">'.app_happy_text(check_for_links($comment['content'])).'</div>';
					$comments .= '</div>';
					if ($i >= 0 && $i != ($len - 1))
					{
						$comments .= '<hr class="job-info-separator" />';
					}
					$comments .= '</div>';
					$comments .= '</div>';
					$i++;
				}
				echo $comments;
				?>
            </div>
        </div>
    </div>
    <div class="col-md-4 task-single-col-right ">
        <div class="pull-right mbot10 task-single-menu job-menu-options">
            <div class="content-menu hide">
                <ul>
					<?php
					if (staff_can('edit', 'jobs'))
					{ ?>
                        <li>
                            <a href="#" onclick="edit_job(<?php
							echo e($job->jobid); ?>); return false;">
								<?php
								echo _l('job_single_edit'); ?>
                            </a>
                        </li>
						<?php
					} ?>
					<?php
					if (staff_can('delete', 'jobs'))
					{ ?>
                        <li>
                            <a href="<?php
							echo admin_url('trade_job_management/jobs/delete/'.$job->jobid); ?>"
                               class="_delete job-delete">
								<?php
								echo _l('job_single_delete'); ?>
                            </a>
                        </li>
						<?php
					} ?>
                </ul>
            </div>
			<?php
			if (staff_can('delete', 'jobs') || staff_can('edit', 'jobs') || staff_can('create', 'jobs'))
			{ ?>
                <a href="#" onclick="return false;" class="trigger manual-popover mright5">
                    <i class="fa-regular fa-circle"></i>
                    <i class="fa-regular fa-circle"></i>
                    <i class="fa-regular fa-circle"></i>
                </a>
				<?php
			} ?>
        </div>
        <h4 class="job-info-heading tw-font-semibold tw-text-base tw-mb-0 tw-text-neutral-800">
			<?php
			echo _l('job_info');
			?>
        </h4>
        <div class="clearfix"></div>
        <p class="tw-mb-0 job-info-created tw-text-sm">
        <div
                class="tw-text-neutral-500"><?php
			echo _l('job_view_created_by', '<span class="tw-text-neutral-600">'.get_staff_full_name($job->created_by).'</span>'); ?>
            <br/>
            <span
                    class="tw-text-neutral-500"><?php
				echo _l('job_view_created_at', '<span class="tw-text-neutral-600">'.e(_dt($job->created_at)).'</span>'); ?></span>
        </div>
        <br/>
        </p>
        <hr class="job-info-separator"/>
        <div class="job-info property-address">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa fa-th menu-icon fa-fw fa-lg job-info-icon pull-left"></i>
				<?php
				echo _l('property'); ?>:&nbsp;
                <a target="_blank" href="<?php
				echo admin_url('trade_job_management/properties/view/'.$property->propertyid) ?>"><?php
					echo $property->property_name ?></a>
            </h5>
        </div>
        <div class="job-info job-status job-info-status">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa-regular fa-star fa-fw fa-lg pull-left job-info-icon"></i><?php
				echo _l('job_status'); ?>:
				<?php
				if ($job->current_user_is_specialist || $job->current_user_is_creator || staff_can('edit', 'jobs'))
				{ ?>
                    <span class="task-single-menu job-menu-status">
                    <span class="trigger pointer manual-popover text-has-action tw-text-neutral-800">
                        <?php
                        echo e(format_job_status($job->status, TRUE, TRUE)); ?>
                    </span>
                    <span class="content-menu hide">
                        <ul>
                            <?php
                            foreach ($statuses as $status): ?>
	                            <?php
	                            if ($job->status != $status['id']): ?>
                                    <li>
                                        <a href="#"
                                           onclick="job_mark_as(<?php
                                           echo e($status['id']); ?>,<?php
                                           echo e($job->jobid); ?>); return false;"
                                           class="tw-block">
                                            <?php
                                            echo e(_l('job_mark_as', $status['name'])); ?>
                                        </a>
                                    </li>
	                            <?php
	                            endif ?>
                            <?php
                            endforeach ?>
                        </ul>
                    </span>
                </span>
					<?php
				} else
				{ ?>
                    <span class="tw-text-neutral-800"><?php
						echo format_job_status($job->status, TRUE); ?></span>
					<?php
				} ?>
            </h5>
        </div>
        <div class="job-info job-nte">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa fa-money-bill fa-fw fa-lg fa-margin job-info-icon pull-left tw-mt-2"></i>
				<?php
				echo _l('job_nte'); ?>:
                <span style=" white-space: nowrap"><?php
					echo app_format_money($job->nte, get_base_currency()) ?></span>
            </h5>
        </div>
        <div class="job-info job-total-cost">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa fa-money-bill fa-fw fa-lg fa-margin job-info-icon pull-left tw-mt-2"></i>
				<?php
				echo _l('job_total_cost'); ?>:
                <span style=" white-space: nowrap"><?php
					echo app_format_money($total_cost, get_base_currency()) ?></span>
            </h5>
        </div>
        <div class="job-info task-single-inline-wrap job-info-start-date">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa-regular fa-calendar fa-fw fa-lg fa-margin job-info-icon pull-left tw-mt-2"></i>
				<?php
				echo _l('job_date_visit'); ?>:
				<?php
				$value = $job->preferred_visit_date;
				if ($value)
				{
					$date_preferred = Datetime::createFromFormat('Y-m-d H:i:s', $value);
					$formatted      = $date_preferred->format('j F Y g:i A');
				} else
				{
					$formatted = '';
				}
				?>
                <span class="right-job-start-date" style=" white-space: nowrap"><?php
					echo $formatted ?></span>
            </h5>
        </div>
        <div class="job-info job-info-priority">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa fa-bolt fa-fw fa-lg job-info-icon pull-left"></i>
				<?php
				echo _l('job_single_priority'); ?>:
				<?php
				if (staff_can('edit', 'jobs') && $job->status != jobs_model::STATUS_COMPLETE)
				{ ?>
                    <span class="task-single-menu job-menu-priority">
                    <span class="trigger pointer manual-popover text-has-action tw-text-neutral-800"
                          style="color:<?php
                          echo e(task_priority_color($job->priority)); ?>;">
                        <?php
                        echo e(task_priority($job->priority)); ?>
                    </span>
                    <span class="content-menu hide">
                        <ul>
                            <?php
                            foreach (get_tasks_priorities() as $priority)
                            { ?>
	                            <?php
	                            if ($job->priority != $priority['id'])
	                            { ?>
                                    <li>
                                <a href="#"
                                   onclick="job_change_priority(<?php
                                   echo e($priority['id']); ?>,<?php
                                   echo e($job->jobid); ?>); return false;"
                                   class="tw-block">
                                    <?php
                                    echo e($priority['name']); ?>
                                </a>
                            </li>
		                            <?php
	                            } ?>
	                            <?php
                            } ?>
                        </ul>
                    </span>
                </span>
					<?php
				} else
				{ ?>
                    <span style="color:<?php
					echo e(task_priority_color($job->priority)); ?>;">
                    <?php
                    echo e(task_priority($job->priority)); ?>
                </span>
					<?php
				} ?>
            </h5>
        </div>
        <div class="job-info job-type">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa fa-hammer fa-fw fa-lg job-info-icon pull-left"></i>
				<?php
				echo _l('job_type'); ?>:&nbsp;
                <span><?php
					echo e(job_type($job->job_type_name)); ?></span>
            </h5>
        </div>
        <div class="job-info property-address">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5" style="white-space: nowrap">
                <i class="fa fa-location-dot fa-fw fa-lg job-info-icon pull-left"></i><?php
				echo _l('property_address'); ?>:&nbsp;
                <span style="white-space: normal"><?php
					echo $property->property_address ?></span>
            </h5>
        </div>
        <div class="job-info property-type">
            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
                <i class="fa fa-house fa-fw fa-lg job-info-icon pull-left"></i>
				<?php
				echo _l('job_property_type'); ?>:&nbsp;
                <span><?php
					echo $property->property_type_data->type_name ?></span>
            </h5>
        </div>
        <hr class="job-info-separator"/>
        <div class="clearfix"></div>
        <h4 class="job-info-heading tw-font-semibold tw-text-base tw-flex tw-items-center tw-text-neutral-800 tw-mb-1">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                 stroke="currentColor" class="tw-w-5 tw-h-5 tw-text-neutral-500 tw-mr-2">
                <path stroke-linecap="round" stroke-linejoin="round"
                      d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-3.07M12 6.375a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zm8.25 2.25a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"/>
            </svg>
			<?php
			echo _l('landlord_name'); ?>
        </h4>
        <div class="job-info job_users_wrapper">
            <div class="job-info landlord-name">
                <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
					<?php
					echo _l('landlord_name_label'); ?>:&nbsp;
                    <span>
                                <a href="<?php
                                echo admin_url('trade_job_management/landlords/show/'.$landlord->landlordid) ?>"><?php
	                                echo $landlord->first_name.' '.$landlord->last_name ?></a>
                </span>
                </h5>
            </div>
            <div class="job-info landlord-phonenumber">
                <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
					<?php
					echo _l('landlord_phone'); ?>:&nbsp;
                    <span>
                                <a href="tel:<?php
                                echo $landlord->phone_number ?>"><?php
	                                echo $landlord->phone_number ?></a>
                </span>
                </h5>
            </div>
            <div class="job-info landlord-email">
                <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
					<?php
					echo _l('landlord_email'); ?>:&nbsp;
                    <span>
                                <a href="mailto:<?php
                                echo $landlord->email ?>"><?php
	                                echo $landlord->email ?></a>
                </span>
                </h5>
            </div>
        </div>
        <hr class="job-info-separator"/>
        <h4 class="job-info-heading tw-font-semibold tw-text-base tw-flex tw-items-center tw-text-neutral-800 tw-mb-1">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                 stroke="currentColor" class="tw-w-5 tw-h-5 tw-text-neutral-500 tw-mr-2">
                <path stroke-linecap="round" stroke-linejoin="round"
                      d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-3.07M12 6.375a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zm8.25 2.25a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"/>
            </svg>
			<?php
			echo _l('landlord_person_details'); ?>
        </h4>
        <div class="job_users_wrapper">
            <div class="job-info landlord-person-name">
                <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
					<?php
					echo _l('landlord_person_name'); ?>:&nbsp;
                    <span>
                    <?php
                    echo $job->contact_name ?>
                </span>
                </h5>
            </div>
            <div class="job-info landlord-person-phonenumber">
                <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
					<?php
					echo _l('landlord_person_phonenumber'); ?>:&nbsp;
                    <span>
                    <?php
                    echo $job->contact_phone ?>
                </span>
                </h5>
            </div>
        </div>
        <hr class="job-info-separator"/>
        <div class="clearfix"></div>
        <h4 class="job-info-heading tw-font-semibold tw-text-base tw-flex tw-items-center tw-text-neutral-800 tw-mb-1">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                 stroke="currentColor" class="tw-w-5 tw-h-5 tw-text-neutral-500 tw-mr-2">
                <path stroke-linecap="round" stroke-linejoin="round"
                      d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-3.07M12 6.375a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zm8.25 2.25a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"/>
            </svg>
			<?php
			echo _l('job_specialists'); ?>
        </h4>
        <div class="job-info job_users_wrapper">
            <ul>
				<?php
				foreach ($specialists as $specialist): ?>
                    <li>
                        <div class="job-info landlord-person-name">
                            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
								<?php
								echo _l('engineer_name'); ?>:&nbsp;
                                <span>
                                         <a href="<?php
                                         echo admin_url('staff/member/'.$specialist['staff_id']) ?>"><?php
	                                         echo $specialist['full_name'] ?></a>
                                    </span>
                            </h5>
                        </div>
                        <div class="job-info landlord-person-phonenumber">
                            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
								<?php
								echo _l('engineer_phonenumber'); ?>:&nbsp;
                                <span><?php
									echo $specialist['phonenumber'] ?? '' ?></span>
                            </h5>
                        </div>
                    </li>
				<?php
				endforeach; ?>
            </ul>
        </div>
        <hr class="job-info-separator"/>
        <div class="clearfix"></div>
        <h4 class="job-info-heading tw-font-semibold tw-text-base tw-flex tw-items-center tw-text-neutral-800 tw-mb-1">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                 stroke="currentColor" class="tw-w-5 tw-h-5 tw-text-neutral-500 tw-mr-2">
                <path stroke-linecap="round" stroke-linejoin="round"
                      d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10"/>
            </svg>
			<?php
			echo _l('job_closure'); ?>
        </h4>
        <div class="job_users_wrapper">
			<?php
			if ($job->property && ($job->property['require_client_confirmation'] ?? FALSE)): ?>
				<?php
				if ($job->confirmation_at && $job->confirmation_signed) : ?>
                    <div class="job-info landlord-person-phonenumber">
                        <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
							<?php
							echo _l('client_firstname'); ?>:&nbsp;
                            <span>
                    <?php
                    echo $job->confirmation_firstname ?>
                </span>
                        </h5>
                    </div>
                    <div class="job-info landlord-person-phonenumber">
                        <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
							<?php
							echo _l('client_lastname'); ?>:&nbsp;
                            <span>
                    <?php
                    echo $job->confirmation_lastname ?>
                </span>
                        </h5>
                    </div>
                    <div class="job-info landlord-person-phonenumber">
                        <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
							<?php
							echo _l('client_email'); ?>:&nbsp;
                            <span>
                                <a href="mailto:<?php
                                echo $job->confirmation_email ?>"><?php
	                                echo $job->confirmation_email ?></a>
                </span>
                        </h5>
                    </div>
                    <div class="job-info landlord-person-phonenumber">
                        <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
							<?php
							echo _l('signature'); ?>:&nbsp;
                        </h5>
						<?php
						if ($job->signature_path) : ?>
							<?php
							$path          = get_upload_path_by_type('signature').$job->jobid.'/'.$job->signature_path;
							$signature_url = site_url('trade_job_management/download/preview_image?path='.protected_file_url_by_path($path, TRUE).'&type=image/png');
							?>
                            <div class="mtop5 tw-rounded-lg tw-bg-white tw-p-2">
                                <img alt="Signature" src="<?php
								echo e($signature_url); ?>"
                                     class="img img-responsive">
                            </div>
						<?php
						else: ?>
                            <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
								<?php
								echo _l('job_no_signature'); ?>:&nbsp;
                            </h5>
						<?php
						endif ?>
                    </div>
                    <div class="job-info landlord-person-phonenumber">
                        <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
							<?php
							echo _l('job_feedback'); ?>:&nbsp;
                        </h5>
                        <p class="mtop5"><?php
							echo html_escape($job->confirmation_feedback) ?>
                        </p>
                    </div>

				<?php
				else: ?>
                    <div class="job-info landlord-person-phonenumber">
                        <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
							<?php
							echo _l('job_closure_no_signature'); ?>
                        </h5>
                    </div>
				<?php
				endif ?>
			<?php
			else: ?>
                <div class="job-info landlord-person-name">
                    <h5 class="tw-inline-flex tw-items-center tw-space-x-1.5">
						<?php
						echo _l('job_closure_not_required'); ?>
                    </h5>
                </div>
			<?php
			endif; ?>
        </div>
		<?php
		echo form_open_multipart('admin/trade_job_management/jobs/upload_file', ['id' => 'job-attachment', 'class' => 'dropzone tw-mt-5']);
		echo form_close();
		?>
    </div>
</div>
</div>
<style>
    .job-view-collapse {
        top: 1rem;
        right: 1rem;
    }

    .job-view-collapse:not(.collapsed) i.fa-chevron-left {
        display: none;
    }

    .job-view-collapse.collapsed i.fa-chevron-right {
        display: none;
    }

    @media (max-width: 991px) {
        .job-view-collapse {
            display: none;
        }
    }

    @media (max-width: 991px) {
        .job-view-collapse {
            display: none;
        }

        .task-single-col-right {
            display: block;
        }
    }

    .tc-content.job-comment.active {
        background-color: #fffb006b;
    }
</style>
<script>
    if (typeof jobId === 'undefined') {
        let jobId = <?= $job_id ?>
    } else {
        jobId = <?= $job_id ?>
    }
    if (typeof (targetComment) == 'undefined') {
        let targetComment = window.location.hash;
        if (targetComment.includes("#comment_")) {
            $(targetComment).addClass('active');
        }
    } else if (targetComment.includes("#comment_")) {
        $(targetComment).addClass('active');
    }

    if (typeof (commonjobPopoverMenuOptions) == 'undefined') {
        var commonjobPopoverMenuOptions = {
            html: true,
            placement: 'bottom',
            trigger: 'click',
            template: '<div class="popover"><div class="arrow"></div><div class="popover-inner"><h3 class="popover-title"></h3><div class="popover-content"></div></div></div>',
        };
    }

    // Clear memory leak
    if (typeof (jobPopoverMenus) == 'undefined') {
        var jobPopoverMenus = [{
            selector: '.job-menu-options',
            title: "<?php echo _l('actions'); ?>",
        },
            {
                selector: '.job-menu-status',
                title: "<?php echo _l('ticket_single_change_status'); ?>",
            },
            {
                selector: '.job-menu-priority',
                title: "<?php echo _l('job_single_priority'); ?>",
            },
            {
                selector: '.job-menu-milestones',
                title: "<?php echo _l('job_milestone'); ?>",
            },
        ];
    }

    for (var i = 0; i < jobPopoverMenus.length; i++) {
        $(jobPopoverMenus[i].selector + ' .trigger').popover($.extend({}, commonjobPopoverMenuOptions, {
            title: jobPopoverMenus[i].title,
            content: $('body').find(jobPopoverMenus[i].selector + ' .content-menu').html()
        }));
    }

    if (typeof (Dropbox) != 'undefined') {
        var dropboxChooser = document.getElementById("dropbox-chooser-job");
        if (dropboxChooser) {
            dropboxChooser.appendChild(Dropbox.createChooseButton({
                success: function (files) {
                    jobExternalFileUpload(files, 'dropbox', jobId);
                },
                linkType: "preview",
                extensions: app.options.allowed_files.split(','),
            }));
        }
    }

    init_selectpicker();
    init_datepicker();
    init_lightbox();

    tinyMCE.remove('#job_view_description');

    if (typeof (jobAttachmentDropzone) != 'undefined') {
        jobAttachmentDropzone.destroy();
        jobAttachmentDropzone = null;
    }

    jobAttachmentDropzone = new Dropzone("#job-attachment", appCreateDropzoneOptions({
        uploadMultiple: true,
        parallelUploads: 20,
        maxFiles: 20,
        paramName: 'file',
        sending: function (file, xhr, formData) {
            console.log(formData)
            formData.append("jobid", <?= $job_id ?>);
        },
        success: function (files, response) {
            response = JSON.parse(response);
            if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length === 0) {
                _job_append_html(response.jobHtml);
            }
        }
    }));


    // General function to append task html returned from request
    function _job_append_html(html) {
        var $jobModal = $("#job-modal");
        if ($jobModal === undefined || $jobModal === null) {
            return;
        }
        $jobModal.find(".data").html(html);
        setTimeout(function () {
            $jobModal.modal("show");
            fix_task_modal_left_col_height();
            if (is_mobile()) {
                init_new_job_comment(true);
            }
        }, 150);
    }

    // Marking job as complete
    function job_mark_complete(job_id) {
        job_mark_as(5, job_id, "trade_job_management/jobs/mark_as/" + 5 + '/' + job_id);
    }

    // Unmarking job as complete
    function job_unmark_complete(job_id) {
        job_mark_as(4, job_id, "trade_job_management/jobs/unmark_complete/" + job_id);
    }

    // Mark job status
    // function job_mark_as(status, job_id, url) {
    //     url = "trade_job_management/jobs/mark_as/" + status + "/" + job_id + "?single_job=true";
    //     $("body").append('<div class="dt-loader"></div>');
    //     requestGetJSON(url).done(function (response) {
    //         $("body").find(".dt-loader").remove();
    //         if (response.success === true || response.success == "true") {
    //             reload_jobs_tables();
    //             _job_append_html(response.jobHtml);
    //             alert_float("success", response.message);
    //         }
    //     });
    // }

    $('body').on('click', '.job-view-collapse', function () {
        const $parent = $(this).closest('.row');
        $(this).toggleClass("collapsed");
        if ($(this).hasClass("collapsed")) {
            $parent.find('.task-single-col-left').removeClass('col-md-8').addClass('col-md-12');
            $parent.find('.task-single-col-right').removeClass('col-md-4');
            $parent.find('.task-single-col-right').hide();
        } else {
            $parent.find('.task-single-col-left').removeClass('col-md-12').addClass('col-md-8');
            $parent.find('.task-single-col-right').addClass('col-md-4');
            $parent.find('.task-single-col-right').show();
        }
    })

    if (typeof currentDate === undefined) {
        let currentDate = '<?php echo $job->preferred_visit_date ?>'
    } else {
        currentDate = '<?php echo $job->preferred_visit_date ?>'
    }
    $("body").on('click', '.update-startdate', function () {
        let newDate = $('#startdate').val();
        let newTime = $('#starttime').val();
        let jobId = $(this).data('job-id');

        let newDateTime = newDate + ' ' + newTime + ':00';

        if (currentDate === '' || newDateTime !== currentDate) {
            currentDate = newDateTime;
            $(this).attr("disabled", true);
            $(this).parent().find('input').attr("disabled", true);

            $.post(admin_url + "trade_job_management/jobs/job_reschedule/" + jobId, {
                preferred_visit_date: newDateTime
            }).success(function (response) {
                let data = JSON.parse(response);

                alert_float("success", data.message);
                $('.job-start-date').text(data.new_schedule);
                init_job_modal(jobId);
            }).complete(function () {
                $("#startdate").removeAttr("disabled");
                $("body").find('.update-startdate').removeAttr("disabled");
                $("body").find('.update-startdate').parent().find('input').removeAttr("disabled");
            })
        }
    });

    // Add new job comment from the modal
    function add_job_comment(job_id) {
        var data = {};

        if (jobCommentAttachmentDropzone.files.length > 0) {
            jobCommentAttachmentDropzone.processQueue(job_id);
            return;
        }
        if (tinymce.activeEditor) {
            data.content = tinyMCE.activeEditor.getContent();
        } else {
            data.content = $("#job_comment").val();
            data.no_editor = true;
        }
        data.jobid = job_id;
        $.post(admin_url + "trade_job_management/jobs/add_job_comment", data).done(function (response) {
            response = JSON.parse(response);
            _job_append_html(response.jobHtml);
            // Remove job comment editor instance
            // Causing error because of are you sure you want to leave this page, the plugin still sees as active and dirty.
            tinymce.remove("#job_comment");
        });
    }

    // Change job priority from sigle modal
    function job_change_priority(priority_id, job_id) {
        url = "trade_job_management/jobs/change_priority/" + priority_id + "/" + job_id;
        var jobModalVisible = $("#job-modal").is(":visible");
        url += "?single_job=" + jobModalVisible;
        requestGetJSON(url).done(function (response) {
            if (response.success === true || response.success == "true") {
                reload_jobs_tables();
                if (jobModalVisible) {
                    _job_append_html(response.jobHtml);
                }
            }
        });
    }


    // Save job edited comment
    function save_job_edited_comment(id, job_id) {
        tinymce.triggerSave();
        var data = {};
        data.id = id;
        data.job_id = job_id;
        data.content = $('[data-edit-comment="' + id + '"]')
            .find("textarea")
            .val();
        if (is_ios()) {
            data.no_editor = true;
        }
        $.post(admin_url + 'trade_job_management/jobs/edit_comment', data).done(function (response) {
            response = JSON.parse(response);
            if (response.success === true || response.success == "true") {
                alert_float("success", response.message);
                _job_append_html(response.jobHtml);
            } else {
                cancel_edit_comment(id);
            }
            tinymce.remove('[data-edit-comment="' + id + '"] textarea');
        });
    }


    $("body").on("change", ".f_landlord_id #clientid", function () {
        var val = $(this).val();
        var projectAjax = $('select[name="project_id"]');
        var clonedProjectsAjaxSearchSelect = projectAjax.html("").clone();
        var projectsWrapper = $(".projects-wrapper");
        projectAjax.selectpicker("destroy").remove();
        $("#project_ajax_search_wrapper").append(clonedProjectsAjaxSearchSelect);
        init_ajax_project_search_by_customer_id();
        clear_billing_and_shipping_details();
        if (!val) {
            $("#merge").empty();
            $("#expenses_to_bill").empty();
            $("#invoice_top_info").addClass("hide");
            projectsWrapper.addClass("hide");
            return false;
        }

        var currentInvoiceID = $("body")
            .find('input[name="merge_current_invoice"]')
            .val();
        currentInvoiceID =
            typeof currentInvoiceID == "undefined" ? "" : currentInvoiceID;

        requestGetJSON(
            "invoices/client_change_data/" + val + "/" + currentInvoiceID
        ).done(function (response) {
            $("#merge").html(response.merge_info);
            var $billExpenses = $("#expenses_to_bill");
            // Invoice from project, in invoice_template this is not shown
            $billExpenses.length === 0
                ? (response.expenses_bill_info = "")
                : $billExpenses.html(response.expenses_bill_info);
            response.merge_info !== "" || response.expenses_bill_info !== ""
                ? $("#invoice_top_info").removeClass("hide")
                : $("#invoice_top_info").addClass("hide");

            for (var f in billingAndShippingFields) {
                if (billingAndShippingFields[f].indexOf("billing") > -1) {
                    if (billingAndShippingFields[f].indexOf("country") > -1) {
                        $(
                            'select[name="' + billingAndShippingFields[f] + '"]'
                        ).selectpicker(
                            "val",
                            response["billing_shipping"][0][billingAndShippingFields[f]]
                        );
                    } else {
                        if (billingAndShippingFields[f].indexOf("billing_street") > -1) {
                            $('textarea[name="' + billingAndShippingFields[f] + '"]').val(
                                response["billing_shipping"][0][billingAndShippingFields[f]]
                            );
                        } else {
                            $('input[name="' + billingAndShippingFields[f] + '"]').val(
                                response["billing_shipping"][0][billingAndShippingFields[f]]
                            );
                        }
                    }
                }
            }

            if (!empty(response["billing_shipping"][0]["shipping_street"])) {
                $('input[name="include_shipping"]').prop("checked", true).change();
            }

            for (var fsd in billingAndShippingFields) {
                if (billingAndShippingFields[fsd].indexOf("shipping") > -1) {
                    if (billingAndShippingFields[fsd].indexOf("country") > -1) {
                        $(
                            'select[name="' + billingAndShippingFields[fsd] + '"]'
                        ).selectpicker(
                            "val",
                            response["billing_shipping"][0][billingAndShippingFields[fsd]]
                        );
                    } else {
                        if (billingAndShippingFields[fsd].indexOf("shipping_street") > -1) {
                            $('textarea[name="' + billingAndShippingFields[fsd] + '"]').val(
                                response["billing_shipping"][0][billingAndShippingFields[fsd]]
                            );
                        } else {
                            $('input[name="' + billingAndShippingFields[fsd] + '"]').val(
                                response["billing_shipping"][0][billingAndShippingFields[fsd]]
                            );
                        }
                    }
                }
            }

            init_billing_and_shipping_details();
            init_tags_inputs();

            var client_currency = response["client_currency"];
            var s_currency = $("body").find(
                '.accounting-template select[name="currency"]'
            );
            client_currency = parseInt(client_currency);
            client_currency != 0
                ? s_currency.val(client_currency)
                : s_currency.val(s_currency.data("base"));
            _init_jobs_billable_select(
                response["billable_jobs"],
                $('#property_id').val()
            );
            response.customer_has_projects === true
                ? projectsWrapper.removeClass("hide")
                : projectsWrapper.addClass("hide");
            s_currency.selectpicker("refresh");
            init_currency();
        });
    });

    $("body").on("change", '#invoice_property input[name="project_id"]', function () {
        var project_id = $(this).val();
        if (project_id !== "") {
            requestGetJSON("jobs/get_billable_jobs_by_project/" + project_id).done(
                function (jobs) {
                    _init_jobs_billable_select(jobs, project_id);

                    let $jobSelection = $('#job_select');

                    $jobSelection.val($jobSelection.data('job-id'));
                    $jobSelection.trigger('change');
                    $jobSelection.selectpicker("refresh");
                }
            );
        } else {
            var client_id = $("#clientid").selectpicker("val");
            if (client_id !== "") {
                requestGetJSON(
                    "jobs/get_billable_jobs_by_customer_id/" + client_id
                ).done(function (jobs) {
                    _init_jobs_billable_select(jobs);
                });
            } else {
                // Empty dropdown
                _init_jobs_billable_select([], "");
            }
        }
    });

    $("body").on("change", "#invoice_property #property_id", function () {
        let selectedId = $(this).val();
        let $projectId = $(this).parent().find('input[name="project_id"]');

        $projectId.val(selectedId);
        $projectId.trigger('change');
    });

    function init_invoice_job_modal(job_id) {
        requestGet("trade_job_management/jobs/get_invoice_job_data/" + job_id)
            .done(function (response) {
                response = JSON.parse(response);

                const $jobModal = $("#job-modal");
                const $invoiceJobModal = $("#invoice-job-modal");

                $invoiceJobModal.find('.modal-body').html(response.html)

                $jobModal.removeClass("fade").modal('hide');
                setTimeout(function () {
                    $invoiceJobModal.addClass("fade").modal("show");
                    $(".modal-backdrop.in").addClass("fade");
                }, 150);

                setTimeout(function () {
                    $('body #property_id').trigger('change');
                }, 200);
            })
            .fail(function (data) {
                $("#job-modal").modal("hide");
                alert_float("danger", data.responseText);
            });
    }


    $("body").on("click focus", "#job_comment", function (e) {
        init_new_job_comment();
    });


    function init_new_job_comment(manual) {
        if (tinymce.get('job_comment')) {
            tinymce.remove("#job_comment");
        }

        if (typeof jobCommentAttachmentDropzone != "undefined") {
            jobCommentAttachmentDropzone.destroy();
        }

        $("#dropzoneJobComment").removeClass("hide");
        $("#addJobCommentBtn").removeClass("hide");

        jobCommentAttachmentDropzone = new Dropzone(
            "#job-comment-form",
            appCreateDropzoneOptions({
                uploadMultiple: true,
                clickable: "#dropzoneJobComment",
                previewsContainer: ".dropzone-job-comment-previews",
                autoProcessQueue: false,
                addRemoveLinks: true,
                parallelUploads: 20,
                maxFiles: 20,
                paramName: "file",
                sending: function (file, xhr, formData) {
                    formData.append(
                        "jobid",
                        $("#addJobCommentBtn").attr("data-comment-job-id")
                    );
                    if (tinyMCE.activeEditor) {
                        formData.append("content", tinyMCE.activeEditor.getContent());
                    } else {
                        formData.append("content", $("#job_comment").val());
                    }
                },
                success: function (files, response) {
                    response = JSON.parse(response);
                    if (
                        this.getUploadingFiles().length === 0 &&
                        this.getQueuedFiles().length === 0
                    ) {
                        _job_append_html(response.jobHtml);
                        tinymce.remove("#job_comment");
                    }
                },
            })
        );

        var editorConfig = _simple_editor_config();

        editorConfig.toolbar_sticky = true

        if (typeof manual == "undefined" || manual === false) {
            editorConfig.auto_focus = true;
        }

        var taskid = $("#job-modal #jobId").val();

        editorConfig.content_style =
            "span.mention {\
			background-color: #eeeeee;\
			padding: 3px;\
		}";

        editorConfig.setup = function (editor) {
            initializeTinyMceMentions(editor, function () {
                return $.getJSON(
                    admin_url + "tasks/get_staff_names_for_mentions/" + taskid
                )
            })
        };

        editorConfig.content_style =
            "span.mention {\
				background-color: #eeeeee;\
				padding: 3px;\
			}\
			img {\
			    width: 90%;\
			    max-width: 90%;\
			    padding: 0 5%;\
			}";

        init_editor("#job_comment", editorConfig)
    }


    function edit_job_inline_description(e, id) {
        tinyMCE.remove("#job_view_description");

        if ($(e).hasClass("editor-initiated")) {
            $(e).removeClass("editor-initiated");
            return;
        }

        $(e).addClass("editor-initiated");

        $.Shortcuts.stop();

        tinymce.init({
            branding: false,
            toolbar: false,
            menubar: false,
            inline: true,
            cache_suffix: '?v=' + app.version,
            selector: "#job_view_description",
            theme: "silver",
            directionality: isRTL == "true" ? "rtl" : "",
            auto_focus: "job_view_description",
            plugins: ['quickbars', 'link', 'table', (isRTL == "true" ? " directionality" : "")],
            contextmenu: "link table paste pastetext",
            quickbars_insert_toolbar: "quicktable",
            quickbars_selection_toolbar: "bold italic | quicklink h2 h3 blockquote",
            table_default_styles: {
                width: "100%",
            },
            setup: function (editor) {
                editor.on("blur", function (e) {
                    if (editor.isDirty()) {
                        $.post(admin_url + "trade_job_management/jobs/update_job_description/" + id, {
                            job_description: editor.getContent(),
                        });
                    }

                    setTimeout(function () {
                        editor.remove();
                        $.Shortcuts.start();
                    }, 500);
                });
            },
        });
    }


    // Init task edit comment
    function edit_job_comment(id) {
        var edit_wrapper = $('[data-edit-comment="' + id + '"]');
        edit_wrapper.next().addClass("hide");
        edit_wrapper.removeClass("hide");

        tinymce.remove("#job_comment_" + id);
        var editorConfig = _simple_editor_config();
        editorConfig.auto_focus = "job_comment_" + id;
        editorConfig.toolbar_sticky = true;
        editorConfig.content_style =
            "span.mention {\
				background-color: #eeeeee;\
				padding: 3px;\
			}\
			img {\
			    width: 90%;\
			    max-width: 90%;\
			    padding: 0 5%;\
			}";

        init_editor("#job_comment_" + id, editorConfig);
        tinymce.triggerSave();
    }

    // Cancel editing commment after clicked on edit href
    function cancel_job_comment(id) {
        var edit_wrapper = $('[data-edit-comment="' + id + '"]');
        tinymce.remove('[data-edit-comment="' + id + '"] textarea');
        edit_wrapper.addClass("hide");
        edit_wrapper.next().removeClass("hide");
    }

    // Save task edited comment
    function save_edited_comment(id, job_id) {
        tinymce.triggerSave();
        var data = {};
        data.id = id;
        data.task_id = job_id;
        data.content = $('[data-edit-comment="' + id + '"]')
            .find("textarea")
            .val();
        if (is_ios()) {
            data.no_editor = true;
        }
        $.post(admin_url + "trade_job_management/jobs/edit_comment", data).done(function (response) {
            response = JSON.parse(response);
            if (response.success === true || response.success == "true") {
                alert_float("success", response.message);
                _job_append_html(response.taskHtml);
            } else {
                cancel_edit_comment(id);
            }
            tinymce.remove('[data-edit-comment="' + id + '"] textarea');
        });
    }

    function job_attachments_toggle() {
        var $taskModal = $("#job-modal");
        $taskModal
            .find(".job_attachments_wrapper .task-attachments-more")
            .toggleClass("hide");
        $taskModal
            .find(".job_attachments_wrapper .task-attachments-less")
            .toggleClass("hide");
    }


    $('.edit-timesheet-cancel').click(function () {
        $('.timesheet-edit').addClass('hide');
        $('.add-timesheet').removeClass('hide');
    });

    $('.job-single-edit-timesheet').click(function () {
        var edit_timesheet_id = $(this).data('timesheet-id');
        $('.timesheet-edit, .add-timesheet').addClass('hide');
        $('.job-modal-edit-timesheet-' + edit_timesheet_id).removeClass('hide');
    });

    $('.job-modal-edit-timesheet-form').submit(event => {
        event.preventDefault();
        $('.edit-timesheet-submit').prop('disabled', true);

        var form = new FormData(event.target);
        var data = {};

        data.timer_id = form.get('timesheet_edit_timer_id');
        data.job_id = form.get('timesheet_edit_job_id');
        data.start_time = form.get('timesheet_edit_start_time');
        data.end_time = form.get('timesheet_edit_end_time');
        data.staff_id = form.get('timesheet_edit_staff_id');
        data.cost = form.get('timesheet_edit_cost');
        data.note = form.get('timesheet_edit_note');

        $.post(admin_url + 'trade_job_management/jobs/update_timesheet', data).done(function (response) {
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                init_job_modal(data.job_id);
                alert_float('success', response.message);
            } else {
                alert_float('warning', response.message);
            }
            $('.edit-timesheet-submit').prop('disabled', false);
        });
    });
</script>
