<script>
    (function($){
        // Insert inputs on DOM ready if required elements exist
        $(function() {
            // Company search input
            if ((parseInt(<?= (int)get_option('google_geo_proposal') ?>) === 1) && $('#address').length) {
                // only inject if not already present
                if (!$('#search_address').length) {
                    var $addressGroup = $('#address').closest('.form-group');
                    var searchAddressHtml = `
                          <div class="form-group">
                            <label for="search_address" class="control-label"><?= _l('google_geo_search_address') ?></label>
                            <input type="text" id="search_address" name="search_address" class="form-control" autocomplete="off" />
                            <input type="hidden" id="latitude" name="latitude" />
                            <input type="hidden" id="longitude" name="longitude" />
                          </div>
                        `;
                    $addressGroup.before(searchAddressHtml);
                }
            }
        });

        // Initialize Autocomplete instances (callback for Google API)
        window.initAutocomplete = function() {
            // Company autocomplete
            var el = document.getElementById('search_address');
            if (el) {
                var autocomplete = new google.maps.places.Autocomplete(el, { types: ['geocode'] });
                autocomplete.setFields(['address_components', 'geometry', 'formatted_address', 'place_id']);

                autocomplete.addListener('place_changed', function() {
                    var place = autocomplete.getPlace();
                    if (!place || !place.geometry) {
                        return;
                    }

                    // Fill hidden lat/lng
                    if (place.geometry.location) {
                        var lat = place.geometry.location.lat();
                        var lng = place.geometry.location.lng();
                        var $lat = document.getElementById('latitude');
                        var $lng = document.getElementById('longitude');
                        if ($lat) $lat.value = lat;
                        if ($lng) $lng.value = lng;
                    }

                    // Populate address fields using your helper functions (must exist globally)
                    if (typeof setBuilding === 'function') setBuilding(place.address_components, '#address');
                    if (typeof setPostalCode === 'function') setPostalCode(place.address_components, '#zip');
                    if (typeof setState === 'function') setState(place.address_components, '#state');
                    if (typeof setCity === 'function') setCity(place.address_components, '#city');
                    if (typeof setArea === 'function') setArea(place.address_components, '#address');
                    if (typeof setCountry === 'function') setCountry(place.address_components, 'country');
                });
            }
        };

        // If Google API is already loaded and ready, call initAutocomplete now (safe guard)
        // This covers the case when the API script was included without callback or loaded earlier.
        function maybeCallInit() {
            if (window.google && google.maps && typeof window.initAutocomplete === 'function') {
                try { window.initAutocomplete(); } catch (e) { /* ignore */ }
            }
        }
        // call on load and also after small delay (covers async load orders)
        $(window).on('load', maybeCallInit);
        setTimeout(maybeCallInit, 1000);
    })(jQuery);
</script>