<?php
defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var object $property */

/** @var object $landlord */
$landlord = $property->landlord_data;

/** @var object $property_type */
$property_type = $property->property_type_data;

/** @var array $managements */
$managements = $property->managements;
?>
<div class="row">
    <div class="col-md-8 project-overview-left">
        <div class="panel_s">
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-12">
                        <h4 class="tw-font-semibold tw-text-base tw-mb-4">
							<?php
							echo _l('property_overview'); ?>
                        </h4>
                        <dl class="tw-grid tw-grid-cols-1 tw-gap-x-4 tw-gap-y-3 sm:tw-grid-cols-2">
                            <div class="sm:tw-col-span-1 project-overview-id">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property'); ?><?php
									echo _l('the_number_sign'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium"><?php
									echo e($property->propertyid); ?></dd>
                            </div>

                            <div class="sm:tw-col-span-1 project-overview-customer">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_landlord'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium">
                                    <a
                                            href="<?php
											echo admin_url('trade_job_management/landlords/show/'.$landlord->landlordid); ?>">
										<?php
										echo e($landlord->first_name.' '.$landlord->last_name); ?>
                                    </a>
                                </dd>
                            </div>

                            <div class="sm:tw-col-span-1 project-overview-date-created">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_address'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium">
									<?php
									echo e($property->property_address); ?>
                                </dd>
                            </div>
                            <div class="sm:tw-col-span-1 project-overview-date-created">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_type'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium">
									<?php
									echo e($property_type->type_name); ?>
                                </dd>
                            </div>
                            <div class="sm:tw-col-span-1 project-overview-date-created">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_datecreated'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium">
									<?php
									echo e(_d($property->created_at)); ?>
                                </dd>
                            </div>
                            <div class="sm:tw-col-span-1 project-overview-date-created">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_require_client_confirmation'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium">
									<?php
									echo($property->require_client_confirmation ? _l('Yes') : _l('No')); ?>
                                </dd>
                            </div>
                            <div class="sm:tw-col-span-1 project-overview-date-created">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_staffs'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-text-sm tw-text-neutral-700 tw-font-medium">
									<?php
									foreach ($managements as $member): ?>
										<?php

										if ($member != '')
										{
											echo

												'<a href="'

												.admin_url('profile/'.$member['staff_id'])

												.'">'

												.staff_profile_image(

													$member['staff_id'],

													[

														'tw-inline-block tw-h-7 tw-w-7 tw-rounded-full tw-ring-2 tw-ring-white',

													],

													'small',

													[

														'data-toggle' => 'tooltip',

														'data-title' => $member['firstname'].' '.$member['lastname'],

													],

												)

												.'</a>';
										}

										?>
									<?php
									endforeach; ?>
                                </dd>
                            </div>
                            <div class="clearfix"></div>
                            <div class="sm:tw-col-span-2 project-overview-description tc-content">
                                <dt class="tw-text-sm tw-font-normal tw-text-neutral-500">
									<?php
									echo _l('property_notes'); ?>
                                </dt>
                                <dd class="tw-mt-1 tw-space-y-5 tw-text-sm tw-text-neutral-900">
									<?php
									if (empty($property->description)) { ?>
                                        <p class="text-muted tw-mb-0">
											<?php
											echo _l('no_notes_property'); ?>
                                        </p>
									<?php
									} ?>
									<?php
									echo check_for_links($property->description); ?>
                                </dd>
                            </div>
                        </dl>

                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
						<?php

						/** @var array $property_attachments */

						$attachments_data = [];

						$i = 1;

						?>
						<?php
						if (count($property_attachments) > 0): ?>
                            <hr/>
                            <div class="row task_attachments_wrapper">
                                <div class="col-md-12">
                                    <h4 class="tw-font-semibold tw-text-base tw-mb-4">
										<?= _l('property_photos'); ?>
                                    </h4>
                                    <div class="row">
										<?php
										foreach ($property_attachments as $attachment)
										{
											ob_start();

											$path = get_upload_path_by_type('property').$property->propertyid.'/'.$attachment['file_name'];

											$href_url = admin_url('trade_job_management/properties/download/'.$attachment['attachment_key']);

											$isHtml5Video = is_html5_video($path);

											$is_image = is_image($path);

											$img_url = site_url('download/preview_image?path='.protected_file_url_by_path($path, TRUE).'&type='.$attachment['filetype']);

											$delete_attachment_url = admin_url('trade_job_management/properties/delete_attachment/'.$property->propertyid.'/'.$attachment['id']);

											?>
                                            <div class="col-md-4 task-attachment-col" data-num="<?= e($i); ?>">
                                                <ul class="list-unstyled">
                                                    <li class="task-attachment tw-mb-3 highlight-bg" style="max-height: 400px">
                                                        <div class="tw-mb-3 tw-flex tw-justify-between tw-space-x-4">
                                                            <span><?= e(_l('project_file_uploaded_by').' '.get_staff_full_name($attachment['staffid'])) ?></span>
                                                            <div class="tw-flex tw-gap-2">
                                                                <a href="<?php
																echo $href_url ?>"
                                                                   class="text-success"><i class="fa fa-download"></i></a>
																<?php
																if ($attachment['staffid'] == get_staff_user_id()): ?>
                                                                    <a href="<?php
																	echo $delete_attachment_url ?>"
                                                                       class="text-danger _delete"><i class="fa fa-remove"></i></a>
																<?php
																endif ?>
                                                            </div>
                                                        </div>
                                                        <hr/>
                                                        <div class="tw-flex tw-flex-col tw-justify-center tw-h-full tw-w-full <?php
														if ($is_image)
														{
															echo 'preview-image';
														} elseif ( ! $isHtml5Video)
														{
															echo 'task-attachment-no-preview';
														} ?>">
															<?php
															if ( ! $isHtml5Video) { ?>
                                                            <a href="<?= $href_url ?>"
                                                               target="_blank"
                                                               class="tw-inline-block"
																<?php
																if ($is_image) { ?>
                                                                    data-lightbox="task-attachment"
																<?php
																} ?> class="<?php
															if ($isHtml5Video)
															{
																echo 'video-preview';
															} ?>">
																<?php
																} ?>
																<?php
																if ($is_image) { ?>
                                                                    <img src="<?= e($img_url); ?>"
                                                                         class="img img-responsive">
																<?php
																} elseif ($isHtml5Video) { ?>
                                                                    <video width="100%" height="100%"
                                                                           src="<?= site_url('download/preview_video?path='.protected_file_url_by_path($path).'&type='.$attachment['filetype']); ?>"
                                                                           controls>
                                                                        Your browser does not support the video tag.
                                                                    </video>
																<?php
																} else { ?>
                                                                    <i
                                                                            class="<?= get_mime_class($attachment['filetype']); ?>"></i>
																	<?= e($attachment['file_name']); ?>
																<?php
																} ?>
																<?php
																if ( ! $isHtml5Video) { ?>
                                                            </a>
														<?php
														} ?>
                                                            <div class="mtop2"><?php
																echo $attachment['file_name'] ?></div>
                                                        </div>
                                                        <div class="clearfix"></div>
                                                    </li>
                                                </ul>
                                            </div>
											<?php

											$attachments_data[$attachment['id']] = ob_get_contents();

											ob_end_clean();

											echo $attachments_data[$attachment['id']];

											$i++; ?>
											<?php
										} ?>
                                    </div>
                                </div>
                            </div>
						<?php
						endif ?>
						<?php
						echo form_open_multipart('trade_job_management/properties/add_photos/'.$property->propertyid); ?>
                        <div class="row attachments">
                            <h4 class="col-md-12 tw-font-semibold tw-text-base tw-mb-4">
								<?php
								echo _l('property_add_more_photos'); ?>
                            </h4>
                            <div class="attachment col-md-6">
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-btn"><button class="btn btn-default add_more_attachments" type="button"><i class="fa fa-plus"></i></button></span>
                                        <input type="file"
                                               accept="image/*"
                                               extension="<?php
										       echo str_replace('.', '', get_option('allowed_files')); ?>"
                                               filesize="<?php
										       echo file_upload_max_size(); ?>"
                                               class="form-control" name="attachments[0]">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tw-mt-2">
                            <button type="submit" data-form="#project_form" class="btn btn-primary" autocomplete="off"
                                    data-loading-text="<?php
							        echo _l('wait_text'); ?>">
								<?php
								echo _l('submit'); ?>
                            </button>
                        </div>
						<?php
						echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
