<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var object $job */

?>
<?php
init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <i class="fa fa-edit"></i>
							<?php
							echo _l('edit_daily_log'); ?>
                        </h4>
                        <hr class="hr-panel-heading"/>

						<?php
						echo form_open_multipart(admin_url('trade_job_management/jobs/edit_daily_log/'.$log->daily_log_id), ['id' => 'daily-log-edit-form', 'class' => 'dropzone dropzone-manual']); ?>
                        <input type="hidden" name="daily_log_id" value="<?php
						echo $log->daily_log_id; ?>">
                        <input type="hidden" name="job_id" value="<?php
						echo $log->job_id; ?>">

                        <div class="form-group">
                            <label for="log_date" class="control-label">
								<?php
								echo _l('log_date'); ?>
                            </label>
                            <input type="text" class="form-control" value="<?php
							echo _d($log->log_date); ?>" disabled>
                        </div>

                        <div class="form-group">
                            <label for="comments" class="control-label">
								<?php
								echo _l('work_comments'); ?> <span class="text-danger">*</span>
                            </label>
							<?php
							echo render_textarea('comments', '', $log->comments, ['rows' => 8, 'required' => TRUE]); ?>
                        </div>

                        <!-- Existing Photos -->
						<?php
						if ( ! empty($log->photos))
						{ ?>
                            <div class="form-group">
                                <label class="control-label">
									<?php
									echo _l('photos'); ?> (<?php
									echo count($log->photos); ?>)
                                </label>
                                <div class="row">
									<?php
									foreach ($log->photos as $photo)
									{ ?>
                                        <div class="col-md-2 col-sm-3 col-xs-6 tw-mb-3 padding-5" id="photo-<?php
										echo $photo['id']; ?>">
											<?php
											$href_url  = site_url('download/file/taskattachment/'.$photo['attachment_key']);
											$photo_url = site_url(
												'download/preview_image?path='.protected_file_url_by_path(
													get_upload_path_by_type('job')
													.$job->jobid
													.'/daily_logs/'
													.$photo['file_name'],
												),
											);
											?>
                                            <div class="thumbnail tw-flex tw-flex-col" style="min-height: 200px;">
                                                <a href="<?php
												echo $href_url ?>" class="lightbox tw-relative" data-lightbox="daily-log-edit">
													<?php
													if (is_image(get_upload_path_by_type('job').$job->jobid.'/daily_logs/'.$photo['file_name']))
													{ ?>
                                                        <img src="<?php
														echo $photo_url ?>"
                                                             class="img-responsive"
                                                             style="width: 100%; height: 150px; object-fit: cover;">
														<?php
													} else
													{ ?>
                                                        <div class="text-center" style="padding: 20px; height: 150px; display: flex; align-items: center; justify-content: center;">
                                                            <i class="<?php
															echo get_mime_class($photo['filetype']); ?> fa-4x"></i>
                                                        </div>
														<?php
													} ?>
                                                </a>
                                                <div class="caption text-center">
                                                    <small style="display: block; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><?php
														echo $photo['file_name']; ?></small>
                                                    <button type="button" class="btn btn-xs btn-danger mtop5 delete-photo" data-photo-id="<?php
													echo $photo['id']; ?>">
                                                        <i class="fa fa-trash"></i> <?php
														echo _l('delete'); ?>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
										<?php
									} ?>
                                </div>
                            </div>
							<?php
						} ?>

                        <!-- Upload New Photos -->
                        <hr class="hr-panel-heading"/>
                        <h5><?php
							echo _l('upload_photos'); ?></h5>
                        <div id="dropzoneJobDailyLogEdit" class="dropzoneDragArea dz-default dz-message task-comment-dropzone">
                            <span><?= _l('drop_files_here_to_upload'); ?></span>
                        </div>
                        <div class="dropzone-job-daily-log-edit-previews dropzone-previews"></div>
                        <hr class="hr-panel-heading"/>

                        <div class="form-group">
                            <div class="checkbox checkbox-primary">
                                <input type="hidden" name="is_visible_to_customer" value="0">
                                <input type="checkbox" name="is_visible_to_customer" id="is_visible_to_customer" value="1" <?php
								echo $log->is_visible_to_customer == 1 ? 'checked' : ''; ?>>
                                <label for="is_visible_to_customer">
									<?php
									echo _l('visible_to_customer'); ?>
                                </label>
                            </div>
                            <p class="text-muted">
                                <small><?php
									echo _l('internal_only'); ?> - <?php
									echo _l('daily_log_visibility'); ?></small>
                            </p>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-check"></i> <?php
								echo _l('submit'); ?>
                            </button>
                            <a href="<?php
							echo admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid); ?>" class="btn btn-default">
                                <i class="fa fa-times"></i> <?php
								echo _l('cancel'); ?>
                            </a>
                        </div>
						<?php
						echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
init_tail(); ?>

<script>
    let dailyLogEditAttachmentDropzone;
    Dropzone.autoDiscover = false;

    $(function () {
        if (Dropzone.instances.length > 0) Dropzone.instances.forEach(dz => dz.destroy())

        if (typeof (dailyLogEditAttachmentDropzone) != 'undefined') {
            dailyLogEditAttachmentDropzone.destroy();
            dailyLogEditAttachmentDropzone = null;
        }

        appValidateForm($('#daily-log-edit-form'), {
            comments: 'required'
        });

        $('#daily-log-edit-form').on('submit', function (e) {
            e.preventDefault();
            if (dailyLogEditAttachmentDropzone.files.length === 0) {
                const data = $(this).serialize();
                const url = this.action;
                $.post(url, data).done(function (response) {
                    response = JSON.parse(response);
                    if (response.success === true) {
                        alert_float("success", response.message);
                    } else {
                        alert_float("warning", response.message);
                    }
                    setTimeout(function () {
                        window.location.href = '<?php echo admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid) ?>'
                    }, 1500);
                });
            } else {
                dailyLogEditAttachmentDropzone.processQueue();
            }
        })

        dailyLogEditAttachmentDropzone = new Dropzone(
            "#daily-log-edit-form",
            appCreateDropzoneOptions({
                uploadMultiple: true,
                clickable: "#dropzoneJobDailyLogEdit",
                previewsContainer: ".dropzone-job-daily-log-edit-previews",
                autoProcessQueue: false,
                addRemoveLinks: true,
                parallelUploads: 20,
                maxFiles: 20,
                paramName: "file",
                sending: function (file, xhr, formData) {
                    $('#daily-log-edit-form button').attr('disabled', true);
                },
                success: function (files, response) {
                    if (
                        this.getUploadingFiles().length === 0 &&
                        this.getQueuedFiles().length === 0
                    ) {
                        alert_float("success", '<?php echo _l('daily_log_updated') ?>');
                        setTimeout(function () {
                            window.location.href = '<?php echo admin_url('trade_job_management/jobs/daily_logs/'.$job->jobid) ?>'
                        }, 1500);
                    }
                },
            })
        );

        $(document).on('click', '.delete-photo', function (e) {
            e.preventDefault();
            const photoId = $(this).data('photo-id');
            const photoEl = $('#photo-' + photoId);
            $.post('<?php echo admin_url('trade_job_management/jobs/delete_daily_log_photo/') ?>' + photoId, {
                job_id: <?php echo $job->jobid; ?>,
                _token: '<?php echo $this->security->get_csrf_hash(); ?>'
            }).done(function (response) {
                response = JSON.parse(response);
                if (response.success === true) {
                    alert_float("success", response.message);
                    photoEl.remove();
                } else {
                    alert_float("warning", response.message);
                }
            });
        });
    });
</script>
</body>
</html>
