<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_148 extends App_module_migration {

	protected $module_name = 'trade_job_management';
	protected int $version = 148;

	public function up()
	{
		zegaware_add_migration_log($this->module_name, $this->version);

		// Add require_client_confirmation field to properties table
		if ( ! $this->ci->db->field_exists('require_client_confirmation', db_prefix().'tjm_properties'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_properties ADD COLUMN `require_client_confirmation` TINYINT(1) DEFAULT 0 COMMENT "Require client confirmation before marking job as complete"');
		}
	}

	public function down()
	{
		zegaware_delete_migration_log($this->module_name, $this->version);

		if ($this->ci->db->field_exists('require_client_confirmation', db_prefix().'tjm_properties'))
		{
			$this->ci->db->query('ALTER TABLE '.db_prefix().'tjm_properties DROP COLUMN `require_client_confirmation`');
		}
	}

}
