<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Job_daily_log_added extends App_mail_template {

	protected $for = 'customer';

	protected $contact_email;

	protected $job_id;

	protected $daily_log_id;

	protected $contact_id;

	public $slug = 'job-daily-log-added';

	public $rel_type = 'job';

	public function __construct($contact_email, $job_id, $daily_log_id, $contact_id)
	{
		parent::__construct();

		$this->contact_email = $contact_email;
		$this->job_id        = $job_id;
		$this->daily_log_id  = $daily_log_id;
		$this->contact_id    = $contact_id;
	}

	public function build()
	{
		$CI = &get_instance();
		$CI->load->model('jobs_model');
		$CI->load->model('job_daily_logs_model');

		$job        = $CI->jobs_model->get($this->job_id);
		$daily_log  = $CI->job_daily_logs_model->get($this->daily_log_id);

		if ( ! $job || ! $daily_log)
		{
			return FALSE;
		}

		$client_id = $job->client->userid ?? NULL;

		$this->to($this->contact_email)
			 ->set_rel_id($this->job_id)
			 ->set_merge_fields('landlord_merge_fields', $client_id, $this->contact_id)
			 ->set_merge_fields('jobs_merge_fields', $this->job_id, TRUE);
	}

}
