<?php

function get_sql_select_job_specialists_ids()
{
    return '(SELECT GROUP_CONCAT(staff_id ORDER BY ' . db_prefix() . 'tjm_job_specialists.jsid ASC SEPARATOR ",") FROM ' . db_prefix() . 'tjm_job_specialists WHERE job_id=' . db_prefix() . 'tjm_jobs.jobid)';
}

function get_sql_select_job_specialists_full_names()
{
    return (
        '(SELECT GROUP_CONCAT(CONCAT(firstname, \' \', lastname) ORDER BY '
        . db_prefix()
        . 'tjm_job_specialists.jsid ASC SEPARATOR ",") FROM '
        . db_prefix()
        . 'tjm_job_specialists JOIN '
        . db_prefix()
        . 'staff ON '
        . db_prefix()
        . 'staff.staffid = '
        . db_prefix()
        . 'tjm_job_specialists.staff_id WHERE job_id='
        . db_prefix()
        . 'tjm_jobs.jobid)'
    );
}

/**
 * This text is used in WHERE statements for tasks if the staff member don't have permission for tasks VIEW
 * This query will shown only tasks that are created from current user, public tasks or where this user is added is task follower.
 * Other statement will be included the tasks to be visible for this user only if Show All Tasks For Project Members is set to YES
 *
 * @return string
 */
function get_jobs_where_string($table = true)
{
    $_tasks_where =
        '('
        . db_prefix()
        . 'tjm_jobs.jobid IN (SELECT job_id FROM '
        . db_prefix()
        . 'tjm_job_specialists WHERE staff_id = '
        . get_staff_user_id()
        . ') OR created_by='
        . get_staff_user_id()
        . ' OR ('
        . db_prefix()
        . 'tjm_jobs.property_id IN (SELECT property_id FROM '
        . db_prefix()
        . 'tjm_property_managements WHERE staff_id='
        . get_staff_user_id()
        . '))';

    if ($table) {
        $_tasks_where = 'AND ' . $_tasks_where;
    }

    return $_tasks_where;
}

/**
 * Job attachments upload array
 * Multiple job attachments can be upload if input type is array or dropzone plugin is used
 *
 * @param  mixed  $job_id  job id
 * @param  string  $index_name  attachments index, in different forms different index name is used
 *
 * @return array|false
 */
function handle_job_attachments_array($job_id, $index_name = 'attachments')
{
    $hookData = hooks()->apply_filters('before_handle_job_attachments_array', [
        'job_id' => $job_id,
        'index_name' => $index_name,
        'uploaded_files' => [],
        'handled_externally' => false, // e.g. module upload to s3
        'files' => $_FILES,
    ]);

    if ($hookData['handled_externally']) {
        return count($hookData['uploaded_files']) > 0 ? $hookData['uploaded_files'] : false;
    }

    $uploaded_files = [];
    $path = get_upload_path_by_type('job') . $job_id . '/';

    if (isset($_FILES[$index_name]['name']) && ($_FILES[$index_name]['name'] != '' || is_array($_FILES[$index_name]['name']) && count($_FILES[$index_name]['name']) > 0)) {
        if (!is_array($_FILES[$index_name]['name'])) {
            $_FILES[$index_name]['name'] = [$_FILES[$index_name]['name']];
            $_FILES[$index_name]['type'] = [$_FILES[$index_name]['type']];
            $_FILES[$index_name]['tmp_name'] = [$_FILES[$index_name]['tmp_name']];
            $_FILES[$index_name]['error'] = [$_FILES[$index_name]['error']];
            $_FILES[$index_name]['size'] = [$_FILES[$index_name]['size']];
        }

        _file_attachments_index_fix($index_name);
        for ($i = 0; $i < count($_FILES[$index_name]['name']); $i++) {
            // Get the temp file path
            $tmpFilePath = $_FILES[$index_name]['tmp_name'][$i];

            // Make sure we have a filepath
            if (!empty($tmpFilePath) && $tmpFilePath != '') {
                if (_perfex_upload_error($_FILES[$index_name]['error'][$i]) || !_upload_extension_allowed($_FILES[$index_name]['name'][$i])) {
                    continue;
                }

                _maybe_create_upload_path($path);
                $filename = unique_filename($path, $_FILES[$index_name]['name'][$i]);
                $newFilePath = $path . $filename;
                // Upload the file into the temp dir
                if (move_uploaded_file($tmpFilePath, $newFilePath)) {
                    array_push($uploaded_files, [
                        'file_name' => $filename,
                        'filetype' => $_FILES[$index_name]['type'][$i],
                    ]);

                    if (is_image($newFilePath)) {
                        create_img_thumb($path, $filename);
                    }
                }
            }
        }
    }

    if (count($uploaded_files) > 0) {
        return $uploaded_files;
    }

    return false;
}
