<?php

defined('BASEPATH') or exit('No direct script access allowed');

return App_table::find('jobs')
                ->outputUsing(function ($params) {
	                extract($params);

	                $hasPermissionEdit   = staff_can('edit', 'tasks');
	                $hasPermissionDelete = staff_can('delete', 'tasks');
	                $tasksPriorities     = get_tasks_priorities();
	                $jobStatuses         = $this->ci->jobs_model->get_statuses();

	                $aColumns = [
		                '1', // bulk actions
		                'jobid as id',
		                'job_title',
		                'type_name',
		                'propertyid',
		                'property_name',
		                'priority',
		                'nte',
		                db_prefix().'tjm_jobs.status as status',
		                'contact_name',
		                'contact_phone',
		                db_prefix().'tjm_jobs.created_at as created_at',
		                'preferred_visit_date',
		                db_prefix().'tjm_jobs.created_at as created_at',
		                '(SELECT SUM('.db_prefix().'tjm_job_timers.total) WHERE job_id='.db_prefix().'tjm_jobs.jobid) as job_total',
	                ];

	                $sIndexColumn = 'id';
	                $sTable       = db_prefix().'tjm_jobs';

	                $join = [
		                'JOIN '.db_prefix().'tjm_job_types ON '.db_prefix().'tjm_job_types.jobtypeid = '.db_prefix().'tjm_jobs.job_type_id',
		                'JOIN '.db_prefix().'tjm_properties ON '.db_prefix().'tjm_properties.propertyid = '.db_prefix().'tjm_jobs.property_id',
		                'LEFT JOIN '.db_prefix().'tjm_job_timers ON '.db_prefix().'tjm_job_timers.job_id = '.db_prefix().'tjm_jobs.jobid',
	                ];

	                $where = [];

	                if ($filtersWhere = $this->getWhereFromRules())
	                {
		                $where[] = $filtersWhere;
	                }

	                // Dashboard my tasks table
	                if ($this->ci->input->post('my_tasks'))
	                {
		                $where[] = 'AND ('.db_prefix().'tjm_jobs.id IN (SELECT job_id FROM '.db_prefix().'tjm_job_specialists WHERE staff_id = '.get_staff_user_id().') AND status != '.Tasks_model::STATUS_COMPLETE.')';
	                }

	                if (isset($property_id))
	                {
		                $where[] = 'AND property_id='.$property_id;
	                }

	                $additionalSelect = [
		                get_sql_select_job_specialists_ids().' as specialists_ids',
		                get_sql_select_job_specialists_full_names().' as specialist_names',
		                '(SELECT staff_id FROM '.db_prefix().'tjm_job_specialists WHERE job_id='.db_prefix().'tjm_jobs.jobid AND staff_id='.get_staff_user_id().') as is_specialist',
	                ];

	                $groupBy = [
		                'jobid',
		                //		                'job_title',
		                //		                'type_name',
		                //		                'propertyid',
		                //		                'property_name',
		                //		                'priority',
		                //		                'nte',
		                //		                'status',
		                //		                'contact_name',
		                //		                'contact_phone',
		                //		                'created_at',
		                //		                'preferred_visit_date',
		                //		                'created_at',
		                //		                'job_total',
		                //		                'is_specialist',
		                //		                'specialist_names',
		                //		                'specialists_ids',
	                ];
	                $groupBy = implode(', ', $groupBy);
	                $result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalSelect, " GROUP BY $groupBy");

	                $output  = $result['output'];
	                $rResult = $result['rResult'];

	                foreach ($rResult as $aRow)
	                {
		                $row = [];

		                $row[] = '<div class="checkbox"><input type="checkbox" value="'.$aRow['id'].'"><label></label></div>';

		                $row[] = '<a href="'.admin_url('jobs/show/'.$aRow['id']).'" onclick="init_job_modal('.$aRow['id'].'); return false;">'.$aRow['id'].'</a>';

		                $outputName = '';

		                $outputName
			                .= '<a href="'
			                   .admin_url('trade_job_management/jobs/show/'.$aRow['id'])
			                   .'" class="display-block main-tasks-table-href-name'
			                   .(! empty($aRow['rel_id']) ? ' mbot5' : '')
			                   .'" onclick="init_job_modal('
			                   .$aRow['id']
			                   .'); return false;">'
			                   .e($aRow['job_title'])
			                   .'</a>';

		                $outputName .= '<div class="row-options">';
		                if ($hasPermissionEdit)
		                {
			                $outputName .= '<span class="tw-text-neutral-300"></span><a href="#" onclick="edit_job('.$aRow['id'].'); return false">'._l('edit').'</a>';
		                }

		                if ($hasPermissionDelete)
		                {
			                $outputName .= '<span class="tw-text-neutral-300"> | </span><a href="'.admin_url('trade_job_management/jobs/delete/'.$aRow['id']).'" class="text-danger _delete task-delete">'._l('delete').'</a>';
		                }
		                $outputName .= '</div>';

		                $row[] = $outputName;

		                $row[] = $aRow['type_name'];

		                $property_url = '<a href="'.admin_url('trade_job_management/properties/view/'.$aRow['propertyid']).'">'.$aRow['property_name'].'</a>';
		                $row[]        = $property_url;

		                if (staff_can('edit', 'tasks') && $aRow['status'] != Jobs_model::STATUS_COMPLETE)
		                {
			                $outputPriority = '<div class="dropdown inline-block table-export-exclude">';
			                $outputPriority
			                                .= '<a href="#" style="color:'
			                                   .e(task_priority_color($aRow['priority']))
			                                   .'" class="dropdown-toggle tw-flex tw-items-center tw-gap-1 tw-flex-nowrap hover:tw-opacity-80 tw-align-middle" id="tableTaskPriority-'
			                                   .$aRow['id']
			                                   .'" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
			                $outputPriority .= e(task_priority($aRow['priority']));
			                $outputPriority .= '<i class="chevron tw-shrink-0"></i>';
			                $outputPriority .= '</a>';

			                $outputPriority .= '<ul class="dropdown-menu" aria-labelledby="tableTaskPriority-'.$aRow['id'].'">';
			                foreach ($tasksPriorities as $priority)
			                {
				                if ($aRow['priority'] != $priority['id'])
				                {
					                $outputPriority .= '<li>
                  <a href="#" onclick="job_change_priority('.$priority['id'].','.$aRow['id'].'); return false;">
                     '.e($priority['name']).'
                  </a>
               </li>';
				                }
			                }
			                $outputPriority .= '</ul>';
			                $outputPriority .= '</div>';
		                } else
		                {
			                $outputPriority = '<span style="color:'.e(task_priority_color($aRow['priority'])).';" class="inline-block">'.e(task_priority($aRow['priority'])).'</span>';
		                }
		                $row[] = $outputPriority;

		                $canChangeStatus = $aRow['is_specialist'] != '0' || staff_can('edit', 'tasks');
		                $status          = get_job_status_by_id($aRow['status']);
		                $outputStatus    = '';

		                $outputStatus
			                          .= '<span class="label" style="color:'
			                             .$status['color']
			                             .';border:1px solid '
			                             .adjust_hex_brightness($status['color'], 0.4)
			                             .';background: '
			                             .adjust_hex_brightness($status['color'], 0.04)
			                             .';" task-status-table="'
			                             .e($aRow['status'])
			                             .'">';
		                $outputStatus .= e($status['name']);

		                if ($canChangeStatus)
		                {
			                $outputStatus .= '<div class="dropdown inline-block mleft5 table-export-exclude">';
			                $outputStatus .= '<a href="#" style="font-size:14px;vertical-align:middle;" class="dropdown-toggle text-dark" id="tableTaskStatus-'.$aRow['id']
			                                 .'" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
			                $outputStatus .= '<span data-toggle="tooltip" title="'._l('ticket_single_change_status').'"><i class="fa-solid fa-chevron-down tw-opacity-70"></i></span>';
			                $outputStatus .= '</a>';

			                $outputStatus .= '<ul class="dropdown-menu dropdown-menu-right" aria-labelledby="tableTaskStatus-'.$aRow['id'].'">';
			                foreach ($jobStatuses as $jobStatus)
			                {
				                if ($aRow['status'] != $jobStatus['id'])
				                {
					                $outputStatus .= '<li>
                  <a href="#" onclick="job_mark_as('.$jobStatus['id'].','.$aRow['id'].'); return false;">                    
                     '.e(_l('job_mark_as', $jobStatus['name'])).'
                  </a>
               </li>';
				                }
			                }
			                $outputStatus .= '</ul>';
			                $outputStatus .= '</div>';
		                }

		                $outputStatus .= '</span>';

		                $row[] = $outputStatus;

		                $nte       = floatval($aRow['nte']);
		                $job_total = floatval($aRow['job_total']);

		                $row[] = app_format_money($nte, get_base_currency());
		                if ($nte > 0 && $nte < $job_total)
		                {
			                $row[] = '<span class="text-nowrap text-danger">' . app_format_money($job_total, get_base_currency()).'&nbsp;<span class="label label-danger tw-font-medium">'._l('job_nte_over').'</span></span>';
		                } else
		                {
			                $row[] = '<span class="text-nowrap text-success">'.app_format_money($job_total, get_base_currency()).'</span>';
		                }

		                $row[] = $aRow['contact_name'];
		                $row[] = $aRow['contact_phone'];

		                $row[] = format_members_by_ids_and_names($aRow['specialists_ids'], $aRow['specialist_names']);

		                $date_added = $aRow['created_at'];
		                $date_added = DateTime::createFromFormat('Y-m-d H:i:s', $date_added);
		                $row[]      = e($date_added->format('d-m-Y g:ia'));

		                $start_date = $aRow['preferred_visit_date'];
		                $start_date = DateTime::createFromFormat('Y-m-d H:i:s', $start_date);
		                $row[]      = e($start_date->format('d-m-Y'));

		                // Custom fields add values
		                foreach ($customFieldsColumns as $customFieldColumn)
		                {
			                $row[] = strpos($customFieldColumn, 'date_picker_') !== FALSE ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn];
		                }

		                $row['DT_RowClass'] = 'has-row-options';

		                if ( ! empty($aRow['duedate']) && $aRow['duedate'] < date('Y-m-d') && $aRow['status'] != Tasks_model::STATUS_COMPLETE)
		                {
			                $row['DT_RowClass'] .= ' danger';
		                }

		                $row = hooks()->apply_filters('tasks_table_row_data', $row, $aRow);

		                $output['aaData'][] = $row;
	                }

	                return $output;
                })
                ->setRules([
	                App_table_filter::new('name', 'TextRule')->label(_l('tasks_dt_name')),
	                App_table_filter::new('created_at', 'DateRule')->label(_l('tasks_dt_datestart')),
	                App_table_filter::new('duedate', 'DateRule')->label(_l('task_duedate'))->withEmptyOperators(),
	                App_table_filter::new('status', 'MultiSelectRule')->label(_l('task_status'))->options(function ($ci) {
		                return collect($ci->tasks_model->get_statuses())->map(fn($status)
			                => [
			                'value' => $status['id'],
			                'label' => $status['name'],
		                ])->all();
	                }),
	                App_table_filter::new('priority', 'MultiSelectRule')->label(_l('tasks_list_priority'))->options(function ($ci) {
		                return collect(get_tasks_priorities())->map(fn($priority)
			                => [
			                'value' => $priority['id'],
			                'label' => $priority['name'],
		                ])->all();
	                }),
	                App_table_filter::new('todays_tasks', 'BooleanRule')->label(_l('todays_tasks'))->raw(function ($value) {
		                return '(startdate '.($value == '1' ? '=' : '!=').' "'.date('Y-m-d').'") AND status != '.Tasks_model::STATUS_COMPLETE;
	                }),
	                App_table_filter::new('duedate_passed', 'BooleanRule')->label(_l('task_list_duedate_passed'))->raw(function ($value) {
		                return '(startdate '.($value == '1' ? '=' : '!=').' "'.date('Y-m-d').'") AND status != '.Tasks_model::STATUS_COMPLETE;
	                }),
	                App_table_filter::new('not_assigned', 'BooleanRule')->label(_l('task_list_not_assigned'))->raw(function ($value) {
		                return db_prefix().'tasks.id '.($value == '1' ? 'NOT IN' : 'IN').' (SELECT taskid FROM '.db_prefix().'task_assigned)';
	                }),
	                App_table_filter::new('my_tasks', 'BooleanRule')->label(_l('tasks_view_assigned_to_user'))->raw(function ($value) {
		                return '('.db_prefix().'tasks.id '.($value == '1' ? 'IN' : 'NOT IN').' (SELECT taskid FROM '.db_prefix().'task_assigned WHERE staffid = '.get_staff_user_id().'))';
	                }),
	                App_table_filter::new('my_following_tasks', 'BooleanRule')->label(_l('tasks_view_follower_by_user'))->raw(function ($value) {
		                return '('.db_prefix().'tasks.id '.($value == '1' ? 'IN' : 'NOT IN').' (SELECT taskid FROM '.db_prefix().'task_followers WHERE staffid = '.get_staff_user_id().'))';
	                }),
	                App_table_filter::new('upcoming_tasks', 'BooleanRule')->label(_l('upcoming_tasks'))->raw(function ($value) {
		                return '(duedate '.($value == '1' ? '<' : '>').' "'.date('Y-m-d').'" AND duedate IS NOT NULL) AND status != '.Tasks_model::STATUS_COMPLETE;
	                }),
	                App_table_filter::new('recurring', 'BooleanRule')->label(_l('recurring_jobs'))->isVisible(fn() => staff_can('create', 'tasks') || staff_can('edit', 'tasks')),
	                App_table_filter::new('billable', 'BooleanRule')->label(_l('task_billable'))->isVisible(fn() => staff_can('create', 'invoices')),
	                App_table_filter::new('billed', 'BooleanRule')->label(_l('task_billed'))->isVisible(fn() => staff_can('create', 'invoices')),
	                App_table_filter::new('assigned', 'MultiSelectRule')
	                                ->label(_l('task_assigned'))
	                                ->isVisible(fn() => staff_can('view', 'tasks'))
	                                ->options(function ($ci) {
		                                return collect($ci->misc_model->get_tasks_distinct_assignees())->map(function ($staff) {
			                                return [
				                                'value' => $staff['assigneeid'],
				                                'label' => get_staff_full_name($staff['assigneeid']),
			                                ];
		                                })->all();
	                                })
	                                ->raw(function ($value, $operator, $sqlOperator) {
		                                $dbPrefix    = db_prefix();
		                                $sqlOperator = $sqlOperator['operator'];

		                                return "({$dbPrefix}tasks.id IN (SELECT taskid FROM {$dbPrefix}task_assigned WHERE staffid $sqlOperator ('".implode("','", $value)."')))";
	                                }),
                ]);
