<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var object $property */

/** @var object $landlord_data */
$landlord_data = $property->landlord_data;
?>
<?php
init_head(); ?>
<div id="wrapper">
	<?php
	echo form_hidden('project_id', $property->propertyid) ?>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="_buttons">
                    <div class="row">
                        <div class="col-md-7 project-heading">
                            <div class="tw-flex tw-flex-wrap tw-items-center">
                                <h3 class="hide project-name"><?php
									echo e($property->property_name); ?></h3>
                                <div id="project_view_name" class="tw-mr-3 tw-max-w-[350px]">
                                    <div class="tw-w-full">
                                        <div class="tw-font-medium" style="font-size: 19px;"> <?php
											echo e($property->property_name); ?> - <?php
											echo $landlord_data->first_name.' '.$landlord_data->last_name ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5 text-right">
							<?php
							if (staff_can('create', 'tasks'))
							{ ?>
                                <a href="#"
                                   class="btn btn-primary"
                                   onclick="new_job(<?php
								   if ($property)
								   {
									   echo "'".admin_url('trade_job_management/jobs/create/'.$property->propertyid)."'";
								   } ?>); return false;" class="btn btn-primary pull-left new">
                                    <i class="fa-regular fa-plus tw-mr-1"></i>
									<?php
									echo _l('new_job'); ?>
                                </a>
								<?php
							} ?>
                            <div class="btn-group">
                                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                                        aria-haspopup="true" aria-expanded="false">
									<?php
									echo _l('more'); ?> <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right width200 project-actions">
									<?php
									if (staff_can('edit', 'projects'))
									{ ?>
                                        <li>
                                            <a href="<?php
											echo admin_url('trade_job_management/properties/edit/'.$property->propertyid); ?>">
												<?php
												echo _l('edit_property'); ?>
                                            </a>
                                        </li>
										<?php
									} ?>
									<?php
									if (staff_can('delete', 'projects'))
									{ ?>
                                        <li>
                                            <a href="<?php
											echo admin_url('trade_job_management/properties/delete/'.$property->propertyid); ?>"
                                               class="_delete">
                                                <span class="text-danger"><?php
	                                                echo _l('delete_property'); ?></span>
                                            </a>
                                        </li>
										<?php
									} ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="project-menu-panel tw-my-5">
					<?php
					$this->load->view('properties/tabs/property_tabs', ['current_tab' => $current_tab]); ?>
                </div>
				<?php
				$this->load->view('properties/tabs/property_'.$current_tab); ?>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<div class="modal fade" id="add-edit-members" tabindex="-1" role="dialog">
    <div class="modal-dialog">
		<?php
		echo form_open(admin_url('projects/add_edit_members/'.$property->propertyid)); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php
					echo _l('project_members'); ?></h4>
            </div>
            <div class="modal-body">
				<?php
				$selected = [];
				foreach ($members as $member)
				{
					array_push($selected, $member['staff_id']);
				}
				echo render_select('project_members[]', $staff, ['staffid', ['firstname', 'lastname']], 'project_members', $selected, ['multiple' => TRUE, 'data-actions-box' => TRUE], [], '', '', FALSE);
				?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php
					echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" autocomplete="off"
                        data-loading-text="<?php
				        echo _l('wait_text'); ?>"><?php
					echo _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
		<?php
		echo form_close(); ?>
    </div>
</div>
<?php
init_tail(); ?>
<?php
if ($current_tab === 'jobs'): ?>
    <script>
        $(function () {
            initDataTable('.table-jobs', admin_url + 'trade_job_management/properties/jobs_table/<?php echo $property->propertyid ?>', undefined, undefined, {}, [5, 'asc']);
        });

		<?php if ($job_id): ?>
        init_job_modal(<?php echo $job_id; ?>);
		<?php endif ?>
        // Init task modal and get data from server
        function init_job_modal(task_id, comment_id) {
            var queryStr = "";
            var $leadModal = $("#lead-modal");
            var $taskAddEditModal = $("#_task_modal");
            if ($leadModal.is(":visible")) {
                queryStr +=
                    "?opened_from_lead_id=" + $leadModal.find('input[name="leadid"]').val();
                $leadModal.modal("hide");
            } else if ($taskAddEditModal.attr("data-lead-id") != undefined) {
                queryStr +=
                    "?opened_from_lead_id=" + $taskAddEditModal.attr("data-lead-id");
            }

            requestGet("trade_job_management/jobs/get_job_data/" + task_id + queryStr)
                .done(function (response) {
                    _task_append_html(response);
                    if (typeof comment_id != "undefined") {
                        setTimeout(function () {
                            $('[data-task-comment-href-id="' + comment_id + '"]').click();
                        }, 1000);
                    }
                })
                .fail(function (data) {
                    $("#job-modal").modal("hide");
                    alert_float("danger", data.responseText);
                });
        }

        // Go to edit view
        function edit_job(job_id) {
            requestGet("trade_job_management/jobs/edit/" + job_id).done(function (response) {
                $("#_task").html(response);
                $("#job-modal").modal("hide");
                $("body").find("#_task_modal").modal({
                    show: true,
                    backdrop: "static",
                });
            });
        }

        // Mark job status
        function job_mark_as(status, job_id, url) {
            url = typeof url == "undefined" ? "trade_job_management/jobs/mark_as/" + status + "/" + job_id : url;
            var jobModalVisible = $("#task-modal").is(":visible");
            url += "?single_job=" + jobModalVisible;
            $("body").append('<div class="dt-loader"></div>');
            requestGetJSON(url).done(function (response) {
                $("body").find(".dt-loader").remove();
                if (response.success === true || response.success == "true") {
                    reload_jobs_tables();
                    if (jobModalVisible) {
                        _task_append_html(response.jobHtml);
                    }
                    alert_float("success", response.message);
                }
            });
        }

        // function reload_jobs_tables() {
        //     var av_tasks_tables = [
        //         ".table-jobs"
        //     ];
        //     $.each(av_tasks_tables, function (i, selector) {
        //         if ($.fn.DataTable.isDataTable(selector)) {
        //             $(selector).DataTable().ajax.reload(null, false);
        //         }
        //     });
        // }

        function reload_jobs_tables() {
            $(".table-jobs").DataTable().ajax.reload(null, false);
        }


    </script>
<?php
endif ?>
<script>
    function new_job(url) {
        url = typeof url != "undefined" ? url : admin_url + "trade_job_management/jobs/create";

        var $taskSingleModal = $("#job-modal");
        if ($taskSingleModal.is(":visible")) {
            $taskSingleModal.modal("hide");
        }

        var $taskEditModal = $("#_task_modal");
        if ($taskEditModal.is(":visible")) {
            $taskEditModal.modal("hide");
        }

        requestGet(url)
            .done(function (response) {
                $("#_task").html(response);
                $("body").find("#_task_modal").modal({
                    show: true,
                    backdrop: "static",
                });
            })
            .fail(function (error) {
                alert_float("danger", error.responseText);
            });
    }
</script>
</body>

</html>
