<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php
/** @var array $countries */

/** @var object $job */
/** @var array $property */
$property = $job->property;
/** @var array $landlord */
$landlord = $job->landlord;

?>
<div class="panel_s invoice accounting-template">
    <div class="additional"></div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-6">
                <div class="f_landlord_id">
                    <div class="form-group select-placeholder">
                        <label for="landlord_id"
                               class="control-label"><?= _l('invoice_select_customer'); ?></label>
                        <select class="selectpicker"
                                id="landlord_id"
                                data-actions-box="true"
                                disabled
                                data-width="100%">
                            <option value="<?php echo $landlord['client_id'] ?>"><?php
								echo $landlord['first_name'].' '.$landlord['last_name'] ?></option>
                        </select>
                        <?php echo form_hidden('clientid', $landlord['client_id']) ?>
                    </div>
                </div>

                <div class="form-group" id="invoice_property">
                    <label for="property_id" class="control-label"><?= _l('property'); ?></label>
                    <select class="selectpicker"
                            data-actions-box="true"
                            disabled
                            data-width="100%">
                        <option selected><?php
							echo $property['property_name'] ?></option>
                    </select>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <p class="bold">
							<?= _l('invoice_bill_to'); ?>
                        </p>
                        <div id="billing_details">
							<?php
							echo render_textarea('billing_street', 'billing_street', $landlord['address']); ?>
							<?php
							echo render_textarea('billing_city', 'billing_city', $landlord['city']); ?>
							<?php
							echo render_textarea('billing_state', 'billing_state', $landlord['state']); ?>
							<?php
							echo render_textarea('billing_zip', 'billing_zip', $landlord['zip_code']); ?>
							<?php
							echo render_select('billing_country', $countries, ['country_id', ['short_name']], 'billing_country', $landlord['country']); ?>
                        </div>
                    </div>
                </div>
				<?php
				$next_invoice_number = get_option('next_invoice_number'); ?>
				<?php
				$format = get_option('invoice_number_format'); ?>
				<?php

				if (isset($invoice))
				{
					$format = $invoice->number_format;
				}

				$prefix = get_option('invoice_prefix');

				if ($format == 1)
				{
					$__number = $next_invoice_number;

					if (isset($invoice))
					{
						$__number = $invoice->number;

						$prefix = '<span id="prefix">'.$invoice->prefix.'</span>';
					}
				} elseif ($format == 2)
				{
					if (isset($invoice))
					{
						$__number = $invoice->number;

						$prefix = $invoice->prefix;

						$prefix = '<span id="prefix">'.$prefix.'</span><span id="prefix_year">'.date('Y', strtotime($invoice->date)).'</span>/';
					} else
					{
						$__number = $next_invoice_number;

						$prefix = $prefix.'<span id="prefix_year">'.date('Y').'</span>/';
					}
				} elseif ($format == 3)
				{
					if (isset($invoice))
					{
						$yy = date('y', strtotime($invoice->date));

						$__number = $invoice->number;

						$prefix = '<span id="prefix">'.$invoice->prefix.'</span>';
					} else
					{
						$yy = date('y');

						$__number = $next_invoice_number;
					}
				} elseif ($format == 4)
				{
					if (isset($invoice))
					{
						$yyyy = date('Y', strtotime($invoice->date));

						$mm = date('m', strtotime($invoice->date));

						$__number = $invoice->number;

						$prefix = '<span id="prefix">'.$invoice->prefix.'</span>';
					} else
					{
						$yyyy = date('Y');

						$mm = date('m');

						$__number = $next_invoice_number;
					}
				}

				$_is_draft = isset($invoice) && $invoice->status == Invoices_model::STATUS_DRAFT ? TRUE : FALSE;

				$_invoice_number = str_pad($__number, get_option('number_padding_prefixes'), '0', STR_PAD_LEFT);

				$isedit = isset($invoice) ? 'true' : 'false';

				$data_original_number = isset($invoice) ? $invoice->number : 'false';

				?>
                <div class="form-group">
                    <label for="number">
						<?= _l('invoice_add_edit_number'); ?>
                        <i class="fa-regular fa-circle-question" data-toggle="tooltip"
                           data-title="<?= _l('invoice_number_not_applied_on_draft') ?>"
                           data-placement="top"></i>
                    </label>
                    <div class="input-group">
                        <span class="input-group-addon">
                            <?php
                            if (isset($invoice))
                            { ?>
                                <a href="#" onclick="return false;" data-toggle="popover"
                                   data-container='._transaction_form' data-html="true"
                                   data-content="<label class='control-label'><?= _l('settings_sales_invoice_prefix'); ?></label><div class='input-group'><input name='s_prefix' type='text' class='form-control' value='<?= e(
		                               $invoice->prefix,
	                               ); ?>'></div><button type='button' onclick='save_sales_number_settings(this); return false;' data-url='<?= admin_url(
		                               'invoices/update_number_settings/'

		                               .$invoice->id,
	                               ); ?>' class='btn btn-primary btn-block mtop15'><?= _l('submit'); ?></button>">
                                <i class="fa fa-cog"></i>
                            </a>
	                            <?php
                            } ?>
	                        <?= $prefix; ?>
                        </span>
                        <input type="text" name="number" class="form-control"
                               value="<?= $_is_draft ? 'DRAFT' : $_invoice_number; ?>"
                               data-isedit="<?= e($isedit); ?>"
                               data-original-number="<?= e($data_original_number); ?>"
							<?= $_is_draft ? 'disabled' : '' ?>>
						<?php
						if ($format == 3)
						{ ?>
                            <span class="input-group-addon">
                            <span id="prefix_year"
                                  class="format-n-yy"><?= e($yy); ?></span>
                        </span>
							<?php
						} elseif ($format == 4)
						{ ?>
                            <span class="input-group-addon">
                            <span id="prefix_month"
                                  class="format-mm-yyyy"><?= e($mm); ?></span>
                            /
                            <span id="prefix_year"
                                  class="format-mm-yyyy"><?= e($yyyy); ?></span>
                        </span>
							<?php
						} ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
						<?php
						$value = isset($invoice) ? _d($invoice->date) : _d(date('Y-m-d')); ?>
						<?php
						$date_attrs = isset($invoice) && $invoice->recurring > 0 && $invoice->last_recurring_date != NULL ? ['disabled' => TRUE] : []; ?>
						<?= render_date_input('date', 'invoice_add_edit_date', $value, $date_attrs); ?>
                    </div>
                    <div class="col-md-6">
						<?php
						$value = isset($invoice) ? _d($invoice->duedate) : (get_option('invoice_due_after') != 0 ? _d(date('Y-m-d', strtotime('+'.get_option('invoice_due_after').' DAY'))) : ''); ?>
						<?= render_date_input('duedate', 'invoice_add_edit_duedate', $value); ?>
                    </div>
                </div>
				<?php
				if (is_invoices_overdue_reminders_enabled())
				{ ?>
                    <div class="form-group">
                        <div class="checkbox checkbox-danger">
                            <input type="checkbox"
								<?= isset($invoice) && $invoice->cancel_overdue_reminders == 1 ? 'checked' : ''; ?>
                                   id="cancel_overdue_reminders" name="cancel_overdue_reminders">
                            <label
                                    for="cancel_overdue_reminders"><?= _l('cancel_overdue_reminders_invoice') ?></label>
                        </div>
                    </div>
					<?php
				} ?>
				<?php
				$rel_id = isset($invoice) ? $invoice->id : FALSE; ?>
				<?php
				if (isset($custom_fields_rel_transfer))
				{
					$rel_id = $custom_fields_rel_transfer;
				} ?>
				<?= render_custom_fields('invoice', $rel_id); ?>
            </div>
            <div class="col-md-6">
                <div class="tw-ml-3">
                    <div class="form-group">
                        <label for="tags" class="control-label"><i class="fa fa-tag" aria-hidden="true"></i>
							<?= _l('tags'); ?></label>
                        <input type="text" class="tagsinput" id="tags" name="tags"
                               value="<?= isset($invoice) ? prep_tags_input(get_tags_in($invoice->id, 'invoice')) : ''; ?>"
                               data-role="tagsinput">
                    </div>
                    <div
                            class="form-group mbot15<?= count($payment_modes) > 0 ? ' select-placeholder' : ''; ?>">
                        <label for="allowed_payment_modes"
                               class="control-label"><?= _l('invoice_add_edit_allowed_payment_modes'); ?></label>
                        <br/>
						<?php
						if (count($payment_modes) > 0)
						{ ?>
                            <select class="selectpicker"
                                    data-toggle="<?= $this->input->get('allowed_payment_modes'); ?>"
                                    name="allowed_payment_modes[]"
                                    data-actions-box="true"
                                    multiple="true"
                                    data-width="100%"
                                    data-title="<?= _l('dropdown_non_selected_tex'); ?>">
								<?php
								foreach ($payment_modes as $mode)
								{
									$selected = '';

									if (isset($invoice))
									{
										if ($invoice->allowed_payment_modes)
										{
											$inv_modes = unserialize($invoice->allowed_payment_modes);

											if (is_array($inv_modes))
											{
												foreach ($inv_modes as $_allowed_payment_mode)
												{
													if ($_allowed_payment_mode == $mode['id'])
													{
														$selected = ' selected';
													}
												}
											}
										}
									} else
									{
										if ($mode['selected_by_default'] == 1)
										{
											$selected = ' selected';
										}
									} ?>
                                    <option
                                            value="<?= e($mode['id']); ?>"
										<?= e($selected); ?>>
										<?= e($mode['name']); ?>
                                    </option>
									<?php
								} ?>
                            </select>
							<?php
						} else
						{ ?>
                            <p class="tw-text-neutral-500">
								<?= _l('invoice_add_edit_no_payment_modes_found'); ?>
                            </p>
                            <a class="btn btn-primary btn-sm"
                               href="<?= admin_url('paymentmodes'); ?>">
								<?= _l('new_payment_mode'); ?>
                            </a>
							<?php
						} ?>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
							<?php

							$currency_attr = ['disabled' => TRUE, 'data-show-subtext' => TRUE];

							$currency_attr = apply_filters_deprecated('invoice_currency_disabled', [$currency_attr], '2.3.0', 'invoice_currency_attributes');

							foreach ($currencies as $currency)
							{
								if ($currency['isdefault'] == 1)
								{
									$currency_attr['data-base'] = $currency['id'];
								}

								if (isset($invoice))
								{
									if ($currency['id'] == $invoice->currency)
									{
										$selected = $currency['id'];
									}
								} else
								{
									if ($currency['isdefault'] == 1)
									{
										$selected = $currency['id'];
									}
								}
							}

							$currency_attr = hooks()->apply_filters('invoice_currency_attributes', $currency_attr);

							?>
							<?= render_select('currency', $currencies, ['id', 'name', 'symbol'], 'invoice_add_edit_currency', $selected, $currency_attr); ?>
                        </div>
                        <div class="col-md-6">
							<?php

							$selected = isset($invoice) ? $invoice->sale_agent : (get_option('automatically_set_logged_in_staff_sales_agent') == '1' ? get_staff_user_id() : '');

							foreach ($staff as $member)
							{
								if (isset($invoice) && $invoice->sale_agent == $member['staffid'])
								{
									$selected = $member['staffid'];

									break;
								}
							}

							echo render_select('sale_agent', $staff, ['staffid', ['firstname', 'lastname']], 'sale_agent_string', $selected);

							?>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group select-placeholder"
								<?php
								if (isset($invoice) && ! empty($invoice->is_recurring_from))
								{ ?>
                                    data-toggle="tooltip"
                                    data-title="<?= _l('create_recurring_from_child_error_message', [_l('invoice_lowercase'), _l('invoice_lowercase'), _l('invoice_lowercase')]); ?>"
									<?php
								} ?>>
                                <label for="recurring" class="control-label">
									<?= _l('invoice_add_edit_recurring'); ?>
                                </label>
                                <select class="selectpicker"
                                        data-width="100%"
                                        name="recurring"
                                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>"
									<?php

									// The problem is that this invoice was generated from previous recurring invoice

									// Then this new invoice you set it as recurring but the next invoice date was still taken from the previous invoice.

									if (isset($invoice) && ! empty($invoice->is_recurring_from))
									{
										echo 'disabled';
									} ?>>
									<?php
									for ($i = 0; $i <= 12; $i++)
									{ ?>
										<?php

										$selected = '';

										if (isset($invoice))
										{
											if ($invoice->custom_recurring == 0)
											{
												if ($invoice->recurring == $i)
												{
													$selected = 'selected';
												}
											}
										}

										if ($i == 0)
										{
											$reccuring_string = _l('invoice_add_edit_recurring_no');
										} elseif ($i == 1)
										{
											$reccuring_string = _l('invoice_add_edit_recurring_month', $i);
										} else
										{
											$reccuring_string = _l('invoice_add_edit_recurring_months', $i);
										}

										?>
                                        <option value="<?= e($i); ?>" <?= e($selected); ?>>
											<?= e($reccuring_string); ?>
                                        </option>
										<?php
									} ?>
                                    <option value="custom" <?= isset($invoice) && $invoice->recurring != 0 && $invoice->custom_recurring == 1 ? 'selected' : ''; ?>>
										<?= _l('recurring_custom'); ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group select-placeholder">
                                <label for="discount_type"
                                       class="control-label"><?= _l('discount_type'); ?></label>
                                <select name="discount_type" class="selectpicker" data-width="100%"
                                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
                                    <option value="" selected>
										<?= _l('no_discount'); ?>
                                    </option>
                                    <option value="before_tax" <?= isset($invoice) && $invoice->discount_type == 'before_tax' ? 'selected' : ''; ?>>
										<?= _l('discount_type_before_tax'); ?>
                                    </option>
                                    <option value="after_tax" <?= isset($invoice) && $invoice->discount_type == 'after_tax' ? 'selected' : ''; ?>>
										<?= _l('discount_type_after_tax'); ?>
                                    </option>

                                </select>
                            </div>
                        </div>
                        <div
                                class="recurring_custom<?= isset($invoice) && $invoice->custom_recurring != 1 || ! isset($invoice) ? ' hide' : ''; ?>">
                            <div class="col-md-6">
								<?php
								$value = isset($invoice) && $invoice->custom_recurring == 1 ? $invoice->recurring : 1; ?>
								<?= render_input('repeat_every_custom', '', $value, 'number', ['min' => 1]); ?>
                            </div>
                            <div class="col-md-6">
                                <select name="repeat_type_custom" id="repeat_type_custom" class="selectpicker"
                                        data-width="100%"
                                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
									<?php
									$selectedType = isset($invoice) && $invoice->custom_recurring == 1 ? $invoice->recurring_type : ''; ?>
                                    <option value="day" <?= $selectedType == 'day' ? 'selected' : ''; ?>><?= _l('invoice_recurring_days'); ?>
                                    </option>
                                    <option value="week" <?= $selectedType == 'week' ? 'selected' : ''; ?>><?= _l('invoice_recurring_weeks'); ?>
                                    </option>
                                    <option value="month" <?= $selectedType == 'month' ? 'selected' : ''; ?>><?= _l('invoice_recurring_months'); ?>
                                    </option>
                                    <option value="year" <?= $selectedType == 'year' ? 'selected' : ''; ?>><?= _l('invoice_recurring_years'); ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div id="cycles_wrapper"
                             class="<?= ! isset($invoice) || isset($invoice) && $invoice->recurring == 0 ? 'hide' : ''; ?>">
                            <div class="col-md-12">
								<?php
								$value = isset($invoice) ? $invoice->cycles : 0; ?>
                                <div class="form-group recurring-cycles">
                                    <label
                                            for="cycles"><?= _l('recurring_total_cycles'); ?>
										<?php
										if (isset($invoice) && $invoice->total_cycles > 0)
										{
											echo '<small>'.e(_l('cycles_passed', $invoice->total_cycles)).'</small>';
										} ?>
                                    </label>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
											<?= $value == 0 ? 'disabled' : ''; ?>
                                               name="cycles" id="cycles"
                                               value="<?= e($value); ?>"
											<?php
											if (isset($invoice) && $invoice->total_cycles > 0)
											{
												echo 'min="'.e($invoice->total_cycles).'"';
											} ?>>
                                        <div class="input-group-addon">
                                            <div class="checkbox">
                                                <input type="checkbox"
													<?= $value == 0 ? 'checked' : ''; ?>
                                                       id="unlimited_cycles">
                                                <label
                                                        for="unlimited_cycles"><?= _l('cycles_infinity'); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php
					$value = isset($invoice) ? $invoice->adminnote : ''; ?>
					<?= render_textarea('adminnote', 'invoice_add_edit_admin_note', $value); ?>

                </div>
            </div>
        </div>
    </div>

    <hr class="hr-panel-separator"/>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-12 show_quantity_as_wrapper mbot10">
                <div class="mtop10">
                    <span><?= _l('show_quantity_as'); ?>
                    </span>
                    <div class="radio radio-primary radio-inline">
                        <input type="radio" value="1" id="sq_1" name="show_quantity_as"
                               checked
                               data-text="<?= _l('invoice_table_quantity_heading'); ?>">
                        <label
                                for="sq_1"><?= _l('quantity_as_qty'); ?></label>
                    </div>

                    <div class="radio radio-primary radio-inline">
                        <input type="radio" value="2" id="sq_2" name="show_quantity_as"
                               data-text="<?= _l('invoice_table_hours_heading'); ?>">
                        <label
                                for="sq_2"><?= _l('quantity_as_hours'); ?></label>
                    </div>
                    <div class="radio radio-primary radio-inline">
                        <input type="radio" value="3" id="sq_3" name="show_quantity_as"
                               data-text="<?= _l('invoice_table_quantity_heading'); ?>/<?= _l('invoice_table_hours_heading'); ?>">
                        <label
                                for="sq_3"><?= _l('invoice_table_quantity_heading'); ?>/<?= _l('invoice_table_hours_heading'); ?></label>
                    </div>

                </div>
            </div>
        </div>
		<?php
		echo '<hr class="no-mtop" />'; ?>
        <div class="table-responsive s_table">
            <table class="table invoice-items-table items table-main-invoice-edit has-calculations no-mtop">
                <thead>
                <tr>
                    <th></th>
                    <th width="20%" align="left"><i class="fa-solid fa-circle-exclamation tw-mr-1"
                                                    aria-hidden="true" data-toggle="tooltip"
                                                    data-title="<?= _l('item_description_new_lines_notice'); ?>"></i>
						<?= _l('invoice_table_item_heading'); ?>
                    </th>
                    <th width="25%" align="left">
						<?= _l('invoice_table_item_description'); ?>
                    </th>
					<?php
					$qty_heading = _l('invoice_table_quantity_heading');
					?>
                    <th width="10%" align="right" class="qty">
						<?= e($qty_heading); ?>
                    </th>
                    <th width="15%" align="right">
						<?= _l('invoice_table_rate_heading'); ?>
                    </th>
                    <th width="20%" align="right">
						<?= _l('invoice_table_tax_heading'); ?>
                    </th>
                    <th width="10%" align="right">
						<?= _l('invoice_table_amount_heading'); ?>
                    </th>
                    <th align="center"><i class="fa fa-cog"></i></th>
                </tr>
                </thead>
                <tbody>
                <tr class="main">
                    <td></td>
                    <td>
						<?php
						echo render_textarea('description', '', $job->job_title, ['rows' => 4]) ?>
                    </td>
                    <td>
						<?php
						echo render_textarea('long_description', '', $job->job_description, ['rows' => 4]) ?>
                    </td>
                    <td>
                        <input type="number" name="quantity" min="0" value="1" class="form-control"
                               placeholder="<?= _l('item_quantity_placeholder'); ?>">
                        <input type="text"
                               placeholder="<?= _l('unit'); ?>"
                               data-toggle="tooltip" data-title="e.q kg, lots, packs" name="unit"
                               class="form-control input-transparent text-right">
                    </td>
                    <td>
                        <input type="number" name="rate" class="form-control"
                               placeholder="<?= _l('item_rate_placeholder'); ?>">
                    </td>
                    <td>
						<?php

						$default_tax = unserialize(get_option('default_tax'));

						$select = '<select class="selectpicker display-block tax main-tax" data-width="100%" name="taxname" multiple data-none-selected-text="'._l('no_tax').'">';

						//  $select .= '<option value=""'.(count($default_tax) == 0 ? ' selected' : '').'>'._l('no_tax').'</option>';

						foreach ($taxes as $tax)
						{
							$selected = '';

							if (is_array($default_tax))
							{
								if (in_array($tax['name'].'|'.$tax['taxrate'], $default_tax))
								{
									$selected = ' selected ';
								}
							}

							$select .= '<option value="'.$tax['name'].'|'.$tax['taxrate'].'"'.$selected.'data-taxrate="'.$tax['taxrate'].'" data-taxname="'.$tax['name'].'" data-subtext="'.$tax['name'].'">'.$tax['taxrate'].'%</option>';
						}

						$select .= '</select>';

						echo $select;

						?>
                    </td>
                    <td></td>
                    <td>
						<?php
						$new_item = ! isset($invoice) ? 'undefined' : TRUE; ?>
                        <button type="button"
                                onclick="add_item_to_table('undefined','undefined',<?= e($new_item); ?>); return false;"
                                class="btn pull-right btn-primary"><i class="fa fa-check"></i></button>
                    </td>
                </tr>

                </tbody>
            </table>
        </div>
        <div class="col-md-8 col-md-offset-4">
            <table class="table text-right">
                <tbody>
                <tr id="subtotal">
                    <td>
                            <span
                                    class="bold tw-text-neutral-700"><?= _l('invoice_subtotal'); ?>
                                :</span>
                    </td>
                    <td class="subtotal">
                    </td>
                </tr>
                <tr id="discount_area">
                    <td>
                        <div class="row">
                            <div class="col-md-7">
                                    <span class="bold tw-text-neutral-700">
                                        <?= _l('invoice_discount'); ?>
                                    </span>
                            </div>
                            <div class="col-md-5">
                                <div class="input-group" id="discount-total">

                                    <input type="number"
                                           value="0"
                                           class="form-control pull-left input-discount-percent<?= isset($invoice) && ! is_sale_discount($invoice, 'percent') && is_sale_discount_applied($invoice) ? ' hide' : ''; ?>"
                                           min="0" max="100" name="discount_percent">

                                    <input type="number" data-toggle="tooltip"
                                           data-title="<?= _l('numbers_not_formatted_while_editing'); ?>"
                                           value="0"
                                           class="form-control pull-left input-discount-fixed<?= ! isset($invoice) || isset($invoice) && ! is_sale_discount($invoice, 'fixed') ? ' hide' : ''; ?>"
                                           min="0" name="discount_total">

                                    <div class="input-group-addon">
                                        <div class="dropdown">
                                            <a class="dropdown-toggle" href="#" id="dropdown_menu_tax_total_type"
                                               data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                <span class="discount-total-type-selected">%</span>
                                                <span class="caret"></span>
                                            </a>
                                            <ul class="dropdown-menu" id="discount-total-type-dropdown"
                                                aria-labelledby="dropdown_menu_tax_total_type">
                                                <li>
                                                    <a href="#"
                                                       class="discount-total-type discount-type-percent selected'">%</a>
                                                </li>
                                                <li>
                                                    <a href="#"
                                                       class="discount-total-type discount-type-fixed">
														<?= _l('discount_fixed_amount'); ?>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="discount-total"></td>
                </tr>
                <tr>
                    <td>
                        <div class="row">
                            <div class="col-md-7">
                                    <span
                                            class="bold tw-text-neutral-700"><?= _l('invoice_adjustment'); ?></span>
                            </div>
                            <div class="col-md-5">
                                <input type="number" data-toggle="tooltip"
                                       data-title="<?= _l('numbers_not_formatted_while_editing'); ?>"
                                       value="0"
                                       class="form-control pull-left" name="adjustment">
                            </div>
                        </div>
                    </td>
                    <td class="adjustment"></td>
                </tr>
                <tr>
                    <td><span
                                class="bold tw-text-neutral-700"><?= _l('invoice_total'); ?>
                                :</span>
                    </td>
                    <td class="total">
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <div id="removed-items"></div>
        <div id="billed-tasks"></div>
        <div id="billed-expenses"></div>
    </div>

    <hr class="hr-panel-separator"/>

    <div class="panel-body">
		<?= render_textarea('clientnote', 'invoice_add_edit_client_note', get_option('predefined_clientnote_invoice')); ?>
		<?= render_textarea('terms', 'terms_and_conditions', get_option('predefined_terms_invoice'), [], [], 'mtop15'); ?>
    </div>
</div>

<div class="btn-bottom-pusher"></div>
<div class="btn-bottom-toolbar text-right">
    <div class="btn-group dropup">
        <button type="button"
                class="btn-tr btn btn-primary invoice-form-submit transaction-submit"><?= _l('submit'); ?></button>
        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true"
                aria-expanded="false">
            <span class="caret"></span>
        </button>
        <ul class="dropdown-menu dropdown-menu-right width200">
            <li>
                <a href="#" class="invoice-form-submit save-and-send transaction-submit">
					<?= _l('save_and_send'); ?>
                </a>
            </li>
        </ul>
    </div>
</div>
