<?php

defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
/** @var string $title */

/** @var array $members */
/** @var array $job_priorities */

echo
form_open_multipart(admin_url('trade_job_management/jobs/create'), ['id' => 'job-form']); ?>
<div class="modal fade create" id="_task_modal" tabindex="-1" role="dialog"
     aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
					<?php
					echo e($title); ?>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
						<?php
						$rel_id   = $id ?? '';
						$rel_type = 'property';
						if (empty($rel_id) && (isset($job) || $this->input->get('rel_id') && $this->input->get('rel_type')))
						{
							$rel_id = isset($job) ? $job->rel_id : $this->input->get('rel_id');
						} ?>
                        <a href="#" class="pull-right tw-pt-2"
                           onclick="slideToggle('#new-task-attachments'); return false;">
							<?php
							echo _l('attach_files'); ?>
                        </a>
                        <div id="new-task-attachments" class="hide">
                            <div class="row attachments">
                                <div class="attachment">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="attachment"
                                                   class="control-label"><?php
												echo _l('add_task_attachments'); ?></label>
                                            <div class="input-group">
                                                <input type="file"
                                                       extension="<?php
												       echo str_replace('.', '', get_option('allowed_files')); ?>"
                                                       filesize="<?php
												       echo file_upload_max_size(); ?>"
                                                       class="form-control" name="attachments[0]">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default add_more_attachments"
                                                            type="button"><i class="fa fa-plus"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr/>
                        </div>
                        <p class="bold"><?php
							echo _l('job_type'); ?></p>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="job_type"
                                           class="control-label"><?php
										echo _l('job_type'); ?></label>
                                    <select required name="job_type_id" class="selectpicker" id="job_type"
                                            data-width="100%"
                                            data-none-selected-text="<?php
									        echo _l('dropdown_non_selected_tex'); ?>">
										<?php
										foreach ($job_types as $type)
										{ ?>
                                            <option value="<?php
											echo e($type['jobtypeid']); ?>"><?php
												echo e($type['type_name']); ?></option>
											<?php
										} ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="priority"
                                           class="control-label"><?php
										echo _l('task_add_edit_priority'); ?></label>
                                    <select name="priority" class="selectpicker" id="priority" data-width="100%"
                                            data-none-selected-text="<?php
									        echo _l('dropdown_non_selected_tex'); ?>">
										<?php
										foreach ($job_priorities as $priority)
										{ ?>
                                            <option value="<?php
											echo e($priority['id']); ?>"><?php
												echo e($priority['name']); ?></option>
											<?php
										} ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <hr/>
                        <p class="bold"><?php
							echo _l('job_details'); ?></p>
						<?php
						echo render_input('job_title', 'job', ''); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row hidden">
                                    <div class="form-group">
                                        <label for="rel_type"
                                               class="control-label"><?php
											echo _l('task_related_to'); ?></label>
                                        <select name="rel_type" class="selectpicker" id="rel_type" data-width="100%"
                                                data-none-selected-text="<?php
										        echo _l('dropdown_non_selected_tex'); ?>">
                                            <option value=""></option>
                                            <option value="property" selected><?php
												echo _l('property'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group" id="rel_id_wrapper">
                                    <label for="rel_id" class="control-label"><?php
										echo _l('property') ?></label>
                                    <div id="rel_id_select">
                                        <select name="property_id" id="rel_id"
                                                class="ajax-sesarch" data-width="100%"
                                                data-live-search="true"
                                                data-none-selected-text="<?php
										        echo _l('dropdown_non_selected_tex'); ?>"><?php
											if ($rel_id != '' && $rel_type != '')
											{
												$rel_data = get_relation_data('property', $rel_id);
												$rel_val  = get_relation_values($rel_data, 'property');
												echo '<option data-property_address="'.$rel_data->property_address.'"  data-property_type="'.$rel_data->property_type->type_name.'"  value="'.$rel_val['id'].'"  selected>'.$rel_val['name']
												     .'</option>';
											} ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
								<?php
								echo render_date_input('preferred_visit_date', 'job_date_visit'); ?>
                            </div>
                        </div>
						<?php
						if (isset($rel_data) || isset($rel_val)): ?>
							<?php
							$property_address = $rel_data->property_address;
							$property_type    = $rel_data->property_type_data->type_name; ?>
                            <div class="row">
                                <div class="col-md-12">
									<?php
									echo

									render_input('property_address', 'property_address', $property_address, 'text', ['disabled' => TRUE, 'readonly' => TRUE]); ?>
                                </div>
                                <div class="col-md-6">
									<?php
									echo

									render_input('job_property_type', 'job_property_type', $property_type, 'text', ['disabled' => TRUE, 'readonly' => TRUE]); ?>
                                </div>
                            </div>
						<?php
						else: ?>
							<?php
							echo render_input('property_address', 'property_address', 'Property Address', 'text', ['disabled' => TRUE, 'readonly' => TRUE]); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="job_property_type"
                                               class="control-label"><?php
											echo _l('job_property_type'); ?></label>
                                        <select disabled readonly name="job_property_type" class="selectpicker"
                                                id="job_property_type" data-width="100%"
                                                data-none-selected-text="<?php
										        echo _l('dropdown_non_selected_tex'); ?>">
                                            <option disabled selected><?php
												echo _l('dropdown_non_selected_tex'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="nte"><?= _l('job_nte'); ?></label>
                                        <div class="input-group">
                                            <input type="number" name="nte"
                                                   value="0"
                                                   min="0.00"
                                                   id="nte" class="form-control">
                                            <span class="input-group-addon"><?= e(get_base_currency()->symbol); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
						<?php
						endif ?>
                        <hr/>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="bold"><?php
									echo _l('landlord_person_details'); ?></p>
								<?php
								echo render_input('contact_name', 'contact_name', ''); ?>
								<?php
								echo render_input('contact_phone', 'contact_phone', '', 'tel'); ?>
                            </div>
                            <div class="col-md-6">
                                <p class="bold"><?php
									echo _l('engineer_details'); ?></p>
                                <div class="form-group select-placeholder">
									<?php
									echo render_select('specialists[]', $members, ['staffid', ['firstname', 'lastname']], 'engineer_selection', [], ['multiple' => TRUE, 'data-actions-box' => TRUE], [], '', '', FALSE); ?>
                                </div>
                            </div>
                        </div>
                        <hr/>
                        <p class="bold"><?php
							echo _l('job_description'); ?></p>
						<?php
						echo
						render_textarea(
							'job_description',
							'',
							'',
							[
								'rows'                                => 6,
								'placeholder'                         => _l('task_add_description'),
								'data-task-ae-editor'                 => TRUE,
								! is_mobile() ? 'onclick' : 'onfocus' => 'init_job_description_editor(\'.tinymce-task\');',
							],
							[],
							'no-mbot',
							'tinymce-task',
						); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php
					echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php
					echo _l('submit'); ?></button>
            </div>
        </div>
    </div>
	<?php
	echo form_close(); ?>
    <script>
        var _rel_id = $('#rel_id'),
            _rel_type = $('#rel_type'),
            _rel_id_wrapper = $('#rel_id_wrapper'),
            _current_member = undefined,
            data = {};        <?php if (get_option('new_task_auto_assign_current_member') == '1') { ?>
        _current_member = "<?php echo get_staff_user_id(); ?>";
		<?php } ?>
        $(function () {
            $("body").off("change", "#rel_id");
            var inner_popover_template =
                '<div class="popover"><div class="arrow"></div><div class="popover-inner"><h3 class="popover-title"></h3><div class="popover-content"></div></div></div>';
            $('#_task_modal .task-menu-options .trigger').popover({
                html: true,
                placement: "bottom",
                trigger: 'click',
                title: "<?php echo _l('actions'); ?>",
                content: function () {
                    return $('body').find('#_task_modal .task-menu-options .content-menu').html();
                },
                template: inner_popover_template
            });
            custom_fields_hyperlink();
            appValidateForm($('#job-form'), {
                job_title: 'required',
                preferred_visit_date: 'required',
                rel_id: 'required',
                property_id: 'required',
                job_type_id: 'required',
                priority: 'required',
                contact_name: 'required',
                contact_phone: 'required',
                'specialists[]': 'required'
            }, job_form_handler);
            $('.rel_id_label').html(_rel_type.find('option:selected').text());
            _rel_type.on('change', function () {
                var clonedSelect = _rel_id.html('').clone();
                _rel_id.selectpicker('destroy').remove();
                _rel_id = clonedSelect;
                $('#rel_id_select').append(clonedSelect);
                // $('.rel_id_label').html(_rel_type.find('option:selected').text());                task_rel_select();
                if ($(this).val() != '') {
                    _rel_id_wrapper.removeClass('hide');
                } else {
                    _rel_id_wrapper.addClass('hide');
                }
                init_property_details(_rel_type.val());
            });
            init_datepicker();
            init_color_pickers();
            init_selectpicker();
            task_rel_select();
            var _allAssigneeSelect = $("#assignees").html();
            $('body').on('change', '#rel_id', function () {
                console.log(_rel_type.val());
                $.get(admin_url + 'trade_job_management/properties/get_rel_property_data/' + $(this).val(),
                    function (property) {
                        let selected_property = $(_rel_id).find(':selected');
                        set_property_address($(selected_property).data('property_address'))
                        set_property_type($(selected_property).data('property_type'))
                    }, 'json');
            });            <?php if (! isset($job) && $rel_id != '') { ?>
            _rel_id.change();
			<?php } ?>            _rel_type.on('changed.bs.select', function (e, clickedIndex, isSelected, previousValue) {
                if (previousValue == 'property') {
                    $("#assignees").html(_allAssigneeSelect);
                    if (typeof (_current_member) != 'undefined') {
                        $("#assignees").val(_current_member);
                    }
                    $("#assignees").selectpicker('refresh')
                }
            });
        });

        function set_property_address(address = '') {
            if (address.length) {
                $('#property_address').val(address)
            } else {
                $('#property_address').val('Property Address')
            }
        }

        function set_property_type(type = '') {
            if (type.length) {
                $('#job_property_type').html('<option disabled selected>' + type + '</option>')
                $('#job_property_type').closest('.form-group').find('.filter-option-inner-inner').html(type)
            } else {
                $('#job_property_type').html('<option disabled selected><?php echo _l('dropdown_non_selected_tex'); ?></option>')
                $('#job_property_type').closest('.form-group').find('.filter-option-inner-inner').html('<?php echo _l('dropdown_non_selected_tex'); ?>')
            }
        }

        function task_rel_select() {
            var serverData = {};
            serverData.rel_id = _rel_id.val();
            data.type = _rel_type.val();
            init_properties_ajax_search(_rel_type.val(), _rel_id, serverData);
        }

        function init_property_details(type, tasks_visible_to_customer) {
            var wrap = $('.non-property-details');
            var wrap_task_hours = $('.task-hours');
            if (type == 'property') {
                if (wrap_task_hours.hasClass('property-task-hours') == true) {
                    wrap_task_hours.removeClass('hide');
                } else {
                    wrap_task_hours.addClass('hide');
                }
                wrap.addClass('hide');
                $('.property-details').removeClass('hide');
            } else {
                wrap_task_hours.removeClass('hide');
                wrap.removeClass('hide');
                $('.property-details').addClass('hide');
                $('.task-visible-to-customer').addClass('hide').prop('checked', false);
            }
            if (typeof (tasks_visible_to_customer) != 'undefined') {
                if (tasks_visible_to_customer == 1) {
                    $('.task-visible-to-customer').removeClass('hide');
                    $('.task-visible-to-customer input').prop('checked', true);
                } else {
                    $('.task-visible-to-customer').addClass('hide')
                    $('.task-visible-to-customer input').prop('checked', false);
                }
            }
        }

        function reset_task_duedate_input() {
            var $duedate = $('#_task_modal #duedate');
            $duedate.removeAttr('data-date-end-date');
            $duedate.datetimepicker('destroy');
            init_datepicker($duedate);
        }        // Handles job add/edit form modal.
        function job_form_handler(form) {
            tinymce.triggerSave();
            $("#_task_modal").find('input[name="startdate"]').prop("disabled", false);
            // Disable the save button in cases od duplicate clicks
            $("#_task_modal").find('button[type="submit"]').prop("disabled", true);
            $("#_task_modal input[type=file]").each(function () {
                if ($(this).val() === "") {
                    $(this).prop("disabled", true);
                }
            });
            var formURL = form.action;
            var formData = new FormData($(form)[0]);
            console.log(form);
            console.log(formData);
            $.ajax({
                type: $(form).attr("method"),
                data: formData,
                mimeType: $(form).attr("enctype"),
                contentType: false,
                cache: false,
                processData: false,
                url: formURL,
            })
                .done(function (response) {
                    response = JSON.parse(response);
                    if (response.success === true || response.success == "true") {
                        alert_float("success", response.message);
                    }
                    if (window._timer_id) {
                        requestGet(admin_url + "/trade_job_management/jobs/get_task_by_id/" + response.id).done(
                            function (response) {
                                $('[data-timer-id="' + window._timer_id + '"').click();
                                response = JSON.parse(response);
                                var option =
                                    '<option value="' +
                                    response.id +
                                    '" title="' +
                                    response.name +
                                    '" selected>' +
                                    response.name +
                                    "</option>";
                                $("#timer_add_task_id").append(option);
                                $("#timer_add_task_id")
                                    .trigger("change")
                                    .data("AjaxBootstrapSelect").list.cache = {};
                                $("#timer_add_task_id").selectpicker("refresh");
                                delete window._timer_id;
                            }
                        );
                        $("#_task_modal").modal("hide");
                        $("#task-modal").modal("hide");
                        return false;
                    }
                    if (!$("body").hasClass("property")) {
                        $("#_task_modal").attr("data-task-created", true);
                        $("#_task_modal").modal("hide");
                        init_job_modal(response.id);
                        reload_jobs_tables();
                    } else {
                        // reload page on property area
                        var location = window.location.href;
                        var params = [];
                        location = location.split("?");
                        var group = get_url_param("group");
                        var excludeCompletedTasks = get_url_param("exclude_completed");
                        if (group) {
                            params["group"] = group;
                        }
                        if (excludeCompletedTasks) {
                            params["exclude_completed"] = excludeCompletedTasks;
                        }
                        params["taskid"] = response.id;
                        window.location.href = buildUrl(location[0], params);
                    }
                })
                .fail(function (error) {
                    alert_float("danger", JSON.parse(error.responseText));
                });
            return false;
        }

        function init_properties_ajax_search(type, selector, server_data, url) {
            console.log('here')
            var ajaxSelector = $("body").find(selector);
            if (ajaxSelector.length) {
                var options = {
                    ajax: {
                        url:
                            typeof url == "undefined"
                                ? admin_url + "misc/get_relation_data"
                                : url,
                        data: function () {
                            var data = {};
                            data.type = type;
                            data.rel_id = "";
                            data.q = "{{{q}}}";
                            if (typeof server_data != "undefined") {
                                jQuery.extend(data, server_data);
                            }
                            return data;
                        },
                    },
                    locale: {
                        emptyTitle: app.lang.search_ajax_empty,
                        statusInitialized: app.lang.search_ajax_initialized,
                        statusSearching: app.lang.search_ajax_searching,
                        statusNoResults: app.lang.not_results_found,
                        searchPlaceholder: app.lang.search_ajax_placeholder,
                        currentlySelected: app.lang.currently_selected,
                    },
                    requestDelay: 500,
                    cache: false,
                    preprocessData: function (processData) {
                        var bs_data = [];
                        var len = processData.length;
                        for (var i = 0; i < len; i++) {
                            var tmp_data = {
                                value: processData[i].id,
                                text: processData[i].name,
                                data: {
                                    property_address: processData[i].relation.property_address,
                                    property_type: processData[i].relation.type_name
                                }
                            };
                            if (processData[i].subtext) {
                                tmp_data.data = {
                                    subtext: processData[i].subtext,
                                };
                            }
                            bs_data.push(tmp_data);
                        }
                        return bs_data;
                    },
                    preserveSelectedPosition: "after",
                    preserveSelected: true,
                };
                if (ajaxSelector.data("empty-title")) {
                    options.locale.emptyTitle = ajaxSelector.data("empty-title");
                }
                ajaxSelector.selectpicker().ajaxSelectPicker(options);
            }
        }

        function init_job_description_editor(className) {
            if (tinymce.get('job_description')) {
                tinymce.remove("#job_description");
            }

            var editorConfig = _simple_editor_config();

            editorConfig.toolbar_sticky = true
            editorConfig.auto_focus = true;
            editorConfig.content_style =
                "span.mention {\
				background-color: #eeeeee;\
				padding: 3px;\
			}";
            editorConfig.content_style =
                "span.mention {\
					background-color: #eeeeee;\
					padding: 3px;\
				}\
				img {\
					width: 90%;\
					max-width: 90%;\
					padding: 0 5%;\
				}";

            init_editor("#job_description", editorConfig)
        }

    </script>
