<!--Common script for company address, billing and shipping address-->
<script>
    function setBuilding(address,elm_id)
    {
        var buildingShort = '';

        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("premise") != -1)
            {
                buildingShort = buildingShort.concat(address[p].long_name);
            }
        }
        if(buildingShort == ''){
            buildingShort = buildingShort.concat(address[0].long_name);
        }
        $(elm_id).val(buildingShort);
    }

    function setPostalCode(address,elm_id)
    {
        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("postal_code") != -1)
            {
                $(elm_id).val(address[p].long_name);
            }
        }
    }

    function setState(address,elm_id)
    {
        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("administrative_area_level_1") != -1)
            {
                $(elm_id).val(address[p].long_name);
            }
        }
    }

    function setCity(address,elm_id)
    {
        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("locality") != -1)
            {
                $(elm_id).val(address[p].long_name);
            }
        }
    }

    function setArea(address,elm_id)
    {
        var areaShort = '';

        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("route") != -1)
            {
                areaShort = areaShort.concat(address[p].long_name);
            }
        }

        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("sublocality") != -1)
            {
                if(areaShort != '')
                {
                    areaShort = areaShort.concat(',');
                }

                areaShort = areaShort.concat(' ' + address[p].long_name);
            }
        }

        var building_add = $(elm_id).val();
        if(areaShort != '')
        {
            building_add = building_add.concat(',');
            building_add = building_add.concat(' ' + areaShort);
        }
        $(elm_id).val(building_add);
    }

    function setCountry(address,elm_id)
    {
        for (p = address.length-1; p >= 0; p--)
        {
            if (address[p].types.indexOf("country") != -1)
            {
                var country_name = address[p].long_name;
                $('select[name="'+elm_id+'"] option').filter(function() {
                    return $(this).text() === country_name;
                }).prop('selected', true);
            }
        }
        $('#'+elm_id).change();
    }
</script>