<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Module Name: Google Geo
 * Description: Google Maps Autocomplete Address.
 * Version: 1.0.0
 * Requires at least: 3.1.0
 * Author: CodeOnString
 * Author URI: https://codecanyon.net/user/codeonstring
 */

require_once __DIR__ .'/vendor/autoload.php';

define('GOOGLE_GEO_MODULE_NAME', 'google_geo');
define('GOOGLE_GEO_MODULE_PATH', module_dir_path(GOOGLE_GEO_MODULE_NAME));
define('GOOGLE_GEO_DB_NAME', db_prefix() . 'google_geo');

hooks()->add_action('admin_init', 'google_geo_module_init');
// quick action link hook
hooks()->add_filter('module_google_geo_action_links', 'module_google_geo_action_links');
// admin hook
hooks()->add_action('app_admin_head','google_geo_app_admin_head');
hooks()->add_action('app_admin_footer','google_geo_admin_footer');
// client create hook
hooks()->add_action('before_client_updated','google_geo_before_client_updated');
hooks()->add_action('client_updated','google_geo_after_client_updated');
// client edit hook
hooks()->add_action('before_client_added','google_geo_before_client_created');
hooks()->add_action('after_client_created','google_geo_after_client_created');
// client delete hook
hooks()->add_action('after_client_deleted','google_geo_after_client_deleted');
// invoice create hook
hooks()->add_action('before_invoice_added','google_geo_before_invoice_added');
hooks()->add_action('after_invoice_added','google_geo_after_invoice_added');
// invoice update hook
hooks()->add_action('before_update_invoice','google_geo_before_invoice_updated');
hooks()->add_action('invoice_updated','google_geo_after_invoice_updated');
// invoice delete hook
hooks()->add_action('after_invoice_deleted','google_geo_after_invoice_deleted');
// lead create hook
hooks()->add_action('before_lead_added','google_geo_before_lead_added');
hooks()->add_action('lead_created','google_geo_after_lead_added');
hooks()->add_action('after_lead_updated','google_geo_after_lead_updated');
// lead delete hook
hooks()->add_action('after_lead_deleted','google_geo_after_lead_deleted');
// proposal create hook
hooks()->add_action('before_create_proposal','google_geo_before_proposal_added');
hooks()->add_action('proposal_created','google_geo_after_proposal_added');
// proposal update hook
hooks()->add_action('before_proposal_updated','google_geo_before_proposal_updated');
hooks()->add_action('after_proposal_updated','google_geo_after_proposal_updated');
// proposal delete hook
hooks()->add_action('after_proposal_deleted','google_geo_after_proposal_deleted');
// estimate create hook
hooks()->add_action('before_estimate_added','google_geo_before_estimate_added');
hooks()->add_action('after_estimate_added','google_geo_after_estimate_added');
// estimate update hook
hooks()->add_action('before_estimate_updated','google_geo_before_estimate_updated');
hooks()->add_action('after_estimate_updated','google_geo_after_estimate_updated');
// estimate delete hook
hooks()->add_action('after_estimate_deleted','google_geo_after_estimate_deleted');

function google_geo_module_init()
{
    $CI = &get_instance();

    // add settings section
    $CI->app->add_settings_section_child(
            'configuration',
            'google_geo',
            [
                'name'     => _l('google_geo'),
                'view'     => 'google_geo/settings',
                'position' => 40,
                'icon'     => 'fa-solid fa-map-marker-alt',
            ]
    );

    register_activation_hook(GOOGLE_GEO_MODULE_NAME, 'google_geo_install');
    register_uninstall_hook(GOOGLE_GEO_MODULE_NAME, 'google_geo_uninstall');
}

function module_google_geo_action_links($actions)
{
    if (get_instance()->app_modules->is_active('google_geo'))
    {
        $actions[] = '<a href="' . admin_url('settings?group=google_geo') . '">' . _l('settings') . '</a>';
    }

    return $actions;
}

function google_geo_app_admin_head()
{
    ?>
    <style>
        .pac-container {
            z-index: 99999 !important;
        }
    </style>
    <?php
}

function google_geo_get_last_segment_id()
{
    $url_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $segments = explode('/', trim($url_path, '/'));
    $last = end($segments);

    return (is_numeric($last)) ? (int) $last : null;
}

function google_geo_admin_footer()
{
    $current_url = $_SERVER['REQUEST_URI'];
    // client / company
    if(preg_match('/clients\/client/', $current_url))
    {
        if ((int)get_option('google_geo_company') == 1 || (int)get_option('google_geo_company_shipping_billing') == 1 && !empty(get_option('google_geo_key')))
        {
            $google_map_key = get_option('google_geo_key');
            ?>
            <script src="https://maps.googleapis.com/maps/api/js?key=<?= $google_map_key ?>&libraries=places&callback=initAutocomplete" async defer></script>
            <?php
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/company.php');
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/common.php');

            $existing_id = google_geo_get_last_segment_id();

            if(!empty($existing_id))
            {
                $CI =& get_instance();
                $CI->load->model('invoices_model');
                $clientRow = $CI->clients_model->get($existing_id);

                $googleGeoCompanyData = [
                    'user_id' => $clientRow->userid,
                    'user_type' => 'client',
                    'module_id' => $clientRow->userid,
                    'module_name' => 'company',
                ];

                $CI->load->model('google_geo/google_geo_model');

                // update company input field
                $googleGeoCompanyRow = $CI->google_geo_model->get($googleGeoCompanyData);

                if($googleGeoCompanyRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#latitude').length)
                            {
                                $('#latitude').val('<?= $googleGeoCompanyRow->latitude ?>');
                            }

                            if ($('#longitude').length)
                            {
                                $('#longitude').val('<?= $googleGeoCompanyRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }

                // update billing input field
                $googleGeoBillingData = [
                    'user_id' => $clientRow->userid,
                    'user_type' => 'client',
                    'module_id' => $clientRow->userid,
                    'module_name' => 'company_billing',
                ];

                $googleGeoBillingRow = $CI->google_geo_model->get($googleGeoBillingData);

                if($googleGeoBillingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#billing_latitude').length)
                            {
                                $('#billing_latitude').val('<?= $googleGeoBillingRow->latitude ?>');
                            }

                            if ($('#billing_longitude').length)
                            {
                                $('#billing_longitude').val('<?= $googleGeoBillingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }

                // update shipping input field
                $googleGeoShippingData = [
                    'user_id' => $clientRow->userid,
                    'user_type' => 'client',
                    'module_id' => $clientRow->userid,
                    'module_name' => 'company_shipping',
                ];

                $googleGeoShippingRow = $CI->google_geo_model->get($googleGeoShippingData);

                if($googleGeoShippingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#shipping_latitude').length)
                            {
                                $('#shipping_latitude').val('<?= $googleGeoShippingRow->latitude ?>');
                            }

                            if ($('#shipping_longitude').length)
                            {
                                $('#shipping_longitude').val('<?= $googleGeoShippingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }
            }
        }
    }
    // invoice
    if(preg_match('/invoices\/invoice/', $current_url))
    {
        if ((int)get_option('google_geo_invoice') == 1 && !empty(get_option('google_geo_key')))
        {
            $google_map_key = get_option('google_geo_key');
            ?>
            <script src="https://maps.googleapis.com/maps/api/js?key=<?= $google_map_key ?>&libraries=places&callback=initAutocomplete" async defer></script>
            <?php
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/invoice.php');
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/common.php');

            $existing_id = google_geo_get_last_segment_id();

            if(!empty($existing_id))
            {
                $CI =& get_instance();
                $CI->load->model('invoices_model');
                $InvoiceRow = $CI->invoices_model->get($existing_id);

                $CI->load->model('google_geo/google_geo_model');

                // update billing input field
                $googleGeoBillingData = [
                    'user_id' => $InvoiceRow->clientid,
                    'user_type' => 'client',
                    'module_id' => $InvoiceRow->id,
                    'module_name' => 'invoice_billing',
                ];

                $googleGeoBillingRow = $CI->google_geo_model->get($googleGeoBillingData);

                if($googleGeoBillingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#billing_latitude').length)
                            {
                                $('#billing_latitude').val('<?= $googleGeoBillingRow->latitude ?>');
                            }

                            if ($('#billing_longitude').length)
                            {
                                $('#billing_longitude').val('<?= $googleGeoBillingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }

                // update shipping input field
                $googleGeoShippingData = [
                    'user_id' => $InvoiceRow->clientid,
                    'user_type' => 'client',
                    'module_id' => $InvoiceRow->id,
                    'module_name' => 'invoice_shipping',
                ];

                $googleGeoShippingRow = $CI->google_geo_model->get($googleGeoShippingData);

                if($googleGeoShippingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#shipping_latitude').length)
                            {
                                $('#shipping_latitude').val('<?= $googleGeoShippingRow->latitude ?>');
                            }

                            if ($('#shipping_longitude').length)
                            {
                                $('#shipping_longitude').val('<?= $googleGeoShippingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }
            }
        }
    }
    // leads
    if(preg_match('/leads/', $current_url))
    {
        if ((int)get_option('google_geo_lead') == 1 && !empty(get_option('google_geo_key')))
        {
            $google_map_key = get_option('google_geo_key');
            ?>
            <script src="https://maps.googleapis.com/maps/api/js?key=<?= $google_map_key ?>&libraries=places&callback=initAutocomplete" async defer></script>
            <?php
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/lead.php');
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/common.php');

            $existing_id = google_geo_get_last_segment_id();

            if(!empty($existing_id))
            {
                $CI =& get_instance();
                $CI->load->model('invoices_model');
                $clientRow = $CI->clients_model->get($existing_id);

                $googleGeoCompanyData = [
                    'user_id' => $clientRow->userid,
                    'user_type' => 'client',
                    'module_id' => $clientRow->userid,
                    'module_name' => 'company',
                ];

                $CI->load->model('google_geo/google_geo_model');

                // update company input field
                $googleGeoCompanyRow = $CI->google_geo_model->get($googleGeoCompanyData);

                if($googleGeoCompanyRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#latitude').length)
                            {
                                $('#latitude').val('<?= $googleGeoCompanyRow->latitude ?>');
                            }

                            if ($('#longitude').length)
                            {
                                $('#longitude').val('<?= $googleGeoCompanyRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }

                // update billing input field
                $googleGeoBillingData = [
                        'user_id' => $clientRow->userid,
                        'user_type' => 'client',
                        'module_id' => $clientRow->userid,
                        'module_name' => 'company_billing',
                ];

                $googleGeoBillingRow = $CI->google_geo_model->get($googleGeoBillingData);

                if($googleGeoBillingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#billing_latitude').length)
                            {
                                $('#billing_latitude').val('<?= $googleGeoBillingRow->latitude ?>');
                            }

                            if ($('#billing_longitude').length)
                            {
                                $('#billing_longitude').val('<?= $googleGeoBillingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }

                // update shipping input field
                $googleGeoShippingData = [
                        'user_id' => $clientRow->userid,
                        'user_type' => 'client',
                        'module_id' => $clientRow->userid,
                        'module_name' => 'company_shipping',
                ];

                $googleGeoShippingRow = $CI->google_geo_model->get($googleGeoShippingData);

                if($googleGeoShippingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#shipping_latitude').length)
                            {
                                $('#shipping_latitude').val('<?= $googleGeoShippingRow->latitude ?>');
                            }

                            if ($('#shipping_longitude').length)
                            {
                                $('#shipping_longitude').val('<?= $googleGeoShippingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }
            }
        }
    }
    // proposal
    if(preg_match('/proposals\/proposal/', $current_url))
    {
        if ((int)get_option('google_geo_proposal') == 1 && !empty(get_option('google_geo_key')))
        {
            $google_map_key = get_option('google_geo_key');
            ?>
            <script src="https://maps.googleapis.com/maps/api/js?key=<?= $google_map_key ?>&libraries=places&callback=initAutocomplete" async defer></script>
            <?php
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/proposal.php');
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/common.php');

            $existing_id = google_geo_get_last_segment_id();

            if(!empty($existing_id))
            {
                $CI =& get_instance();
                $CI->load->model('proposals_model');
                $proposalRow = $CI->proposals_model->get($existing_id);

                $googleGeoDbData = [
                    'user_id' => $proposalRow->assigned,
                    'user_type' => 'staff',
                    'module_id' => $existing_id,
                    'module_name' => 'proposal',
                ];

                $CI->load->model('google_geo/google_geo_model');

                // update company input field
                $googleGeoDbRow = $CI->google_geo_model->get($googleGeoDbData);

                if($googleGeoDbRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#latitude').length)
                            {
                                $('#latitude').val('<?= $googleGeoDbRow->latitude ?>');
                            }

                            if ($('#longitude').length)
                            {
                                $('#longitude').val('<?= $googleGeoDbRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }
            }
        }
    }
    // invoice
    if(preg_match('/estimates\/estimate/', $current_url))
    {
        if ((int)get_option('google_geo_estimates') == 1 && !empty(get_option('google_geo_key')))
        {
            $google_map_key = get_option('google_geo_key');
            ?>
            <script src="https://maps.googleapis.com/maps/api/js?key=<?= $google_map_key ?>&libraries=places&callback=initAutocomplete" async defer></script>
            <?php
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/invoice.php');
            require_once(GOOGLE_GEO_MODULE_PATH . 'includes/common.php');

            $existing_id = google_geo_get_last_segment_id();

            if(!empty($existing_id))
            {
                $CI =& get_instance();
                $CI->load->model('estimates_model');
                $estimateRow = $CI->estimates_model->get($existing_id);

                $CI->load->model('google_geo/google_geo_model');

                // update billing input field
                $googleGeoBillingData = [
                    'user_id' => $estimateRow->clientid,
                    'user_type' => 'client',
                    'module_id' => $estimateRow->id,
                    'module_name' => 'estimate_billing',
                ];

                $googleGeoBillingRow = $CI->google_geo_model->get($googleGeoBillingData);

                if($googleGeoBillingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#billing_latitude').length)
                            {
                                $('#billing_latitude').val('<?= $googleGeoBillingRow->latitude ?>');
                            }

                            if ($('#billing_longitude').length)
                            {
                                $('#billing_longitude').val('<?= $googleGeoBillingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }

                // update shipping input field
                $googleGeoShippingData = [
                    'user_id' => $estimateRow->clientid,
                    'user_type' => 'client',
                    'module_id' => $estimateRow->id,
                    'module_name' => 'estimate_shipping',
                ];

                $googleGeoShippingRow = $CI->google_geo_model->get($googleGeoShippingData);

                if($googleGeoShippingRow)
                {
                    ?>
                    <script>
                        $(function()
                        {
                            if ($('#shipping_latitude').length)
                            {
                                $('#shipping_latitude').val('<?= $googleGeoShippingRow->latitude ?>');
                            }

                            if ($('#shipping_longitude').length)
                            {
                                $('#shipping_longitude').val('<?= $googleGeoShippingRow->longitude ?>');
                            }
                        });
                    </script>
                    <?php
                }
            }
        }
    }
}

function google_geo_before_client_created($client_data)
{
    if(isset($client_data['search_address']) || isset($client_data['billing_search_address']))
    {
        $data['latitude'] = isset($client_data['latitude']) ? $client_data['latitude'] : null;
        $data['longitude'] = isset($client_data['longitude']) ? $client_data['longitude'] : null;

        $data['billing_latitude'] = isset($client_data['billing_latitude']) ? $client_data['billing_latitude'] : null;
        $data['billing_longitude'] = isset($client_data['billing_longitude']) ? $client_data['billing_longitude'] : null;

        $data['shipping_latitude'] = isset($client_data['shipping_latitude']) ? $client_data['shipping_latitude'] : null;
        $data['shipping_longitude'] = isset($client_data['shipping_longitude']) ? $client_data['shipping_longitude'] : null;

        $CI =& get_instance();
        $session_key = 'google_geo_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $data);

        unset($client_data['search_address']);
        unset($client_data['latitude']);
        unset($client_data['longitude']);

        unset($client_data['billing_search_address']);
        unset($client_data['billing_latitude']);
        unset($client_data['billing_longitude']);

        unset($client_data['shipping_search_address']);
        unset($client_data['shipping_latitude']);
        unset($client_data['shipping_longitude']);
    }

    return $client_data;
}

function google_geo_after_client_created($client_data)
{
    $id = $client_data['id'];

    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_id'] = $id;
    $payload['module_id'] = $id;

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        // company
        $post_data = [
            'user_id' => $id,
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'company',
            'latitude' => $payload['latitude'],
            'longitude' => $payload['longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // billing
        $post_data = [
            'user_id' => $id,
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'company_billing',
            'latitude' => $payload['billing_latitude'],
            'longitude' => $payload['billing_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // shipping
        $post_data = [
            'user_id' => $id,
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'company_shipping',
            'latitude' => $payload['shipping_latitude'],
            'longitude' => $payload['shipping_longitude'],
        ];

        $CI->load->google_geo_model->create_or_update($post_data);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_after_client_updated($client_data)
{
    $id = $client_data['id'];

    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_id'] = $id;
    $payload['module_id'] = $id;

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        // company
        $post_data = [
            'user_id' => $id,
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'company',
            'latitude' => $payload['latitude'],
            'longitude' => $payload['longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // billing
        $post_data = [
            'user_id' => $id,
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'company_billing',
            'latitude' => $payload['billing_latitude'],
            'longitude' => $payload['billing_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // shipping
        $post_data = [
            'user_id' => $id,
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'company_shipping',
            'latitude' => $payload['shipping_latitude'],
            'longitude' => $payload['shipping_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_before_client_updated($client_data)
{
    if(isset($client_data['search_address']) || isset($client_data['billing_search_address']))
    {
        $data['latitude'] = isset($client_data['latitude']) ? $client_data['latitude'] : null;
        $data['longitude'] = isset($client_data['longitude']) ? $client_data['longitude'] : null;

        $data['billing_latitude'] = isset($client_data['billing_latitude']) ? $client_data['billing_latitude'] : null;
        $data['billing_longitude'] = isset($client_data['billing_longitude']) ? $client_data['billing_longitude'] : null;

        $data['shipping_latitude'] = isset($client_data['shipping_latitude']) ? $client_data['shipping_latitude'] : null;
        $data['shipping_longitude'] = isset($client_data['shipping_longitude']) ? $client_data['shipping_longitude'] : null;

        $CI =& get_instance();
        $session_key = 'google_geo_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $data);

        unset($client_data['search_address']);
        unset($client_data['latitude']);
        unset($client_data['longitude']);

        unset($client_data['billing_search_address']);
        unset($client_data['billing_latitude']);
        unset($client_data['billing_longitude']);

        unset($client_data['shipping_search_address']);
        unset($client_data['shipping_latitude']);
        unset($client_data['shipping_longitude']);
    }

    return $client_data;
}

function google_geo_after_client_deleted($id)
{
    $CI =& get_instance();
    $CI->load->model('google_geo/google_geo_model');

    // company
    $post_data = [
        'module_id' => $id,
        'module_name' => 'company',
    ];

    $CI->load->google_geo_model->delete_record($post_data);

    $post_data = [
        'module_id' => $id,
        'module_name' => 'company_billing',
    ];

    $CI->load->google_geo_model->delete_record($post_data);

    $post_data = [
        'module_id' => $id,
        'module_name' => 'company_shipping',
    ];

    $CI->load->google_geo_model->delete_record($post_data);
}

function google_geo_before_invoice_added($data)
{
    $post_data = $data['data'];

    if(isset($post_data['billing_search_address']))
    {
        $session_data['billing_latitude'] = $post_data['billing_latitude'];
        $session_data['billing_longitude'] = $post_data['billing_longitude'];

        $session_data['shipping_latitude'] = $post_data['shipping_latitude'];
        $session_data['shipping_longitude'] = $post_data['shipping_longitude'];

        $CI =& get_instance();
        $session_key = 'google_geo_invoice_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $session_data);

        unset($post_data['billing_search_address']);
        unset($post_data['billing_latitude']);
        unset($post_data['billing_longitude']);

        unset($post_data['shipping_search_address']);
        unset($post_data['shipping_latitude']);
        unset($post_data['shipping_longitude']);

        $data['data'] = $post_data;
    }

    return $data;
}

function google_geo_after_invoice_added($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_invoice_pending';

    $CI->load->model('invoices_model');
    $invoice = $CI->invoices_model->get($id);

    $payload = $CI->session->userdata($session_key);
    $payload['user_id'] = $invoice['clientid'];
    $payload['module_id'] = $id;

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        // billing
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'invoice_billing',
            'latitude' => $payload['billing_latitude'],
            'longitude' => $payload['billing_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // shipping
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'invoice_shipping',
            'latitude' => $payload['shipping_latitude'],
            'longitude' => $payload['shipping_longitude'],
        ];

        $CI->load->google_geo_model->create_or_update($post_data);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_before_invoice_updated($data)
{
    $post_data = $data['data'];

    if(isset($post_data['billing_search_address']))
    {
        $session_data['billing_latitude'] = $post_data['billing_latitude'];
        $session_data['billing_longitude'] = $post_data['billing_longitude'];

        $session_data['shipping_latitude'] = $post_data['shipping_latitude'];
        $session_data['shipping_longitude'] = $post_data['shipping_longitude'];

        $CI =& get_instance();
        $session_key = 'google_geo_invoice_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $session_data);

        unset($data['data']['billing_search_address']);
        unset($data['data']['billing_latitude']);
        unset($data['data']['billing_longitude']);

        unset($data['data']['shipping_search_address']);
        unset($data['data']['shipping_latitude']);
        unset($data['data']['shipping_longitude']);
    }

    return $data;
}

function google_geo_after_invoice_updated($data)
{
    $id = $data['id'];

    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_invoice_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_id'] = $data['data']['clientid'];
    $payload['module_id'] = $id;

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        // billing
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'invoice_billing',
            'latitude' => $payload['billing_latitude'],
            'longitude' => $payload['billing_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // shipping
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'invoice_shipping',
            'latitude' => $payload['shipping_latitude'],
            'longitude' => $payload['shipping_longitude'],
        ];

        $CI->load->google_geo_model->create_or_update($post_data);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_after_invoice_deleted($id)
{
    $CI =& get_instance();
    $CI->load->model('google_geo/google_geo_model');


    $post_data = [
            'module_id' => $id,
            'module_name' => 'invoice_billing',
    ];

    $CI->load->google_geo_model->delete_record($post_data);

    $post_data = [
            'module_id' => $id,
            'module_name' => 'invoice_shipping',
    ];

    $CI->load->google_geo_model->delete_record($post_data);
}

function google_geo_before_lead_added($post_data)
{
    if(isset($post_data['search_address']))
    {
        $session_data['latitude'] = $post_data['latitude'];
        $session_data['longitude'] = $post_data['longitude'];
        $session_data['user_id'] = $post_data['assigned'];

        $CI =& get_instance();
        $session_key = 'google_geo_lead_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $session_data);

        unset($post_data['search_address']);
        unset($post_data['latitude']);
        unset($post_data['longitude']);
    }

    return $post_data;
}

function google_geo_after_lead_added($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_lead_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_type'] = 'staff';
    $payload['module_id'] = $id;
    $payload['module_name'] = 'lead';

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        $CI->load->google_geo_model->create_or_update($payload);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_after_lead_updated($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_lead_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_type'] = 'staff';
    $payload['module_id'] = $id;
    $payload['module_name'] = 'lead';

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        $CI->load->google_geo_model->create_or_update($payload);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_after_lead_deleted($id)
{
    $CI =& get_instance();
    $CI->load->model('google_geo/google_geo_model');


    $post_data = [
        'module_id' => $id,
        'module_name' => 'lead',
    ];

    $CI->load->google_geo_model->delete_record($post_data);
}

function google_geo_after_proposal_added($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_proposal_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_type'] = 'staff';
    $payload['module_id'] = $id;
    $payload['module_name'] = 'proposal';

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        $CI->load->google_geo_model->create_or_update($payload);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_before_proposal_added($all_data)
{
    $post_data = $all_data['data'];
    if(isset($post_data['search_address']))
    {
        $data['latitude'] = isset($post_data['latitude']) ? $post_data['latitude'] : null;
        $data['longitude'] = isset($post_data['longitude']) ? $post_data['longitude'] : null;
        $data['user_id'] = isset($post_data['assigned']) ? $post_data['assigned'] : null;

        $CI =& get_instance();
        $session_key = 'google_geo_proposal_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $data);

        unset($all_data['data']['search_address']);
        unset($all_data['data']['latitude']);
        unset($all_data['data']['longitude']);
    }

    return $all_data;
}

function google_geo_before_proposal_updated($all_data)
{
    $post_data = $all_data['data'];
    if(isset($post_data['search_address']))
    {
        $data['latitude'] = isset($post_data['latitude']) ? $post_data['latitude'] : null;
        $data['longitude'] = isset($post_data['longitude']) ? $post_data['longitude'] : null;
        $data['user_id'] = isset($post_data['assigned']) ? $post_data['assigned'] : null;

        $CI =& get_instance();
        $session_key = 'google_geo_proposal_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $data);

        unset($all_data['data']['search_address']);
        unset($all_data['data']['latitude']);
        unset($all_data['data']['longitude']);
    }

    return $all_data;
}

function google_geo_after_proposal_updated($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_proposal_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['user_type'] = 'staff';
    $payload['module_id'] = $id;
    $payload['module_name'] = 'proposal';

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        $CI->load->google_geo_model->create_or_update($payload);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_after_proposal_deleted($id)
{
    $CI =& get_instance();
    $CI->load->model('google_geo/google_geo_model');


    $post_data = [
        'module_id' => $id,
        'module_name' => 'proposal',
    ];

    $CI->load->google_geo_model->delete_record($post_data);
}

function google_geo_before_estimate_added($data)
{
    $post_data = $data['data'];

    if(isset($post_data['billing_search_address']))
    {
        $session_data['user_id'] = $post_data['clientid'];

        $session_data['billing_latitude'] = $post_data['billing_latitude'];
        $session_data['billing_longitude'] = $post_data['billing_longitude'];

        $session_data['shipping_latitude'] = $post_data['shipping_latitude'];
        $session_data['shipping_longitude'] = $post_data['shipping_longitude'];

        $CI =& get_instance();
        $session_key = 'google_geo_estimate_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $session_data);

        unset($post_data['billing_search_address']);
        unset($post_data['billing_latitude']);
        unset($post_data['billing_longitude']);

        unset($post_data['shipping_search_address']);
        unset($post_data['shipping_latitude']);
        unset($post_data['shipping_longitude']);

        $data['data'] = $post_data;
    }

    return $data;
}

function google_geo_after_estimate_added($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_estimate_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['module_id'] = $id;

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        // billing
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'estimate_billing',
            'latitude' => $payload['billing_latitude'],
            'longitude' => $payload['billing_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // shipping
        $post_data = [
                'user_id' => $payload['user_id'],
                'user_type' => 'client',
                'module_id' => $id,
                'module_name' => 'estimate_shipping',
                'latitude' => $payload['shipping_latitude'],
                'longitude' => $payload['shipping_longitude'],
        ];

        $CI->load->google_geo_model->create_or_update($post_data);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_before_estimate_updated($data)
{
    $post_data = $data['data'];
    if(isset($post_data['billing_search_address']))
    {
        $session_data['user_id'] = $post_data['clientid'];

        $session_data['billing_latitude'] = $post_data['billing_latitude'];
        $session_data['billing_longitude'] = $post_data['billing_longitude'];

        $session_data['shipping_latitude'] = $post_data['shipping_latitude'];
        $session_data['shipping_longitude'] = $post_data['shipping_longitude'];

        $CI =& get_instance();
        $session_key = 'google_geo_estimate_pending';
        $CI->load->library('session');
        $CI->session->set_userdata($session_key, $session_data);

        unset($data['data']['billing_search_address']);
        unset($data['data']['billing_latitude']);
        unset($data['data']['billing_longitude']);

        unset($data['data']['shipping_search_address']);
        unset($data['data']['shipping_latitude']);
        unset($data['data']['shipping_longitude']);
    }

    return $data;
}

function google_geo_after_estimate_updated($id)
{
    $CI =& get_instance();
    $CI->load->library('session');

    $session_key = 'google_geo_estimate_pending';

    $payload = $CI->session->userdata($session_key);
    $payload['module_id'] = $id;

    if ($payload && is_array($payload))
    {
        $CI->load->model('google_geo/google_geo_model');

        // billing
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'estimate_billing',
            'latitude' => $payload['billing_latitude'],
            'longitude' => $payload['billing_longitude'],
        ];


        $CI->load->google_geo_model->create_or_update($post_data);

        // shipping
        $post_data = [
            'user_id' => $payload['user_id'],
            'user_type' => 'client',
            'module_id' => $id,
            'module_name' => 'estimate_shipping',
            'latitude' => $payload['shipping_latitude'],
            'longitude' => $payload['shipping_longitude'],
        ];

        $CI->load->google_geo_model->create_or_update($post_data);

        $CI->session->unset_userdata($session_key);
    }
}

function google_geo_after_estimate_deleted($id)
{
    $CI =& get_instance();
    $CI->load->model('google_geo/google_geo_model');


    $post_data = [
        'module_id' => $id,
        'module_name' => 'estimate_billing',
    ];

    $CI->load->google_geo_model->delete_record($post_data);

    $post_data = [
            'module_id' => $id,
            'module_name' => 'estimate_shipping',
    ];

    $CI->load->google_geo_model->delete_record($post_data);
}

register_language_files(GOOGLE_GEO_MODULE_NAME, [GOOGLE_GEO_MODULE_NAME]);
require_once(GOOGLE_GEO_MODULE_PATH . 'install.php');