<?php


// ----------------------
// ADMIN SETTINGS & DASHBOARD
// ----------------------
// Module Information
$lang['appointly_module_name'] = 'Appointly';
$lang['appointly_current_version'] = 'Current module version: ';
$lang['appointly_settings_label_pointer'] = '<strong>Setup -> Settings -> Appointments</strong>';
$lang['appointly_integrations'] = 'Integrations';
$lang['general_settings'] = 'General Settings';
$lang['new_appointment_notification'] = 'New appointment requires approval';
$lang['appointment_notification'] = 'You have a new appointment assigned to you';
$lang['external_appointment_provider_notification'] = 'You have been assigned as provider for a new external appointment';
$lang['appointment_datetime_changed'] = 'Appointment date/time has been changed';
$lang['appointment_attendees_changed'] = 'Appointment attendees have been updated';
$lang['appointment_details_changed'] = 'Appointment details have been updated';
$lang['appointment_status_changed'] = 'Appointment status has been changed';

// Admin Settings
$lang['appointments_approve_automatically_label'] = 'Automatically approve submitted appointments from external web forms';
$lang['appointly_default_table_filter_label'] = 'Default appointments table filter';
$lang['appointment_your_settings'] = 'Your Appointments Settings';
$lang['appointments_buffer_hours_label'] = 'Disable date picker past dates';

// Dashboard & Analytics
$lang['appointly_show_summary_in_appointments_dashboard'] = 'Show appointments summary in appointments dashboard';
$lang['appointments_summary'] = 'Appointments summary';
$lang['appointment_appointments_dashboard'] = 'Dashboard';
$lang['appointment_want_to_go_back'] = 'Appointments';
$lang['appointly_analytics_dashboard'] = 'Appointly Analytics Dashboard';
$lang['appointment_history_label'] = 'Past Appointments';
$lang['appointment_history_label_menu_label'] = 'Appointment History';
$lang['appointment_services_menu_label'] = 'Services';
$lang['appointment_analytics_and_reports_menu_label'] = 'Analytics & Reports';

// Invoice Conversion
$lang['appointment_convert_to_invoice'] = 'Convert to Invoice';
$lang['appointment_converted_to_invoice'] = 'Appointment successfully converted to invoice';
$lang['appointment_convert_to_invoice_success'] = 'Appointment successfully converted to invoice #%s';
$lang['appointment_convert_to_invoice_failed'] = 'Failed to convert appointment to invoice';
$lang['appointment_are_you_sure_convert_to_invoice'] = 'Are you sure you want to convert this appointment to an invoice?';
$lang['appointment_view_invoice'] = 'View Invoice #%s';
$lang['appointment_convert_to_invoice_tooltip'] = 'Invoice creation is only available for appointments with actual customers. For leads or external contacts, you must first convert them to customers.';
$lang['appointment_external_contact_converted_to_client'] = 'External contact successfully converted to client';
$lang['appointment_external_contact_convert_to_client_error'] = 'Error converting external contact to client';
$lang['appointment_convert_to_customer_first'] = 'Convert to Customer First';
$lang['appointment_convert_lead_to_customer'] = 'Convert Lead to Customer';
$lang['appointment_convert_external_to_customer'] = 'Convert to Customer';
$lang['appointment_convert_only'] = 'Convert Only';
$lang['appointment_convert_and_view'] = 'Convert and View';
$lang['appointment_convert_to_invoice_only_contacts_allowed'] = 'Only internal appointments with contacts can be converted to invoices';

// Lead Conversion
$lang['appointments_convert_to_lead'] = 'Convert Appointment to Lead';
$lang['appointments_convert_to_lead_label'] = 'Convert to lead';
$lang['appointments_create_task_tooltip'] = 'Convert to task';
$lang['appointments_convert_to_lead_tooltip'] = 'Convert to lead';
$lang['appointments_select_option'] = 'Select option';
$lang['appointments_contact_name_task'] = 'Appointment: Contact name';

// Reports Dashboard
$lang['appointly_reports_dashboard'] = 'Appointly Reports Dashboard';
$lang['appointly_date_range'] = 'Date Range';
$lang['appointly_today'] = 'Today';
$lang['appointly_this_week'] = 'This Week';
$lang['appointly_this_month'] = 'This Month';
$lang['appointly_this_year'] = 'This Year';
$lang['appointly_last_month'] = 'Last Month';
$lang['appointly_last_year'] = 'Last Year';
$lang['appointly_last_30_days'] = 'Last 30 Days';
$lang['appointly_custom_range'] = 'Custom Range';
$lang['appointly_period_from'] = 'Period From';
$lang['appointly_period_to'] = 'Period To';
$lang['appointly_date_range_required'] = 'Please select a valid date range';
$lang['appointly_apply'] = 'Apply';
$lang['appointly_total_appointments'] = 'Total Appointments';
$lang['appointly_completed_appointments'] = 'Completed Appointments';
$lang['appointly_cancelled_appointments'] = 'Cancelled Appointments';
$lang['appointly_monthly_stats'] = 'Monthly Statistics';
$lang['appointly_popular_services'] = 'Popular Services';
$lang['appointly_staff_performance'] = 'Staff Performance';
$lang['appointly_staff_member'] = 'Staff Member';
$lang['appointly_appointment_total_appointments'] = 'Total Appointments';
$lang['appointly_appointment_completed_appointments'] = 'Completed Appointments';
$lang['appointly_appointment_cancelled_appointments'] = 'Cancelled Appointments';
$lang['appointly_appointment_completion_rate'] = 'Completion Rate';
$lang['appointly_filter'] = 'Filter';
$lang['appointly_no_staff_performance_data'] = 'No staff performance data available for the selected period';
$lang['appointly_report'] = 'Report';
$lang['appointly_reports_updated_for_period'] = 'Reports updated for period: %s to %s';
$lang['appointly_no_data_for_period'] = 'No data available for the selected period';
$lang['appointly_invalid_date_format'] = 'Invalid date format. Please use the date picker to select dates';
$lang['appointly_loading_data'] = 'Loading data...';
$lang['appointly_error_refreshing_stats'] = 'Error refreshing statistics. Please try again.';
$lang['appointly_no_data_found'] = 'No data found';

// Analytics Dashboard (consolidated - removed duplicates)
$lang['total_appointments'] = 'Total Appointments';
$lang['completed_appointments'] = 'Completed Appointments';
$lang['cancelled_appointments'] = 'Cancelled Appointments';
$lang['monthly_statistics'] = 'Monthly Statistics';
$lang['popular_services'] = 'Popular Services';
$lang['staff_performance'] = 'Staff Performance';
$lang['staff_member'] = 'Staff Member';
$lang['completion_rate'] = 'Completion Rate';
$lang['from_date'] = 'From Date';
$lang['to_date'] = 'To Date';

$lang['appointment_services_to_show_in_booking_form'] = 'Select which services to display in the public booking form';
$lang['appointment_services_select_all_to_show_all'] = 'Leave empty to show all active services';
$lang['appointment_select_attendees'] = 'Attendees';
$lang['appointment_select_attendees_help'] = 'Select additional staff members who will attend this appointment';
$lang['appointment_related'] = 'Related';

// Service Availability Settings
$lang['services_availability_updated_successfully'] = 'Services availability updated successfully';
$lang['services_availability_update_failed'] = 'Failed to update services availability';
$lang['appointment_error_loading_providers'] = 'Error loading providers';
$lang['appointment_select_service_warning'] = 'Please select a service';
$lang['appointment_select_provider_warning'] = 'Please select a provider';
$lang['appointment_select_date_time_warning'] = 'Please select a date and time';
$lang['appointment_loading_providers'] = 'Loading providers...';
$lang['appointment_select_date'] = 'Select Date';
$lang['appointment_your_details'] = 'Your Details';
$lang['appointment_continue'] = 'Next';
$lang['appointment_back'] = 'Back';
$lang['appointment_summary'] = 'Appointment Summary';
$lang['appointment_select'] = 'Select';
$lang['error_loading_data'] = 'Error loading data';
$lang['appointment_booking_failed'] = 'Failed to book appointment. Please try again.';
$lang['appointment_successfully_scheduled'] = 'Appointment Successfully Scheduled';
$lang['appointment_successfully_scheduled_message'] = 'Thank you! Your appointment has been successfully scheduled.';
$lang['appointment_successfully_scheduled_button'] = 'Awesome!';
$lang['appointment_schedule_another'] = 'Schedule Another';
$lang['appointment_not_specified'] = 'Not specified';
$lang['appointment_booking_confirmed'] = 'Thank you! Your appointment has been successfully scheduled.';
$lang['appointment_pending_approval_message'] = 'Your appointment is awaiting staff approval. You\'ll be notified once it\'s confirmed.';
$lang['appointment_whats_next'] = 'What\'s Next?';
$lang['appointment_staff_review'] = 'Our staff is reviewing your request. Please wait for confirmation.';
$lang['appointment_email_confirmation'] = 'You will receive an email confirmation shortly with all appointment details.';
$lang['appointment_prepare'] = 'Please prepare any required documents or details before your appointment.';
$lang['appointment_files'] = 'Files';
$lang['appointment_externally_booked_info'] = 'This appointment was booked via the external booking form';
$lang['appointment_booked_from_external_booking_form'] = 'Booking From';
$lang['appointment_subject_required'] = 'Subject is required for the appointment';
$lang['appointment_attendees_required'] = 'At least one staff member must attend the appointment';
$lang['appointment_name_required'] = 'Name is required for external appointments';
$lang['appointment_email_required'] = 'Email is required for external appointments';
$lang['appointment_email_invalid'] = 'Please provide a valid email address';
$lang['appointment_contact_required'] = 'Please select a contact for the internal appointment';
$lang['appointment_invalid_type'] = 'Invalid appointment type selected';
$lang['appointment_type_required'] = 'Please select an appointment type';
$lang['appointment_invalid_data'] = 'Invalid appointment data provided';
$lang['appointment_could_not_be_created'] = 'The appointment could not be created. Please try again.';
$lang['appointment_unavailable_slots'] = 'Red slots are unavailable due to existing appointments';
$lang['appointment_book_now_description'] = 'Book your appointment now and get the best service from our team';
$lang['appointment_book_now_button_description'] = 'Book your appointment now and get the best service from our team';
$lang['appointment_feature_coming_soon'] = 'This feature will be available in the upcoming updates. Stay tuned!';
$lang['appointment_description_updated'] = 'Appointment description updated successfully';
$lang['appointment_notes_updated'] = 'Appointment notes successfully updated';
$lang['appointment_notes_update_failed'] = 'Failed to update appointment notes';
$lang['appointment_update_failed'] = 'Failed to update appointment';
$lang['appointment_description_edit_info'] = 'Click to edit description. Changes will be saved automatically when you finish editing.';
$lang['appointment_viewing_notes'] = 'Viewing notes for appointment';
$lang['appointment_edit_history_notes'] = 'Edit Notes';
$lang['appointment_email_missing'] = 'Email address is missing or invalid for this appointment';
$lang['appointment_no_name_provided'] = 'No name provided';
$lang['appointment_no_phone_provided'] = 'No phone provided';
$lang['appointment_open_link'] = 'Open Link';
$lang['appointment_menu_form_link'] = 'Booking Form';
$lang['external_form_heading'] = 'Booking Form Heading';
$lang['external_form_description'] = 'Booking Form Description';
$lang['appointment_date_location'] = 'Session Details';
$lang['appointment_schedule_description'] = 'Complete the form below to arrange your session with our team';
$lang['appointment_preferred_date_time'] = 'Preferred Date & Time';
$lang['appointment_select_date_time'] = 'Select...';
$lang['appointment_terms_description'] = 'By proceeding, you confirm your acceptance of our';
$lang['appointment_terms_link'] = 'Terms and Conditions';
$lang['appointment_accept_terms'] = 'I acknowledge and agree to the Terms of Service*';
$lang['appointly_recaptcha_enabled'] = 'Enable Recaptcha';
$lang['appointment_no_location_provided'] = 'No location provided to render Google Maps';
$lang['appointment_imported_from_calendar'] = 'Imported from %s';
$lang['appointment_imported_cant_edit_notice'] = 'This appointment was imported from an external calendar and cannot be edited.';
$lang['appointment_are_you_sure'] = 'Are you sure you want to delete this appointment?';
$lang['would_you_like_to_create_new_appointment_for_lead'] = 'Would you like to create a new appointment for this lead?';
$lang['would_you_like_to_create_new_appointment_for_client'] = 'Would you like to create a new appointment for this client?';
$lang['would_you_like_to_create_new_appointment'] = 'Would you like to create a new appointment?';
$lang['no_appointments_found'] = 'No appointments found';

// ----------------------
// EXTERNAL BOOKING FORM
// ----------------------
$lang['appointment_available_days'] = 'Available';
$lang['appointment_busy_days'] = 'Busy (has appointments)';
$lang['appointment_provider_unavailable'] = 'Provider unavailable';
$lang['appointment_blocked_days'] = 'Company Holiday/Blocked Date';
$lang['appointment_date_required'] = 'Please select a date first';
$lang['appointment_select_time'] = 'Select a time';
$lang['appointment_book_now'] = 'Book Now';
$lang['appointment_submitting'] = 'Booking Appointment...';

// New appointment filter options
$lang['appointment_today'] = 'Today\'s Appointments';
$lang['appointment_tomorrow'] = 'Tomorrow\'s Appointments';
$lang['appointment_this_week'] = 'This Week\'s Appointments';
$lang['appointment_next_week'] = 'Next Week\'s Appointments';
$lang['appointment_this_month'] = 'This Month\'s Appointments';
$lang['appointment_my_appointments'] = 'My Appointments';
$lang['appointment_assigned_to_me'] = 'Assigned to Me';


// ----------------------
// GENERAL/COMMON TERMS
// ----------------------
$lang['appointment_yes'] = 'Yes';
$lang['appointment_no'] = 'No';
$lang['appointment_appointments'] = 'Appointments';
$lang['appointment_label'] = 'Appointment';
$lang['wait_text'] = 'Please wait...';
$lang['loading_text'] = 'Loading, please wait...';
$lang['appointment_loading'] = 'Loading...';
$lang['unknown_error'] = 'Unknown error';
$lang['request_failed'] = 'Request failed';
$lang['error_processing_response'] = 'Error processing response';
$lang['invalid_appointment_id'] = 'Invalid appointment ID';
$lang['appointment_select_option'] = 'Select Option';
$lang['appointly_note'] = 'Note';
$lang['appointment_optional'] = '<small> (optional) </small>';
$lang['required_field_missing'] = 'The field is required';
$lang['appointly_required_field'] = 'Required field';
$lang['settings_updated'] = 'Settings updated successfully';

// Time and date terms
$lang['timezone'] = 'Timezone';
$lang['minutes'] = 'Minutes';
$lang['hours'] = 'Hours';
$lang['monday'] = 'Monday';
$lang['tuesday'] = 'Tuesday';
$lang['wednesday'] = 'Wednesday';
$lang['thursday'] = 'Thursday';
$lang['friday'] = 'Friday';
$lang['saturday'] = 'Saturday';
$lang['sunday'] = 'Sunday';
$lang['today'] = 'Today';
$lang['this_week'] = 'This Week';
$lang['this_month'] = 'This Month';
$lang['this_year'] = 'This Year';
$lang['date_range'] = 'Date Range';
$lang['custom_range'] = 'Custom Range';
$lang['filter'] = 'Filter';

// ----------------------
// APPOINTMENT BASICS
// ----------------------
$lang['appointment_back_to_appointments'] = 'Appointments';
$lang['appointment_create_new_appointment'] = 'Schedule a Consultation';
$lang['appointment_select_contact'] = 'Select Contact';
$lang['appointment_new_appointment'] = 'Create Appointment';
$lang['appointment_edit_appointment'] = 'Update Appointment';
$lang['appointment_save_changes_btn_label'] = 'Save Changes';
$lang['appointment_subject'] = 'Meeting Purpose';
$lang['appointment_description'] = 'Session Overview';
$lang['appointment_overview'] = 'Appointment Overview';
$lang['appointment_additional_info'] = 'Additional Information';
$lang['appointment_date'] = 'Date';
$lang['appointment_time'] = 'Preferred Time';
$lang['appointment_date_time'] = 'Date & Time';
$lang['appointment_meeting_date'] = 'Appointment Date';
$lang['appointment_meeting_time'] = 'Appointment Date';
$lang['appointments_reminders_label'] = 'Reminders';
$lang['appointment_meeting_location'] = 'Location';
$lang['appointment_location'] = 'Location';
$lang['appointment_location_address'] = 'Location / Address';
$lang['appointment_location_placeholder'] = 'Enter location details';
$lang['appointment_duration'] = 'Appointment Duration';
$lang['appointment_duration_label'] = 'Duration';
$lang['appointment_duration_help'] = 'Set the appointment duration in minutes';
$lang['appointment_notes'] = 'Notes';
$lang['appointment_private_notes'] = 'Private Notes';
$lang['appointment_client_notes'] = 'Appointment notes';
$lang['appointment_created_by'] = 'Created By';
$lang['appointly_created_at'] = 'Created At';
$lang['appointment_schedule_details'] = 'Appointment Schedule';
$lang['appointment_additional_settings'] = 'Additional Settings';

// Appointment Status
$lang['appointment_status'] = 'Status';
$lang['appointment_status_text'] = 'Appointment Status';
$lang['appointment_status_pending'] = 'Pending';
$lang['appointment_status_in-progress'] = 'In Progress';
$lang['appointment_status_completed'] = 'Completed';
$lang['appointment_status_cancelled'] = 'Cancelled';
$lang['appointment_status_no-show'] = 'No Show';
$lang['appointment_upcoming'] = 'Upcoming';
$lang['appointment_finished'] = 'Finished';
$lang['appointment_ongoing'] = 'In progress';
$lang['appointment_cancelled'] = 'Cancelled';
$lang['appointment_rescheduled'] = 'Rescheduled';
$lang['appointment_no_show'] = 'No-show';
$lang['appointment_missed_label'] = 'Missed';
$lang['appointment_pending_approval'] = 'Pending approval';
$lang['appointment_not_approved'] = 'Pending Approval';
$lang['appointment_pending_cancellation'] = 'Pending Cancellation';
$lang['appointment_cancelled_text'] = 'Appointment Cancelled';
$lang['appointment_missed'] = 'Appointment Missed (Appointment Date/Time is in the past)';
$lang['appointment_are_you_sure_mark_as_no_show'] = 'Are you sure you want to mark this appointment as No Show?';
$lang['appointment_completed'] = 'Completed';
$lang['appointment_internal'] = 'Internal';
$lang['appointment_external'] = 'External';
$lang['appointment_lead_related'] = 'Lead';
$lang['appointment_internal_staff'] = 'Staff';

// Status and Action Buttons
$lang['appointment_approve'] = 'Approve';
$lang['appointment_approved'] = 'Approved';
$lang['appointment_mark_as_finished'] = 'Mark as finished';
$lang['appointment_mark_as_ongoing'] = 'Mark as ongoing';
$lang['appointment_mark_as_cancelled'] = 'Cancelled';
$lang['appointment_mark_as_rescheduled'] = 'Mark as rescheduled';
$lang['appointment_mark_as_no_show'] = 'Mark as no-show';
$lang['appointment_cancel'] = 'Cancel Appointment';
$lang['appointment_description_to_cancel'] = 'Please describe why you want to cancel this appointment';
$lang['appointment_describe_reason_for_cancel'] = 'Description is required. Please describe what is the reason for cancelling the appointment?';
$lang['appointment_request_to_cancel'] = 'Request Cancellation';
$lang['appointment_request_cancellation'] = 'Request Cancellation';
$lang['appointment_approve_cancellation'] = 'Approve Cancellation';
$lang['appointment_marked_as_no_show'] = 'Marked as No Show';
$lang['appointly_are_you_sure_mark_as_no_show'] = 'Are you sure you want to mark this appointment as No Show?';

$lang['appointment_you_have_new_appointment'] = 'You have a new appointment';
$lang['appointment_initiated_by'] = 'Organizer';
$lang['appointment_select_single_contact'] = 'Contact';
$lang['appointment_deleted'] = 'Appointment was successfully deleted';
$lang['appointment_created'] = 'New appointment was successfully created';
$lang['appointment_updated'] = 'Appointment was successfully updated';
$lang['appointment_appointment_approved'] = 'Appointment was successfully approved!';
$lang['appointment_no_appointments'] = 'You have no appointments for today';
$lang['appointment_please_wait'] = 'Please wait...';
$lang['appointment_no_assigned_staff_found'] = 'No assigned attendees found for this appointment';
$lang['appointment_cancel_notification'] = 'Client has requested appointment cancellation';
$lang['appointment_marked_as_finished'] = 'Appointment marked as finished';
$lang['appointment_todays_appointments'] = 'Today\'s appointments';
$lang['appointment_scheduled_at'] = 'Scheduled at:';
$lang['appointment_view_meeting'] = 'View Appointment';
$lang['appointment_edit_meeting'] = 'Edit Appointment';
$lang['appointment_dismiss_meeting'] = 'Delete Appointment';
$lang['appointment_not_exists'] = 'Appointment not found redirecting to appointments list';
$lang['appointment_marked_as_ongoing'] = 'Appointment marked as ongoing';
$lang['appointment_general_info'] = 'Client Details';
$lang['appointment_general_details'] = 'Appointment Details';
$lang['appointment_source'] = 'Type';
$lang['appointment_source_external_text'] = 'External (Contact)';
$lang['appointment_source_external'] = 'Source (External Contact)';
$lang['appointment_source_external_contact'] = 'External Contact';
$lang['appointment_source_internal'] = 'Internal (Contact)';
$lang['appointment_lead_required'] = 'Please select a lead for the appointment';
$lang['appointment_source_internal_client'] = 'Internal (Contact)';
$lang['appointment_source_internal_staff'] = 'Internal (Staff)';
$lang['appointment_source_lead'] = 'Lead';
$lang['appointment_staff_only'] = 'Staff Only';
$lang['appointment_phone'] = 'Phone';
$lang['appointment_name'] = 'Name';
$lang['appointment_email'] = 'Email';
$lang['appointment_contact'] = 'Client Details';
$lang['appointment_sent_successfully'] = 'Your new appointment request send successfully, you will be notified by email when your appointment is approved';
$lang['appointment_squeduled_at_text'] = 'Appointment scheduled to start at';
$lang['appointment_staff_attendees'] = 'Attendees';
$lang['appointment_is_approved'] = 'Appointment has been approved!';
$lang['appointment_public_url'] = 'Public URL';
$lang['appointment_is_cancelled'] = 'Appointment has been cancelled!';
$lang['appointment_cancel_notes'] = 'Cancellation Notes';
$lang['appointment_full_name'] = 'Client Name';
$lang['appointment_your_email'] = 'Your Email';
$lang['appointment_your_phone'] = 'Phone (with country code)';
$lang['appointment_your_phone_example'] = '+1 69 1234 5678';
$lang['appointment_submit'] = 'Submit';
$lang['appointment_no_staff_members'] = 'No staff members were found, you should add staff member and reload this view in order to select a person for new appointments submitted via iFrame form.';
$lang['appointment_cancellation_description_label'] = 'Cancellation Reason';
$lang['appointments_thank_you_cancel_request'] = 'Thank you for your cancellation request. We\'ll review it shortly.';
$lang['appointments_already_applied_for_cancelling'] = 'You have already requested to cancel this appointment.';
$lang['appointment_pending_cancellations'] = 'Pending Cancellation Requests';
$lang['appointment_requested_by'] = 'Requested By';
$lang['appointment_cancellation_approved'] = 'Cancellation request approved successfully';
$lang['appointly_schedule_new_appointment'] = 'Schedule Appointment';
$lang['appointments_total_found'] = 'Total appointments';
$lang['appointments_admin_label'] = 'Administrator';
$lang['appointments_staff_label'] = 'Staff';
$lang['appointments_no_delete_permissions'] = 'This appointment was not created by you, unable to delete';
$lang['appointment_source_external_clients_area'] = 'Source (From clients area existing contact)';
$lang['appointments_source_external_label'] = 'External';
$lang['appointments_source_internal_label'] = 'Internal';
$lang['appointments_individual_contact'] = ' (Individual Contact)';
$lang['appointments_company_for_select'] = ' - Customer ';
$lang['appointment_preview_url_label'] = 'Preview';
$lang['appointment_booking_form_services'] = 'Booking Form Services';
$lang['appointment_source_leads_label'] = 'Leads';
$lang['appointment_connect'] = 'Connect';
$lang['appointment_connected'] = 'Connected';
$lang['appointments_outlook_revoke_confirm'] = 'Sign Out from Outlook';
$lang['appointment_selected_service'] = 'Selected Service';
$lang['appointment_please_enter_your_details'] = 'Please enter your details';
$lang['appointments_request_feedback_from_client'] = 'Request feedback from client';
$lang['appointments_request_feedback'] = 'Request feedback';
$lang['appointment_feedback_label'] = 'Feedback';
$lang['appointment_view_feedback'] = 'View Feedback';
$lang['appointment_feedback_label_added'] = 'Thank you for your feedback!';
$lang['appointment_feedback_label_current'] = 'Your current given feedback!';
$lang['appointments_feedback_info'] = 'Manage your default feedback statuses';
$lang['ap_feedback_extremely_good'] = 'Extremely Good';
$lang['ap_feedback_very_good'] = 'Very Good';
$lang['ap_feedback_good'] = 'Good';
$lang['ap_feedback_not_bad'] = 'Not Bad';
$lang['ap_feedback_bad'] = 'Bad';
$lang['ap_feedback_the_worst'] = 'The Worst';
$lang['ap_feedback_not_sure'] = 'Not Sure';
$lang['appointment_feedback_title'] = 'Leave your feedback for this appointment';
$lang['appointmenet_feedback_comment'] = 'Your comments and thoughts about this appointment: ';
$lang['appointment_feedback_comment_textarea'] = 'At least a few words are required to describe your experience with this appointment';
$lang['appointment_feedback_comment_textarea_info'] = 'Please describe your experience with this appointment';
$lang['appointment_new_feedback_added'] = 'You have a new feedback for an appointment';
$lang['appointly_feedback_updated'] = 'Feedback rating was just updated';
$lang['appointment_email_tracking'] = 'Email tracking (is appointment email read)';
$lang['appointment_feedback_requested_alert'] = 'Feedback was successfully requested, you will be notified by email if feedback is given!';
$lang['appointment_click_to_change_rating'] = 'Click on the stars to update your rating';
$lang['appointment_staff_cant_provide_feedback'] = 'Staff members cannot provide feedback for appointments';
$lang['appointment_leave_feedback'] = 'Rate your experience with this appointment';
$lang['appointment_your_feedback'] = 'Your Feedback';
$lang['appointment_no_feedback_provided'] = 'The client has not provided feedback for this appointment yet';
$lang['appointments_are_you_sure_request_feedback'] = 'Are you sure you want to request feedback for this appointment? An email will be sent to the client.';

// Client Area
$lang['appointly_allow_non_logged_clients_appointment'] = 'Allow clients who are not logged in to request new appointments through external booking form';
$lang['appointly_show_appointments_menu_item_in_clients_area'] = 'Display appointment request menu item in clients area (when logged in)';
$lang['appointments_applies_for_clients'] = '(applies only for clients)';

// ----------------------
// TIME SLOTS & AVAILABILITY
// ----------------------
$lang['appointly_no_providers_for_service'] = 'No providers available for this service';
$lang['appointly_no_providers_with_hours'] = 'No providers with available working hours for this service';
$lang['appointly_select_staff'] = 'Select Staff Member';
$lang['appointment_busy_hours'] = 'Busy Hours';
$lang['appointment_available_hours'] = 'Available Hours';
$lang['appointly_available_time_slots'] = 'Available Time Slots';
$lang['appointment_meeting_hour_is_reserved'] = 'Appointment Hour is already reserved';
$lang['appointment_requested_hour'] = 'Requested meeting hour';
$lang['appointment_time_unavailable'] = 'This time slot is unavailable';
$lang['appointment_date_blocked'] = 'This date is blocked by administrator';
$lang['appointment_no_slots_available'] = 'No available time slots for this day';
$lang['appointment_slot_already_booked'] = 'This time slot is already booked';
$lang['appointment_unavailable_slots_shown'] = 'Unavailable time slots are shown in red and cannot be selected';
$lang['appointment_all_slots_booked'] = 'All time slots for this day are booked. Please try another date.';
$lang['appointment_slot_unavailable'] = 'This time slot is unavailable';
$lang['appointment_checking_availability'] = 'Checking availability...';
$lang['appointment_checking_time_slots'] = 'Loading time slots...';
$lang['appointment_error_loading_slots'] = 'Error loading time slots. Please try again.';
$lang['appointment_not_available'] = 'Not available';
$lang['appointment_available'] = 'Available';

// Schedule and calendar
$lang['appointment_recurring'] = 'Recurring';
$lang['appointment_recurring_re_created'] = 'Recurring appointment was recreated';
$lang['appointments_all_day_event'] = 'All day event';
$lang['select_blocked_days'] = 'Select days';
$lang['appointments_blocked_days_on_calendar_title'] = 'Blocked Days';
$lang['appointments_blocked_days_on_calendar_info'] = 'Select dates when appointments cannot be scheduled (holidays, company closures, etc.).<br> These dates will be unavailable for both internal and external booking.';
$lang['appointments_dates_blocked_info_text'] = 'The selected dates will be unavailable in the booking calendar. Meetings cannot be scheduled internally or externally on these dates.';
$lang['appointments_blocked_days_tab_title'] = 'Not working days';

// Working Hours and Schedules
$lang['appointments_default_hours_label'] = 'Manage your default appointment hours';
$lang['appointly_company_schedule'] = 'Company Schedule';
$lang['appointly_company_schedule_info'] = 'Configure the default working hours for your company. These hours will be used for all staff members unless they have their own specific working hours set.';
$lang['appointly_manage_company_schedule'] = 'Manage Company Schedule';
$lang['appointly_staff_working_hours'] = 'Staff Working Hours';
$lang['appointly_staff_working_hours_info'] = 'Configure the working hours for this staff member. These hours will override the company schedule when this staff member is selected as a provider.';
$lang['appointly_view_staff_schedule'] = 'View Staff Schedule';
$lang['appointly_day'] = 'Day';
$lang['appointly_enabled'] = 'Enabled';
$lang['appointly_available'] = 'Available';
$lang['appointly_start_time'] = 'Start Time';
$lang['appointly_end_time'] = 'End Time';
$lang['appointly_use_company_schedule'] = 'Use Company Schedule';
$lang['appointly_use_company_schedule_tooltip'] = 'Check to use the company schedule settings for this day instead of custom settings.';
$lang['appointly_day_monday'] = 'Monday';
$lang['appointly_day_tuesday'] = 'Tuesday';
$lang['appointly_day_wednesday'] = 'Wednesday';
$lang['appointly_day_thursday'] = 'Thursday';
$lang['appointly_day_friday'] = 'Friday';
$lang['appointly_day_saturday'] = 'Saturday';
$lang['appointly_day_sunday'] = 'Sunday';
$lang['appointly_at_least_one_day_required'] = 'At least one day must be enabled';
$lang['appointly_no_working_hours_found'] = 'No working hours have been set for this provider';
$lang['appointly_closed'] = 'Closed';
$lang['appointly_working_hours'] = 'Working Hours';
$lang['company_schedule_time_intervals_note'] = 'Times can only be set in 15-minute intervals (e.g., 09:00, 09:15, 09:30, 09:45)';
$lang['working_hours_time_intervals_note'] = 'Time slots are available in 15-minute intervals';
$lang['appointly_time_error'] = 'Start time must be earlier than end time for';
$lang['appointly_company_schedule_sync_help'] = 'Staff can use the "Use Company Schedule" option to sync their hours with company defaults.';

// Buffer settings
$lang['appointly_settings_buffer_times'] = 'Enable buffer times between appointments';
$lang['appointly_settings_buffer_times_info'] = 'Buffer times allow for transition periods between appointments';
$lang['appointly_buffer_before'] = 'Buffer Before (minutes)';
$lang['appointly_buffer_after'] = 'Buffer After (minutes)';
$lang['appointly_buffer_before_help'] = 'Additional time before appointment to prepare';
$lang['appointly_buffer_after_help'] = 'Additional time after appointment to clean up';

// ----------------------
// SERVICES & PROVIDERS
// ----------------------
$lang['appointly_services'] = 'Services';
$lang['service'] = 'Service';
$lang['appointment_service'] = 'Service';
$lang['appointment_services'] = 'Services';
$lang['appointment_select_service'] = 'Select Service';
$lang['appointment_service_duration'] = 'Duration';
$lang['appointment_service_price'] = 'Price';
$lang['appointment_service_description'] = 'Description';
$lang['appointments_service_heading'] = 'Service';
$lang['appointments_staff_heading'] = 'Staff';
$lang['service_selection_required'] = 'Please select a service';
$lang['appointment_service_required'] = 'Please select a service for the appointment';
$lang['appointly_service_selection_label'] = 'Service';
$lang['appointments_selected_service'] = 'Selected Service';
$lang['no_services_available'] = 'No services available';

// Service Creation and Management
$lang['appointly_new_service'] = 'New Service';
$lang['appointly_edit_service'] = 'Edit Service';
$lang['appointly_service_add_success'] = 'Service added successfully';
$lang['appointly_service_edit_success'] = 'Service updated successfully';
$lang['appointly_service_delete_success'] = 'Service deleted successfully';
$lang['appointly_service_delete_error'] = 'Could not delete service';
$lang['error_adding_service'] = 'Could not add service';
$lang['error_updating_service'] = 'Could not update service';
$lang['service_delete_error_active'] = 'Service is active and cannot be deleted or disabled.';
$lang['appointly_service_in_use_warning'] = 'This service is currently in use in one or more appointments and cannot be deleted or disabled.';

// Service Properties
$lang['service_availability_days'] = 'Available Days';
$lang['service_hours_start'] = 'Working Hours Start';
$lang['service_hours_end'] = 'Working Hours End';
$lang['appointly_service_name'] = 'Name';
$lang['appointly_service_name_label'] = 'Service Name';
$lang['appointly_service_duration'] = 'Duration';
$lang['appointly_service_price'] = 'Price';
$lang['appointly_service_color'] = 'Color';
$lang['appointly_service_description'] = 'Description';
$lang['appointly_service_active'] = 'Active';
$lang['appointly_service_details'] = 'Service Details';
$lang['appointly_service_back_to_list'] = 'Back to Services List';
$lang['appointly_duration_validation'] = 'Duration must be in intervals of 15 minutes (15, 30, 45, etc) and maximum 480 minutes';
$lang['appointly_price_validation'] = 'Price cannot be negative';
$lang['appointly_duration_minutes'] = 'minutes';
$lang['appointly_service_staff'] = 'Assigned to Provider/Staff';
// Service Validation
$lang['service_name_required'] = 'Service name is required';
$lang['service_duration_required'] = 'Service duration is required';
$lang['service_duration_numeric'] = 'Duration must be a number';
$lang['service_duration_greater'] = 'Duration must be greater than 0';
$lang['service_price_required'] = 'Service price is required';
$lang['service_price_greater_equal'] = 'Price must be 0 or greater';
$lang['service_days_required'] = 'Please select at least one available day';
$lang['service_hours_required'] = 'Service hours are required';
$lang['service_hours_invalid'] = 'Invalid time format';
$lang['service_hours_start_end'] = 'End time must be after start time';
$lang['appointly_staff_required'] = 'Please select a staff member';
$lang['appointly_working_hours_required'] = '%s working hours are required.';
$lang['appointly_working_hours_invalid'] = '%s end time must be after start time.';
$lang['appointly_working_hours_at_least_one'] = 'At least one day must be enabled.';

// Service Table Headers
$lang['service_th_name'] = 'Name';
$lang['service_th_duration'] = 'Duration (minutes)';
$lang['service_th_price'] = 'Price';
$lang['service_th_availability'] = 'Availability';
$lang['service_th_status'] = 'Status';
$lang['service_th_options'] = 'Options';

// Service Status
$lang['service_status_active'] = 'Active';
$lang['service_status_inactive'] = 'Inactive';
$lang['service_status_changed_success'] = 'Service status updated successfully';
$lang['service_status_changed_error'] = 'Could not update service status';
$lang['service_toggle_active'] = 'Toggle active status';
$lang['error_updating_status'] = 'Error updating status. Please try again.';
$lang['service_status_updated'] = 'Service status updated successfully';
$lang['service_status_update_failed'] = 'Could not update service status';

// Providers
$lang['appointment_provider'] = 'Provider';
$lang['appointly_provider'] = 'Provider';
$lang['service_provider_loading'] = 'Loading available providers...';
$lang['service_no_providers'] = 'No providers available for this service';
$lang['service_provider_select'] = 'Select Provider';
$lang['appointment_select_provider'] = 'Select Provider';
$lang['appointly_select_provider'] = 'Select Provider';
$lang['appointly_no_staff'] = 'No staff members available';
$lang['appointly_error_loading_schedule'] = 'Error loading provider schedule';
$lang['appointment_no_provider_assigned'] = 'No provider assigned';
$lang['appointly_meeting_location'] = 'Meeting Location';

// Multiple Providers
$lang['appointly_settings_multi_providers'] = 'Enable multiple providers per service';
$lang['appointly_settings_multi_providers_info'] = 'Allow services to be provided by multiple staff members';
$lang['appointly_primary_provider'] = 'Primary Provider';
$lang['appointly_add_provider'] = 'Add Provider';
$lang['appointly_remove_provider'] = 'Remove Provider';
$lang['appointly_service_providers'] = 'Service Providers';
$lang['appointly_confirm_provider_removal'] = 'Are you sure you want to remove this provider?';
$lang['appointly_assigned_providers'] = 'Assigned Providers';
$lang['appointly_service_primary_provider'] = 'Primary Provider';
$lang['appointment_external_provider'] = 'External Provider';

// ----------------------
// NOTIFICATIONS & REMINDERS
// ----------------------
$lang['appointment_modal_notification_info'] = 'Please mark the checkboxes as checked if you want selected attendees and contact to receive reminders eg. if set 30 minutes before the appointment start. Note that this feature requires cron job to be configured.';
$lang['appointment_sms_notification_text'] = 'Send SMS Notifications';
$lang['appointment_email_notification_text'] = 'Send Email Notifications';
$lang['appointment_send_notification'] = 'Send notification now';
$lang['appointment_notified'] = 'Appointment Reminders';
$lang['appointment_notified_by_sms'] = 'Reminder notification by SMS triggered';
$lang['appointment_notified_by_email'] = 'Reminder notification by Email triggered';
$lang['appointment_send_early_reminders_label'] = 'Send Reminders';
$lang['appointly_are_you_early_reminders'] = 'Are you sure you want to send  reminders for this appointment?';
$lang['appointly_reminders_sent'] = 'Appointment reminders has been sent to all attendees and contact';
$lang['appointment_manually_send_reminders_info'] = 'Manually send notification reminders to all attendees';
$lang['appointment_early_reminders_notice_label'] = 'Appointment is not Cancelled nor Finished to send Early Reminders';
$lang['appointment_email_read_at'] = 'Read at: ';
$lang['appointment_email_not_read'] = 'Not Read';
$lang['appoontment_sms_notification'] = 'SMS Notification';
$lang['appoontment_email_notification'] = 'Email Notification';

// ----------------------
// CALENDAR INTEGRATIONS
// ----------------------
// Google Calendar
$lang['appointly_calendar_integrations'] = 'Calendar Integrations';
$lang['appointment_add_to_google_calendar'] = 'Add to Google Calendar';
$lang['appointments_google_already_signed'] = 'You are already signed in to your Google Account.';
$lang['appointments_added_to_google_calendar'] = 'Added to Google Calendar';
$lang['appointments_sign_in_google'] = 'Sign In With Google';
$lang['appointments_google_revoke_confirm'] = 'Sign Out From Google';
$lang['appointments_google_revoke'] = 'Revoke current Google Calendar session and remove all permissions given to your google account.';
$lang['appointments_google_calendar_client_id'] = 'Google Calendar API Client Id <strong>(fetched from Settings->Google->API CLIENT ID)</strong>';
$lang['appointments_google_calendar_settings'] = 'Google Calendar API Settings';
$lang['appointments_google_calendar_client_secret'] = 'Google Calendar API Secret';
$lang['appointments_redirect_url'] = 'Google Authorization redirect URI';
$lang['appointly_show_google_appointments_from'] = 'Filter appointments by date range:';
$lang['appointments_delete_from_google_label'] = 'Before appointment is deleted also delete created appointment in your Google Calendar <small>(Only applies if Google Calendar is enabled and synced)</small>';
$lang['appointment_add_to_google_calendar_external'] = 'Include this external appointment to your google calendar (Mark as checked and Click Save)';
$lang['appointment_open_google_calendar'] = 'Open in Google Calendar';
$lang['appointment_google_not_added_yet'] = 'Seems like this appointment is not added to any staff members Google Calendar. Would you like to add this appointment to your Google Calendar?';
$lang['appointment_view_in_calendar'] = 'View in Google Calendar';
$lang['appointment_calendar_adding_to_google'] = 'Adding to Google Calendar...';
$lang['appointment_error_adding_to_calendar'] = 'Could not add to calendar. Please try again.';
$lang['event_not_found_in_google'] = 'Event may not exist in Google Calendar';
$lang['appointments_delete_from_google_calendar'] = 'Delete from Google Calendar';
$lang['appointments_synced_from_google'] = 'Synced From Google';
$lang['appointments_googlesync_show_in_table_label'] = 'If Google Calendar integration is active, display all Google Calendar appointments in the default table view.';
$lang['appointly_google_synced_title'] = ' Google Synced';
$lang['appointment_hide_google_calendar'] = 'Show Default View';
$lang['appointment_google_calendar_synced'] = 'Google Calendar Synced';
$lang['appointment_googlesync_only_today'] = 'Today';
$lang['appointment_googlesync_only_last_month'] = 'Last Month';
$lang['appointment_googlesync_only_last_three_months'] = 'Last 3 Months';
$lang['appointment_googlesync_only_last_six_months'] = 'Last 6 Months';
$lang['appointment_googlesync_only_last_year'] = 'Last Year';
$lang['appointment_googlesync_show_all'] = 'All';
$lang['appointly_not_including_two_way_synced_appointments'] = 'Not including two-way synced appointments';
$lang['appointment_external_calendar_event'] = 'External Calendar Event';

// Google Meet
$lang['appointment_google_meet_info'] = 'This appointment is added to Google Calendar, you can use Google Meet to meet online with your clients';
$lang['appointment_google_meet_info_2'] = 'This appointment is added to Google Calendar';
$lang['appointment_google_client_meet_info'] = 'Connect via Google Meet';
$lang['appointment_connect_via_google_meet'] = 'I wish to connect via Google Meet';
$lang['appointment_meet_message'] = 'Hello<br><br>Please follow this url to connect with me via Google Meet: ';
$lang['appointment_meeting_request_sent'] = 'Your meeting request message was successfully send';
$lang['appointment_leave_a_comment'] = 'Do you want to leave a comment';
$lang['appointment_google_meet_connect_message'] = 'Send email to attendees and ask to connect via Google Meet';
$lang['appointment_google_meet_modal_custom_label'] = 'Invite staff and clients to Google Meet via Email';
$lang['appointment_google_meet'] = 'Google Meet';
$lang['appointment_google_calendar'] = 'Google Calendar';

// Enhanced Google Meet Settings
$lang['appointment_google_meet_enhanced_settings'] = 'Enhanced Google Meet Settings';
$lang['appointly_auto_enable_google_meet'] = 'Automatically enable Google Meet for all appointments';
$lang['appointly_auto_enable_google_meet_help'] = 'When enabled, all new appointments will automatically include Google Meet links when synced to Google Calendar';
$lang['appointly_auto_add_to_google_on_approval'] = 'Automatically add to Google Calendar when approving external appointments';
$lang['appointly_auto_add_to_google_on_approval_help'] = 'When enabled, external appointments will be automatically added to the assigned staff member\'s Google Calendar when approved';
$lang['appointly_google_meet_default_settings'] = 'Default Google Meet Settings';
$lang['appointly_google_meet_enable_recording'] = 'Enable recording by default';
$lang['appointly_google_meet_enable_waiting_room'] = 'Enable waiting room by default';
$lang['appointly_google_meet_reminder_minutes'] = 'Default reminder time before meeting';
$lang['appointly_google_meet_reminder_help'] = 'Set the default reminder time for Google Meet appointments';
$lang['appointly_disable_google_meeting_emails'] = 'Disable Google Calendar email notifications';
$lang['appointly_disable_google_meeting_emails_help'] = 'When enabled, Google will not send automatic email notifications for calendar events';
$lang['appointly_minutes'] = 'minutes';
$lang['appointly_hour'] = 'hour';
$lang['appointly_hours'] = 'hours';

// Enhanced Google Meet Features
$lang['appointment_google_meet_join_before_start'] = 'Join Google Meet';
$lang['appointment_google_meet_copy_link'] = 'Copy Google Meet Link';
$lang['appointment_google_meet_link_copied'] = 'Google Meet link copied to clipboard';
$lang['appointment_google_meet_test_connection'] = 'Test Google Meet Connection';
$lang['appointment_google_meet_connection_success'] = 'Google Meet connection test successful';
$lang['appointment_google_meet_connection_failed'] = 'Google Meet connection test failed';
$lang['appointment_google_meet_quick_join'] = 'Google Meet';
$lang['appointment_google_meet_meeting_details'] = 'Meeting Details';
$lang['appointment_google_meet_dial_in'] = 'Dial-in Information';
$lang['appointment_google_meet_share_screen'] = 'Screen Sharing Available';
$lang['appointment_google_meet_record_meeting'] = 'Recording Available';
$lang['appointment_google_meet_waiting_room_enabled'] = 'Waiting Room Enabled';
$lang['appointment_google_meet_testing_connection'] = 'Testing Google Meet connection...';
$lang['appointment_google_meet_copy_failed'] = 'Failed to copy link. Please copy manually.';
$lang['appointment_google_meet_email_message'] = 'Email Message';
$lang['appointment_google_meet_send_invitation'] = 'Send Google Meet Invitation';
$lang['appointment_google_meet_message_required'] = 'Please enter a message to send';
$lang['sending'] = 'Sending...';
$lang['appointment_email_send_failed'] = 'Failed to send email. Please check your email settings.';
$lang['appointment_google_meet_send_to'] = 'Send To';
$lang['appointment_google_meet_primary_recipient'] = 'Primary Recipient';
$lang['appointment_google_meet_also_notify_attendees'] = 'Also notify staff attendees';
$lang['appointment_no_email_provided'] = 'No email address provided';
$lang['appointment_google_meet_hd_video_audio'] = 'HD Video & Audio';
$lang['appointment_google_meet_always_enabled'] = 'Always enabled';
$lang['appointment_google_meet_recording_enabled'] = 'Recording Enabled';
$lang['appointment_google_meet_recording_disabled'] = 'Recording Disabled';
$lang['appointment_google_meet_waiting_room_enabled_status'] = 'Waiting Room Enabled';
$lang['appointment_google_meet_waiting_room_disabled'] = 'Waiting Room Disabled';
$lang['appointment_google_meet_quick_actions'] = 'Quick Actions';
$lang['appointment_google_meet_join_meeting'] = 'Join Google Meet';
$lang['appointment_google_meet_send_invitation_btn'] = 'Send Invitation';

// Google Maps
$lang['appointment_google_maps'] = 'Open in Google Maps';
$lang['appointly_google_maps_not_shown'] = 'Google maps will not be shown.';
$lang['appointly_google_api_key_notset'] = 'Google API Key is not set please set Google API key in appointment settings';
$lang['appointly_message_will_hide'] = 'This message will be hidden in 5 seconds';

// Outlook Calendar
$lang['appointment_login_to_outlook'] = 'Sign In With Outlook';
$lang['appointment_logout_from_outlook'] = 'Sign Out from Outlook';
$lang['appointment_open_outlook_calendar'] = 'Open in Outlook Calendar';
$lang['appointments_outlook_revoke'] = 'Revoke current Outlook Calendar session and remove all permissions given to your outlook account.';
$lang['appointment_redirect_url_logout'] = 'Outlook Authorization and Redirect URI';
$lang['appointment_outlook_api_label'] = 'Outlook Calendar API';
$lang['appointment_outlook_client_id'] = 'Application (client) ID';
$lang['appointment_outlook_calendar'] = 'Outlook Calendar';
$lang['appointment_outlook_calendar_info'] = 'This appointment is added to Outlook Calendar';
$lang['appointment_add_to_outlook'] = 'Add to Outlook Calendar';
$lang['appointment_outlook_not_added_yet'] = 'Not added to Outlook Calendar';
$lang['appointment_is_added_to_outlook'] = 'Added to Outlook Calendar';
$lang['appointment_calendar_adding_to_outlook'] = 'Adding to Outlook Calendar...';
$lang['appointment_added_to_outlook'] = 'Event successfully added to Outlook Calendar';
$lang['appointment_added_to_outlook_but_not_saved'] = 'Event added to Outlook but failed to save in database';
$lang['appointment_outlook_event_saved'] = 'Outlook event details saved';
$lang['appointment_outlook_event_save_failed'] = 'Failed to save Outlook event details';
$lang['appointment_outlook_error'] = 'Error occurred while adding to Outlook';
$lang['appointment_outlook_auth_error'] = 'Outlook authentication error';
$lang['appointment_invalid_date'] = 'Invalid appointment date';
$lang['appointment_sign_in_to_outlook'] = 'Sign in to Outlook';
$lang['appointment_sign_out_from_outlook'] = 'Sign out from Outlook';
$lang['appointments_outlook_view_in_calendar'] = 'View in Outlook Calendar';
$lang['appointment_outlook_calendar_title'] = 'Outlook Calendar';
$lang['appointment_outlook_sync_status'] = 'Outlook Sync Status';
$lang['appointment_outlook_last_synced'] = 'Last synced: %s';
$lang['appointment_outlook_sync_error'] = 'Last sync failed: %s';
$lang['appointment_outlook_event_deleted'] = 'Outlook event deleted successfully';
$lang['appointment_outlook_event_delete_failed'] = 'Failed to delete Outlook event';
$lang['appointments_table_calendar'] = 'Added to Calendars';
$lang['appointment_not_added_to_calendars_yet'] = 'Not added to any calendar yet.';
$lang['permission_approve'] = 'Approve';
$lang['permission_view_reports'] = 'View Reports';
$lang['appointly_missing_required_fields'] = 'Missing required fields';
$lang['appointly_service_not_found'] = 'Service not found';
$lang['appointly_error_getting_time_slots'] = 'Error getting available time slots. Please try again.';
$lang['appointly_invalid_working_hours'] = 'Invalid working hours configuration';
$lang['appointly_service_price_invalid'] = 'Service price must be a valid number (0 or greater)';
$lang['appointly_service_duration_invalid'] = 'Service duration must be a positive number';
$lang['appointly_service_providers_required'] = 'At least one service provider must be assigned';
$lang['appointly_error_loading_providers'] = 'Error loading providers';
$lang['appointly_no_data_available'] = 'No data available';
$lang['appointly_please_try_again'] = 'Please try again';
$lang['appointly_installation_complete'] = 'Installation completed successfully';
$lang['appointly_database_updated'] = 'Database updated successfully';
$lang['appointly_menu_reset'] = 'Menu has been reset successfully';
$lang['appointly_default_service_created'] = 'Default service created successfully';
$lang['appointly_working_hours_configured'] = 'Working hours configured successfully';
$lang['appointment_select_service_provider_first'] = 'Please select service and provider first';
$lang['appointment_are_you_sure_to_cancel'] = 'Are you sure you want to cancel this appointment?';
$lang['appointment_are_you_sure_to_mark_as_ongoing'] = 'Are you sure you want to mark this appointment as ongoing?';
$lang['appointment_error_occurred'] = 'An error occurred. Please try again.';
$lang['appointment_closed'] = 'Appointment booking is currently closed';
$lang['appointment_time_required'] = 'Please select a time slot';
$lang['appointment_no_providers'] = 'No providers available for this service';
$lang['appointment_provider_not_available'] = 'Provider not available on this day';
$lang['appointment_minutes'] = 'minutes';
$lang['appointment_unavailable'] = 'Unavailable';
$lang['is_required'] = 'is required';
$lang['appointment_schedule_info'] = 'Appointment Schedule';
$lang['appointment_form_info'] = 'Appointment Information';
$lang['appointment_marked_as_approved'] = 'Appointment marked as approved';
$lang['appointment_cancellation_approval_failed'] = 'Failed to approve appointment cancellation';
$lang['appointment_send_an_sms'] = 'Send SMS';
$lang['appointment_call_number'] = 'Call';
$lang['appointment_actions'] = 'Actions';
$lang['appointment_staff_cannot_provide_feedback'] = 'Staff members cannot provide feedback for appointments';
$lang['appointment_thank_you_for_feedback'] = 'Thank you for your feedback!';
$lang['appointment_feedback_comment_required'] = 'Feedback comment is required';

// Reschedule functionality client side
$lang['appointment_reschedule'] = 'Reschedule';
$lang['appointment_reschedule_reason_required'] = 'Reason for reschedule is required';
$lang['appointment_reschedule_request_submitted'] = 'Your reschedule request has been submitted and will be reviewed by our staff.';
$lang['appointment_cannot_be_rescheduled'] = 'This appointment cannot be rescheduled due to its current status.';

$lang['appointment_processing'] = 'Processing...';
$lang['appointment_select_date_first'] = 'Please select a date first';
$lang['appointment_please_select_date_time'] = 'Please select a date and time';
$lang['appointment_current_details'] = 'Current Details';
$lang['appointment_loading_available_times'] = 'Loading available times...';
$lang['appointment_no_available_slots'] = 'No available slots';
$lang['appointment_no_available_times'] = 'No available times';

$lang['appointment_reschedule_requested'] = 'Reschedule Requested';
$lang['appointment_reschedule_pending_review'] = 'Your reschedule request is pending review by our staff.';
$lang['appointment_reschedule_pending_notice'] = 'Pending Reschedule Requests';
$lang['appointment_requested_date'] = 'Requested Date';
$lang['appointment_requested_time'] = 'Requested Time';
$lang['appointment_current_date'] = 'Current Date';
$lang['appointment_approve_reschedule'] = 'Approve Reschedule';
$lang['appointment_reject_reschedule'] = 'Reject Reschedule';
$lang['appointment_pending_reschedules'] = 'Pending Reschedules';
$lang['appointment_reschedule_approved'] = 'Reschedule Approved';
$lang['appointment_reschedule_rejected'] = 'Reschedule Rejected';
$lang['appointment_cancellation_requested'] = 'Cancellation Requested';
$lang['appointment_cancellation_pending_review'] = 'Your cancellation request is pending review by our staff.';
$lang['appointment_cancellation_reason'] = 'Cancellation Reason';
$lang['appointment_cancellation_notes'] = 'Cancellation Notes';
$lang['appointment_cancellation_notes_placeholder'] = 'Please explain why you want to cancel this appointment...';
$lang['appointment_cancellation_notes_required'] = 'Cancellation notes are required';
$lang['appointment_cancellation_request_submitted'] = 'Your cancellation request has been submitted and will be reviewed by our staff.';
$lang['appointment_confirm_approve_reschedule'] = 'Are you sure you want to approve this reschedule request? This will update the appointment to the new date and time.';
$lang['appointment_reschedule_denial_reason'] = 'Please provide a reason for denying this reschedule request (this will be sent to the client):';
$lang['appointment_reschedule_approved_successfully'] = 'Reschedule request has been approved and the appointment has been updated.';
$lang['appointment_reschedule_denied_successfully'] = 'Reschedule request has been denied and the client has been notified.';
$lang['appointment_reschedule_approval_failed'] = 'Failed to approve reschedule request. Please try again.';
$lang['appointment_reschedule_denial_failed'] = 'Failed to deny reschedule request. Please try again.';
$lang['appointment_view_details'] = 'View Details';
$lang['appointment_client_information'] = 'Client Information';
$lang['appointment_provider_information'] = 'Provider Information';
$lang['appointment_reschedule_action_required'] = 'Action Required';
$lang['appointment_reschedule_instructions'] = 'When clients request reschedules, they appear here for your approval. Approving will automatically update the appointment and notify the client via email.';
$lang['appointment_no_pending_reschedules'] = 'No pending reschedule requests found.';
$lang['appointment_reschedule_request_details'] = 'Reschedule Request Details';
$lang['appointment_reschedule_date_required'] = 'New date is required';
$lang['appointment_reschedule_time_required'] = 'New time is required';
$lang['appointment_reschedule_future_datetime'] = 'Please select a future date and time';
$lang['appointment_reschedule_request_subject'] = 'Appointment Reschedule Request';
$lang['appointment_reschedule_approved_subject'] = 'Appointment Reschedule Approved';
$lang['appointment_reschedule_denied_subject'] = 'Appointment Reschedule Denied';
$lang['appointment_book_again'] = 'Book Again';
$lang['appointment_cancelled_title'] = 'This appointment has been cancelled';
$lang['appointment_book_new_appointment'] = 'Would you like to book a new appointment?';
$lang['appointment_deny_reschedule'] = 'Deny Reschedule';
$lang['appointment_reschedule_denial_reason_prompt'] = 'Please provide a reason for denying this reschedule request:';
$lang['appointment_reschedule_denial_reason_required'] = 'A reason for denial is required';
$lang['appointment_confirm_approve_cancellation'] = 'Are you sure you want to approve this cancellation request? This will cancel the appointment permanently.';
$lang['appointment_cancelled_book_again_message'] = 'This appointment has been cancelled. Would you like to book a new appointment?';
$lang['appointment_no_show_book_again_message'] = 'This appointment was a no-show. Would you like to book a new appointment?';

// Calendar Integration Removal
$lang['appointment_remove_google_integration'] = 'Remove Google Calendar Integration';
$lang['appointment_remove_outlook_integration'] = 'Remove Outlook Calendar Integration';
$lang['appointment_confirm_remove_google_integration'] = 'Are you sure you want to remove Google Calendar integration from this appointment? This will also delete the event from Google Calendar if connected.';
$lang['appointment_confirm_remove_outlook_integration'] = 'Are you sure you want to remove Outlook Calendar integration from this appointment? This will also delete the event from Outlook Calendar if connected.';
$lang['appointment_google_integration_removed'] = 'Google Calendar integration removed from appointment';
$lang['appointment_google_integration_removed_and_deleted'] = 'Google Calendar integration removed and event deleted from Google Calendar';
$lang['appointment_google_removal_failed'] = 'Failed to remove Google Calendar integration';
$lang['appointment_outlook_integration_removed'] = 'Outlook Calendar integration removed from appointment';
$lang['appointment_outlook_integration_removed_and_deleted'] = 'Outlook Calendar integration removed and event deleted from Outlook Calendar';
$lang['appointment_outlook_removal_failed'] = 'Failed to remove Outlook Calendar integration';
$lang['appointment_missing_required_fields'] = 'Missing required fields';
$lang['appointment_not_found'] = 'Appointment not found';
$lang['appointment_outlook_not_authenticated_warning'] = 'Warning: You are not currently authenticated with Outlook. The integration will be removed locally only, but the event will remain in your Outlook calendar.';
$lang['appointment_outlook_not_available_warning'] = 'Warning: Outlook integration is not available. The integration will be removed locally only.';
$lang['appointment_outlook_integration_removed_local_only'] = 'Outlook calendar integration removed locally. Note: The event may still exist in your Outlook calendar.';

// Dashboard Widgets
$lang['appointly_upcoming_appointments'] = 'Upcoming Appointments';
$lang['appointly_no_upcoming_appointments'] = 'No Upcoming Appointments';
$lang['appointly_no_appointments_in_range'] = 'No appointments scheduled in the %s';
$lang['appointly_next_7_days'] = 'Next 7 Days';
$lang['appointly_next_14_days'] = 'Next 14 Days';
$lang['appointly_next_30_days'] = 'Next 30 Days';
$lang['appointly_next_4_weeks'] = 'Next 4 Weeks';
$lang['appointly_view_all_appointments'] = 'View All Appointments';
$lang['appointly_dashboard_widgets_settings'] = 'Dashboard Widgets Settings';
$lang['appointly_today_widget_enabled'] = 'Show today\'s appointments widget on dashboard';
$lang['appointly_upcoming_widget_enabled'] = 'Show upcoming appointments widget on dashboard';
$lang['appointly_upcoming_widget_range'] = 'Upcoming appointments widget date range';
$lang['appointly_tomorrow'] = 'Tomorrow';
$lang['days'] = 'Days';

$lang['appointly_invoice_default_vat'] = 'Default VAT/Tax Percentage';
$lang['appointly_invoice_vat_help'] = 'Default tax percentage to apply to auto-generated invoices (set to 0 for no tax)';
$lang['appointly_invoice_tax_type_help'] = 'Choose how you want to apply taxes to appointment invoices';
$lang['appointly_invoice_tax_type_label'] = 'Tax Application Method';
$lang['appointly_tax_type_none'] = 'No Tax';
$lang['appointly_tax_type_custom'] = 'Custom Percentage';
$lang['appointly_tax_type_system'] = 'Use CRM Tax Rates';
$lang['appointly_default_vat_label'] = 'Custom Tax Percentage';
$lang['appointly_default_vat_help'] = 'Custom tax percentage to apply to invoices (set to 0 for no tax)';
$lang['appointly_system_tax_label'] = 'Select Tax Rate';
$lang['appointly_system_tax_help'] = 'Choose from your configured tax rates in the CRM';

// Enhanced Invoice Settings - Tab Names
$lang['appointly_invoice_settings'] = 'Invoice & Taxes';
$lang['appointly_tax_settings'] = 'Tax Configuration';
$lang['appointly_tax_settings_help'] = 'Configure how taxes are applied to invoices created from appointments. You can use the CRM\'s tax system or set a custom percentage.';
$lang['appointly_tax_type_label'] = 'Tax Application Method';
$lang['appointly_tax_type_help'] = 'Choose how you want to apply taxes to appointment invoices';

// Form Field Labels
$lang['appointly_enable'] = 'Enable';
$lang['appointly_disable'] = 'Disable';
$lang['appointly_yes'] = 'Yes';
$lang['appointly_no'] = 'No';

// Client Dashboard Language Strings
$lang['appointment_client_dashboard_description'] = 'Manage your appointments, view history, and book new appointments.';
$lang['appointment_book_new'] = 'Book New Appointment';
$lang['appointment_all'] = 'All';
$lang['appointment_total_appointments'] = 'Total Appointments';
$lang['appointment_completed_appointments'] = 'Completed';
$lang['appointment_upcoming_appointments'] = 'Upcoming';
$lang['appointment_cancelled_appointments'] = 'Cancelled';
$lang['appointment_no_appointments_found'] = 'No appointments found';
$lang['appointment_no_appointments_match_filter'] = 'No appointments match the current filter';
$lang['appointment_date_and_time'] = 'Date & Time';
$lang['appointment_details'] = 'Appointment Details';
$lang['view_invoice'] = 'View Invoice';

// Cancel and Reschedule
$lang['appointment_cancel_reason'] = 'Cancellation Reason';
$lang['appointment_cancel_reason_placeholder'] = 'Please provide a reason for cancelling this appointment...';
$lang['appointment_reschedule_reason'] = 'Reschedule Reason';
$lang['appointment_reschedule_reason_placeholder'] = 'Please provide a reason for rescheduling this appointment...';
$lang['appointment_new_date'] = 'New Date';
$lang['appointment_new_time'] = 'New Time';
$lang['appointment_request_reschedule'] = 'Request Reschedule';
$lang['appointment_cancel_request_sent'] = 'Cancellation request has been sent to staff for approval.';
$lang['appointment_cancel_request_failed'] = 'Failed to send cancellation request. Please try again.';
$lang['appointment_reschedule_request_sent'] = 'Reschedule request has been sent to staff for approval.';

// ICS Calendar Export
$lang['appointment_add_to_calendar'] = 'Add to Calendar';
$lang['appointment_download_ics'] = 'Download .ics file';
$lang['appointment_ics_description'] = 'Download this appointment as a calendar file (.ics) to import into any calendar application (Apple Calendar, Google Calendar, Outlook, etc.)';
$lang['appointment_calendar_file'] = 'Calendar File';
$lang['appointment_ics_tooltip'] = 'Download a standard calendar file that works with all calendar applications';
$lang['appointment_ics_file_downloaded'] = 'Calendar file downloaded successfully';
$lang['appointment_ics_download_error'] = 'Error downloading calendar file';
$lang['appointment_reschedule_request_failed'] = 'Failed to send reschedule request. Please try again.';
$lang['appointment_client_dashboard'] = 'Client Dashboard';
$lang['appointment_available_times'] = 'Available Times';
$lang['appointment_error_loading_times'] = 'Error loading times';
$lang['appointment_cancel_request_submitted'] = 'Cancellation request submitted successfully';
$lang['appointment_date_time_required'] = 'Date and time are required';
$lang['appointment_reschedule_pending'] = 'Reschedule request pending approval';
$lang['appointly_invoice_payment_mode_changed'] = 'Invoice payment mode changed, please save settings to apply changes';
$lang['payment_received_for_appointment'] = 'Payment received for:';
$lang['appointly_create_invoice_when_completed'] = 'Create invoice when appointment is booked?';
$lang['invoice_created_for_appointment'] = 'Invoice #%s has been created for this appointment.';
$lang['appointment_email_sent_success'] = 'Email sent successfully';
$lang['appointment_email_sent_failed'] = 'Failed to send email';
$lang['customer_permission_appointments'] = 'Appointments';
$lang['appointment_contact_relationship'] = 'Contact & Relationship Info';
$lang['appointment_download_ics_tooltip'] = 'Download calendar file (.ics) to add this appointment to your calendar application';
$lang['appointment_security_verification'] = 'Security Verification';
$lang['appointment_view_on_map'] = 'View on Map';
$lang['appointment_no_notes_available'] = 'No notes available for this appointment';
$lang['appointment_session_overview'] = 'Session Overview';
$lang['appointly_show_staff_email_booking_form'] = 'Show staff email addresses in booking form';
$lang['appointly_show_staff_phone_booking_form'] = 'Show staff phone numbers in booking form';
$lang['appointly_no_available_time_slots'] = 'No time slots available';
$lang['appointment_status_changed_successfully'] = 'Appointment status changed successfully';
$lang['appointment_status_change_failed'] = 'Failed to change appointment status';

// Staff appointments availability settings
$lang['appointly_staff_respect_availability'] = 'Staff appointments respect availability restrictions';
$lang['appointly_staff_respect_availability_tooltip'] = 'When enabled, staff-only appointments will respect working hours, busy times, and other availability restrictions just like client appointments. When disabled, staff can schedule meetings at any time.';

// Blocked days calendar tooltips
$lang['appointment_blocked_date_tooltip'] = 'Company Holiday/Blocked Date - Cannot be selected';
$lang['appointment_past_date_tooltip'] = 'Past date - Cannot be selected';
$lang['appointment_available_date_tooltip'] = 'Available for blocking - Click to select';

// Provider change notifications
$lang['appointment_provider_removed'] = 'You have been removed as the provider for an appointment';
$lang['appointment_provider_assigned'] = 'You have been assigned as the provider for an appointment';

// Attendee change notifications
$lang['appointment_attendee_removed'] = 'You have been removed from an appointment';

// Status change notifications
$lang['appointment_marked_as_completed'] = 'An appointment has been marked as completed';
$lang['appointment_marked_as_cancelled'] = 'An appointment has been marked as cancelled';
$lang['appointment_updating'] = 'Updating...';
$lang['appointment_requested_at'] = 'Requested at';

// Button text
$lang['appointment_save'] = 'Save';
$lang['appointment_cancel_btn'] = 'Cancel';
$lang['appointment_delete_btn'] = 'Delete';

// Status and general terms
$lang['appointment_unknown'] = 'Unknown';
$lang['appointment_all_day'] = 'All Day';
$lang['appointment_to_be_confirmed'] = 'To be confirmed';
$lang['appointment_timezone'] = 'Timezone';

// Error messages
$lang['appointment_error_loading_details'] = 'Error loading appointment details';
$lang['appointment_error_loading_contacts'] = 'Error loading contacts';
$lang['appointment_error_loading_blocked_days'] = 'Error loading blocked days';
$lang['appointment_error_loading_time_slots'] = 'Error loading time slots';
$lang['appointment_unknown_error'] = 'Unknown error';

// Alerts and notifications
$lang['appointment_please_select_time_slot'] = 'Please select an available time slot';
$lang['appointment_error_loading_invoice'] = 'Error loading invoice';

// Removed console debug variables - not used in production code

// Working hours and availability
$lang['appointment_no_working_hours_data'] = 'No working hours data available for HTML generation';
$lang['appointment_no_html_generated'] = 'No HTML generated for working hours';
$lang['appointment_error_generating_html'] = 'Error generating working hours HTML';

// Settings and configuration
$lang['appointment_settings_update_failed'] = 'Settings update failed';

// Languages dropdown in external form
$lang['appointments_external_form_show_language_dropdown'] = 'Show Language Dropdown';
$lang['appointments_external_form_show_language_dropdown_help'] = 'Enable this to show a language selector dropdown on the external booking form, allowing clients to switch languages';

// Google Calendar duplicate prevention
$lang['appointment_already_in_google_calendar'] = 'This appointment is already added to Google Calendar';

// Recurring appointments UI
$lang['recurring_appointment'] = 'Recurring Appointment';
$lang['recurring'] = 'Recurring';
$lang['recurring_every'] = 'Every';
$lang['recurring_day'] = 'Day(s)';
$lang['recurring_week'] = 'Week(s)';
$lang['recurring_month'] = 'Month(s)';
$lang['recurring_year'] = 'Year(s)';
$lang['stop_recurring'] = 'Stop Recurring';
$lang['stop_recurring_confirm'] = 'Are you sure you want to stop this recurring appointment? No new instances will be created.';
$lang['recurring_stopped_successfully'] = 'Recurring appointments stopped successfully';
$lang['edit_recurring_settings'] = 'Edit Recurring Settings';
$lang['error_occurred'] = 'An error occurred. Please try again.';
