$(function () {
    "use strict";
    init_ajax_search('contact', '#contactid.ajax-search', {
        contact_userid: userid
    });

    appValidateForm($("#assign_plan_to_client_create_tenant"), {
        contactid: "required",
        tenant_plan: "required",
        tenants_name: {
            required: true,
            remote: {
                url: admin_url + "saas/superadmin/validateTenantsName",
                type: 'post',
                data: {
                    tenants_name: function () {
                        return $('input[name="tenants_name"]').val();
                    },
                    userid: function () {
                        return userid;
                    }
                }
            }
        },
    }, manage_create_tenant_form, {
        tenants_name: {
            remote: "Tenant name already exist! Please try another name"
        }
    });

    $("#tenants_name").trigger("keyup");

});

function manage_create_tenant_form(form) {
    $("#submit").prop('disabled', true).prepend('<i class="fa fa-spinner fa-pulse"></i> ');
    $.post(form.action, $(form).serialize()).done(function (response) {
        location.reload();
    });
}

$(document).on('keyup', '#tenants_name', function (event) {
    value = $(this).val().replace(/[^a-zA-Z0-9 ]/g, "").toLowerCase()
    $(this).val(value);
    value = value.replace(/ /g, '');
    $("#tenants_name").val(value);
    $("#display_subdomain").html(value);
});

/**
 * Settings Code: Start
 */
$('#settings').on('change', function () {
    var view_path = $(this).val();
    $.ajax({
        url: `${admin_url}saas/superadmin/get_settings_view_page`,
        type: 'POST',
        data: {
            userid: userid,
            view_path: $(this).val(),
        },
        dataType: 'json',
    }).done(function (res) {
        $('#settings_view').html(res.view);
        init_selectpicker();
        appColorPicker();
        if(view_path == "admin/settings/includes/tags"){
            $('#settings_view a').each(function(){
                setting_link = $(this).attr("href");
                superadmin_link = setting_link.replace("/settings", "/saas/superadmin");
                superadmin_link += "/"+userid;
                $(this).attr("href", superadmin_link);
            });
        }
        if(view_path == "admin/settings/includes/email"){
            $('#settings_view #email_queue a').each(function(){
                setting_link = $(this).attr("href");
                superadmin_link = setting_link.replace("/emails", "/saas/superadmin");
                superadmin_link += "/"+userid;
                $(this).attr("href", superadmin_link);
            });
        }
        if(view_path == "admin/settings/includes/google" || view_path == "admin/settings/includes/tickets" || view_path == "admin/settings/includes/cronjob"){
            var url = new URL(site_url);
            var scheme = url.protocol;
            var domain = url.hostname;

            var info_text = $("#cron_command .alert-info span.text-info").text();
            info_text = info_text.replace(site_url, `${scheme}//${tenants_name}.${domain}/`);
            $("#cron_command .alert-info span.text-info").text(info_text);

            var area_val = $('#settings_view textarea').text();
            area_val = area_val.replace(site_url, `${scheme}//${tenants_name}.${domain}/`);
            $('#settings_view textarea').text(area_val);

            $('#settings_view a').not("[role='tab']").each(function(){
                setting_link = $(this).attr("href");
                var new_link = setting_link.replace(site_url, `${scheme}//${tenants_name}.${domain}/`);
                $(this).attr("href", new_link);

                setting_text = $(this).text();
                var new_text = setting_text.replace(site_url, `${scheme}//${tenants_name}.${domain}/`);
                $(this).text(new_text);
            });
        }
        if(view_path == "admin/settings/includes/general"){
            $('#settings_view a').each(function(){
                setting_link = $(this).attr("href");
                superadmin_link = setting_link.replace("/settings", "/saas/superadmin");
                superadmin_link += "/"+userid;
                $(this).attr("href", superadmin_link);
            });
        }
        init_settings_js();
    });
});

// Copy: Start
function init_settings_js(){
    $('input[name="settings[mail_engine]"]').on('change', function() {
        if ($(this).val() == 'codeigniter') {
            $('.protocol-microsoft').addClass('hide');
            $('.protocol-google').addClass('hide');
    
            if ($('input[name="settings[email_protocol]"]:checked').val() == 'microsoft') {
                $('#smtp').prop('checked', true)
                $('#microsoft').trigger('change')
            }
    
            if ($('input[name="settings[email_protocol]"]:checked').val() == 'google') {
                $('#smtp').prop('checked', true)
                $('#google').trigger('change')
            }
        } else {
            $('.protocol-microsoft').removeClass('hide');
            $('.protocol-google').removeClass('hide');
        }
    });
    
    $('input[name="settings[email_protocol]"]').on('change', function() {
        var $inputHost = $('input[name="settings[smtp_host]"]');
        var $inputPort = $('input[name="settings[smtp_port]"]');
        var $selectEnc = $('select[name="settings[smtp_encryption]"]');
    
        var resetFields = function() {
            if ($selectEnc.hasClass('_modified')) {
                $selectEnc.selectpicker('val', '');
                $selectEnc.removeClass('_modified');
            }
    
            if ($inputPort.hasClass('_modified')) {
                $inputPort.val('');
                $inputPort.removeClass('_modified');
            }
    
            if ($inputHost.hasClass('_modified')) {
                $inputHost.val('');
                $inputHost.removeClass('_modified');
            }
        }
    
        if ($(this).val() == 'mail') {
            $('.xoauth-hide').addClass('hide');
            $('.smtp-fields').addClass('hide');
            $('.xoauth-microsoft-show').addClass('hide');
            $('.xoauth-google-show').addClass('hide');
            resetFields();
        } else if ($(this).val() === 'microsoft' || $(this).val() === 'google') {
            $('.smtp-fields').removeClass('hide');
            $('.xoauth-hide').addClass('hide');
            $('.xoauth-microsoft-show').addClass('hide');
            $('.xoauth-google-show').addClass('hide');
    
            if($(this).val() === 'microsoft') {
                $('.xoauth-microsoft-show').removeClass('hide');
                if ($inputHost.val() == '') {
                    $inputHost.val('smtp.office365.com')
                    $inputHost.addClass('_modified');
                }
            }
            
            if($(this).val() === 'google') {
                $('.xoauth-google-show').removeClass('hide');
                if ($inputHost.val() == '') {
                    $inputHost.val('smtp.gmail.com')
                    $inputHost.addClass('_modified');
                }
            }
    
            if ($inputPort.val() == '') {
                $inputPort.val('587')
                $inputPort.addClass('_modified');
                if ($selectEnc.selectpicker('val') == '') {
                    $selectEnc.selectpicker('val', 'tls');
                    $selectEnc.addClass('_modified');
                }
            }
        } else {
            $('.smtp-fields').removeClass('hide');
            $('.xoauth-hide').removeClass('hide');
            $('.xoauth-microsoft-show').addClass('hide');
            $('.xoauth-google-show').addClass('hide');
            resetFields();
        }
    });

    $('.sms_gateway_active input').on('change', function() {
        if ($(this).val() == '1') {
            $('body .sms_gateway_active').not($(this).parents('.sms_gateway_active')[0]).find(
                'input[value="0"]').prop('checked', true);
        }
    });


    $('input[name="settings[pusher_realtime_notifications]"]').on('change', function() {
        if ($(this).val() == '1') {
            $('input[name="settings[desktop_notifications]"]').prop('disabled', false);
        } else {
            $('input[name="settings[desktop_notifications]"]').prop('disabled', true);
            $('input[name="settings[desktop_notifications]"][value="0"]').prop('checked', true);
        }
    });

    $('.test_email').on('click', function() {
        var email = $('input[name="test_email"]').val();
        if (email != '') {
            $(this).attr('disabled', true);
            $.post(admin_url + 'saas/superadmin/sent_smtp_test_email'+"/"+userid, {
                test_email: email
            }).done(function(data) {
                // window.location.reload();
            });
        }
    });

    $('input[name="settings[reminder_for_completed_but_not_billed_tasks]"]').on('change', function() {
        if ($(this).val() == '1') {
            $('.staff_notify_completed_but_not_billed_tasks_fields').removeClass('hide');
        } else {
            $('.staff_notify_completed_but_not_billed_tasks_fields').addClass('hide');
        }
    });
}

/**
 * Settings Code: End
 */